/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.plot;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JPanel;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class CountAnalysisContourPlot
extends JPanel {
    private BufferedImage image = null;
    private int startX;
    private int stopX;
    private int startY;
    private int stopY;
    private final AbstractDataMatrix matrix;
    private boolean isthreshold;
    private double minthreshold;
    private double maxthreshold;
    private InnerColumnClass ic;
    private short classIndex;

    public CountAnalysisContourPlot(AbstractDataMatrix abstractDataMatrix) {
        this.matrix = abstractDataMatrix;
    }

    public void contentPaint() {
        double d;
        double d2;
        int n = this.getWidth();
        int n2 = this.getHeight();
        double d3 = this.matrix.getK();
        double d4 = (double)n / d3;
        if (d4 > (d2 = (double)n2 / (d = (double)this.matrix.getN()))) {
            n = (int)((double)n / d4 * d2);
            d4 = d2;
        } else {
            n2 = (int)((double)n2 / d2 * d4);
            d2 = d4;
        }
        d2 *= -1.0;
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        this.image = new BufferedImage(n, n2, 2);
        double d5 = 1.0 / d4;
        double d6 = -1.0 / d2;
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        if (d6 < 1.0) {
            d6 = 1.0;
        }
        WritableRaster writableRaster = this.image.getRaster();
        this.startX = 0;
        this.startY = 0;
        for (double d7 = 0.0; d7 < d; d7 += d6) {
            this.stopY = this.minCeil((d7 + d6) / d, n2);
            if (this.startY == this.stopY) continue;
            this.startX = 0;
            for (double d8 = 0.0; d8 < d3; d8 += d5) {
                this.stopX = this.minCeil((d8 + d5) / d3, n);
                if (this.startX == this.stopX) continue;
                this.setBlackSample(writableRaster, (int)d7, (int)d8);
                this.startX = this.stopX;
            }
            this.startY = this.stopY;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.image != null) {
            graphics2D.drawImage((Image)this.image, 0, 0, null);
        }
    }

    public void setValues(boolean bl, double d, double d2, InnerColumnClass innerColumnClass, String string) {
        this.isthreshold = bl;
        this.minthreshold = d;
        this.maxthreshold = d2;
        this.ic = innerColumnClass;
        this.classIndex = (short)-1;
        if (innerColumnClass != null) {
            ClassTypes classTypes = innerColumnClass.getObject();
            if (string != null) {
                this.classIndex = classTypes.getTypeDescriptionIndex(string);
            }
        }
        this.contentPaint();
    }

    private int minCeil(double d, int n) {
        return (int)Math.min(Math.ceil(d * (double)n), (double)n);
    }

    private void setBlackSample(WritableRaster writableRaster, int n, int n2) {
        int n3;
        boolean bl = false;
        if (this.isthreshold) {
            double d = this.matrix.getValue(n, n2);
            bl = d >= this.minthreshold && d <= this.maxthreshold;
        } else {
            int[] nArray = this.matrix.getNref();
            int[] nArray2 = this.matrix.getKref();
            n3 = n2 * this.matrix.getFoldN() + n;
            if (nArray2 != null && nArray != null && n2 < nArray2.length && n < nArray.length) {
                n3 = nArray2[n2] * this.matrix.getFoldN() + nArray[n];
            }
            if (this.ic != null && n3 < this.ic.getSize()) {
                short s = this.ic.getValueShort(n3);
                bl = s == this.classIndex || this.classIndex == -1 && s > 0;
            }
        }
        boolean bl2 = this.matrix.isMissing(n, n2);
        for (int i = this.startY; i < this.stopY; ++i) {
            for (n3 = this.startX; n3 < this.stopX; ++n3) {
                if (!bl || bl2) continue;
                writableRaster.setSample(n3, i, 0, 0);
                writableRaster.setSample(n3, i, 1, 0);
                writableRaster.setSample(n3, i, 2, 0);
                writableRaster.setSample(n3, i, 3, 255);
            }
        }
    }
}

