/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.plot;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.WritableRaster;
import se.prediktera.image.count.CountAnalysisPanel;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.spectral.AbstractPlotPanel;

public class CountAnalysisHistogramPlot
extends AbstractPlotPanel {
    private final int[] histogram = new int[100];
    private double minThreshold = 0.0;
    private double maxThreshold = 100.0;
    private byte selected = 0;
    private final CountAnalysisPanel caPanel;

    public CountAnalysisHistogramPlot(CountAnalysisPanel countAnalysisPanel, AbstractDataMatrix abstractDataMatrix, double d, double d2) {
        this.caPanel = countAnalysisPanel;
        int n = 0;
        double d3 = abstractDataMatrix.getK();
        double d4 = abstractDataMatrix.getN();
        double d5 = d2 - d;
        int n2 = 0;
        while ((double)n2 < d4) {
            int n3 = 0;
            while ((double)n3 < d3) {
                if (!abstractDataMatrix.isMissing(n2, n3)) {
                    int n4 = (int)((abstractDataMatrix.getValue(n2, n3) - d) / d5 * (double)this.histogram.length);
                    if (n4 >= this.histogram.length) {
                        n4 = this.histogram.length - 1;
                    }
                    int n5 = n4;
                    this.histogram[n5] = this.histogram[n5] + 1;
                    if (n < this.histogram[n4]) {
                        n = this.histogram[n4];
                    }
                }
                ++n3;
            }
            ++n2;
        }
        this.setMinMax(0.0 - (double)this.histogram.length * 0.05, (double)this.histogram.length * 1.05, 0.0 - (double)n * 0.05, (double)n * 1.05, 1.0);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.selected > 0) {
            Point point = mouseEvent.getPoint();
            double[] dArray = new double[2];
            this.Screen2Real(dArray, point.x, point.y);
            double d = (int)dArray[0];
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 100.0) {
                d = 100.0;
            }
            if (this.selected == 1) {
                this.minThreshold = d;
            } else {
                this.maxThreshold = d;
            }
            this.caPanel.setThreshold(this.minThreshold, this.maxThreshold);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        Point point = mouseEvent.getPoint();
        double[] dArray = new double[2];
        this.Screen2Real(dArray, point.x, point.y);
        if (this.isInside(dArray[0], this.minThreshold) || this.isInside(dArray[0], this.maxThreshold)) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        Point point = mouseEvent.getPoint();
        double[] dArray = new double[2];
        this.Screen2Real(dArray, point.x, point.y);
        this.selected = this.isInside(dArray[0], this.minThreshold) ? (byte)1 : (this.isInside(dArray[0], this.maxThreshold) ? (byte)2 : (byte)0);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.red);
        graphics2D.setStroke(AbstractPaint.stroke2);
        double[] dArray = new double[2];
        this.Real2Screen(dArray, this.minThreshold, 0.0);
        graphics2D.drawLine((int)dArray[0], this.sy, (int)dArray[0], this.getHeight() - this.ey - 1);
        this.Real2Screen(dArray, this.maxThreshold, 0.0);
        graphics2D.drawLine((int)dArray[0], this.sy, (int)dArray[0], this.getHeight() - this.ey - 1);
    }

    public void setThreshold(double d, double d2) {
        this.minThreshold = d;
        this.maxThreshold = d2;
        this.repaint();
    }

    @Override
    protected String getXaxisDesc() {
        return "Bins";
    }

    @Override
    protected String getYaxisDesc() {
        return "";
    }

    @Override
    protected void paint(WritableRaster writableRaster, Graphics2D graphics2D, int n, int n2, AbstractPlotPanel.ContentType contentType) {
        if (contentType.equals((Object)AbstractPlotPanel.ContentType.Base)) {
            graphics2D.setColor(Color.black);
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            this.Real2Screen(dArray2, 0.0, 0.0);
            this.Real2ScreenLength(dArray3, 1.0, 1.0);
            for (int i = 0; i < this.histogram.length; ++i) {
                this.Real2Screen(dArray, i, this.histogram[i]);
                graphics2D.fillRect((int)dArray[0], (int)dArray[1], (int)Math.ceil(dArray3[0]), (int)dArray2[1] - (int)dArray[1]);
            }
        }
    }

    private boolean isInside(double d, double d2) {
        return d > d2 - 1.0 && d < d2 + 1.0;
    }
}

