/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.shrink;

import java.awt.Point;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.image.count.algorithm.ObjectIdentificationAlgorithm;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.breeze.image.count.IdentifiedObject;
import se.prediktera.map.dataimport.image.Pixel;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnShort;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;

public class ShrinkAnalysisInfo
extends AbstractAnalysisInfo {
    private boolean shrink = true;
    private final int[][] cursor_maximum = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};

    @Override
    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        Object object = objectArray[0];
        if (object instanceof DataSet) {
            DataSet dataSet = (DataSet)object;
            object = null;
            if (objectArray.length > 1 && objectArray[1] instanceof DataSet) {
                object = (DataSet)objectArray[1];
            }
            if (ScriptHelper.hasKey(properties, "grow")) {
                this.shrink = !ScriptHelper.getPropertyBool(properties, "grow");
            }
            List<Integer> list = this.getIndexList(progressManager, dataSet, properties);
            if (ScriptHelper.hasKey(properties, "index")) {
                Double[] doubleArray = new Double[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    doubleArray[i] = (double)list.get(i).intValue() + 1.0;
                }
                return doubleArray;
            }
            progressManager.setInfoText("Shrinking image dataset");
            ObservationInfo observationInfo = dataSet.getObsDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(1);
            if (ScriptHelper.hasKey(properties, "train") && ScriptHelper.getPropertyBool(properties, "train")) {
                innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(4);
            }
            if (object != null) {
                ObservationInfo observationInfo2 = ((DataSet)object).getObsDataInfo();
                innerColumnBoolean = (InnerColumnBoolean)observationInfo2.getPrimaryColumnByType(1);
            }
            for (Integer n : list) {
                innerColumnBoolean.setValueBool(n, !this.shrink);
            }
            dataSet.updateReferences();
            if (object != null) {
                ((DataSet)object).updateReferences();
            }
            return dataSet;
        }
        throw new RuntimeException("Illigal parameter, excepted dataset");
    }

    private List<Integer> getIndexList(ProgressManager progressManager, DataSet dataSet, Properties properties) {
        Object object;
        int n;
        Object object2;
        Cloneable cloneable;
        int n2;
        int n3;
        int n4 = ScriptHelper.getPropertyInt(properties, "distance");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (ScriptHelper.hasKey(properties, "edge")) {
            bl = ScriptHelper.getPropertyBool(properties, "edge");
        }
        if (ScriptHelper.hasKey(properties, "outeredge")) {
            bl2 = ScriptHelper.getPropertyBool(properties, "outeredge");
        }
        if (ScriptHelper.hasKey(properties, "edgecategory")) {
            string = ScriptHelper.getProperty(properties, "edgecategory");
            string2 = ScriptHelper.getProperty(properties, "edgeclass");
        }
        if (ScriptHelper.hasKey(properties, "sample")) {
            bl3 = ScriptHelper.getPropertyBool(properties, "sample");
        }
        if (ScriptHelper.hasKey(properties, "area")) {
            bl4 = ScriptHelper.getPropertyBool(properties, "area");
        }
        if (ScriptHelper.hasKey(properties, "predcategory")) {
            string3 = ScriptHelper.getProperty(properties, "predcategory");
        }
        if (ScriptHelper.hasKey(properties, "grow")) {
            this.shrink = !ScriptHelper.getPropertyBool(properties, "grow");
        }
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
        progressManager.setInfoText("Calculating pixel for shrinking");
        if (abstractDataMatrix instanceof FoldMatrix || abstractDataMatrix instanceof LayerMatrix) {
            n3 = abstractDataMatrix.getFoldN();
            n2 = abstractDataMatrix.getN() / n3;
        } else {
            n3 = abstractDataMatrix.getN();
            n2 = abstractDataMatrix.getK();
        }
        MVmatrix mVmatrix = new MVmatrix(n3, n2);
        Matrix matrix = mVmatrix.getInternalMatrixPublic();
        boolean[][] blArray = new boolean[n3][n2];
        if (string != null) {
            cloneable = dataSet.getCategory(string);
            object2 = ((InnerColumnClass)cloneable).getObject();
            n = ((ClassTypes)object2).getTypeDescriptionIndex(string2);
            object = new Threader(this, (InnerColumnClass)cloneable, n3, n, matrix){
                final /* synthetic */ InnerColumnClass val$icc;
                final /* synthetic */ int val$N;
                final /* synthetic */ int val$classindex;
                final /* synthetic */ Matrix val$internalBinaryMatrix;
                {
                    this.val$icc = innerColumnClass;
                    this.val$N = n22;
                    this.val$classindex = n3;
                    this.val$internalBinaryMatrix = matrix;
                }

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    for (int i = n; i < n22; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            if (this.val$icc.getValueShort(j * this.val$N + i) != this.val$classindex) continue;
                            this.val$internalBinaryMatrix.set(i, j, 1.0);
                        }
                    }
                }
            };
            ((Threader)object).execute(n3);
        } else {
            boolean bl5 = true;
            if (ScriptHelper.hasKey(properties, "train") && ScriptHelper.getPropertyBool(properties, "train")) {
                bl5 = false;
            }
            object2 = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(bl5 ? 1 : 4);
            Threader threader = new Threader(this, (InnerColumnBoolean)object2, n3, matrix){
                final /* synthetic */ InnerColumnBoolean val$icb;
                final /* synthetic */ int val$N;
                final /* synthetic */ Matrix val$internalBinaryMatrix;
                final /* synthetic */ ShrinkAnalysisInfo this$0;
                {
                    this.val$icb = innerColumnBoolean;
                    this.val$N = n22;
                    this.val$internalBinaryMatrix = matrix;
                    this.this$0 = shrinkAnalysisInfo;
                }

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    for (int i = n; i < n22; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            if (this.val$icb.getValueBool(j * this.val$N + i) != this.this$0.shrink) continue;
                            this.val$internalBinaryMatrix.set(i, j, 1.0);
                        }
                    }
                }
            };
            threader.execute(n3);
        }
        if (bl4) {
            cloneable = (PredictionClasses)observationInfo.getGroupColumnByType(11);
            if (cloneable == null) {
                throw new RuntimeException("No prediction category for matrix");
            }
            object2 = (InnerColumnPredClass)((DataGroupValues)cloneable).getInnerColumnByName(string3);
            int[] nArray = ((InnerColumnClass)object2).countClasses();
            if (n4 < 0) {
                for (int i = 2; i < nArray.length; ++i) {
                    if (n4 >= nArray[i]) continue;
                    n4 = nArray[i];
                }
            }
            int n5 = ((AbstractInnerColumn)object2).getSize();
            for (int i = 0; i < n5; ++i) {
                short s = ((InnerColumnShort)object2).getValueShort(i);
                if (nArray[s] >= n4) continue;
                arrayList.add(i);
            }
        } else if (bl3) {
            cloneable = (Transformations)observationInfo.getGroupColumnByType(10);
            object2 = null;
            if (cloneable != null) {
                PredictionClasses predictionClasses;
                for (n = 0; n < ((Transformations)cloneable).getColumnCount(); ++n) {
                    if (((Transformations)cloneable).getColumnType(n) != 4) continue;
                    object2 = (InnerColumnClass)((Transformations)cloneable).getInnerColumn(n);
                    break;
                }
                if (object2 == null && (predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11)) != null && predictionClasses.getColumnCount() > 0) {
                    for (int i = 0; i < predictionClasses.getColumnCount(); ++i) {
                        object2 = (InnerColumnClass)predictionClasses.getInnerColumn(i);
                    }
                }
                if (object2 != null) {
                    int n6 = -n4;
                    for (int i = 0; i < n3 + n4; ++i) {
                        int n7;
                        if (i < n3) {
                            for (n7 = 0; n7 < n2; ++n7) {
                                if (matrix.get(i, n7) != 1.0 || ((InnerColumnShort)object2).getValueShort(n7 * n3 + i) <= 1) continue;
                                n6 = i + 1;
                                break;
                            }
                        }
                        if (i < n6 + n4 * 2) continue;
                        for (n7 = 0; n7 < n2; ++n7) {
                            arrayList.add(n7 * n3 + i - n4);
                        }
                    }
                }
            }
        } else if (bl || bl2) {
            if (bl2) {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        if (matrix.get(i, j) != 0.0 || blArray[i][j]) continue;
                        this.coverArea(matrix, blArray, i, j, n3, n2);
                    }
                }
            }
            cloneable = ObjectIdentificationAlgorithm.identifyAreas(mVmatrix, properties);
            object2 = ((AbstractSequentialList)((Object)cloneable)).iterator();
            while (object2.hasNext()) {
                IdentifiedObject identifiedObject = (IdentifiedObject)object2.next();
                object = identifiedObject.getPointList();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Pixel pixel = (Pixel)iterator.next();
                    if (pixel.z >= n4) continue;
                    arrayList.add(pixel.x * n3 + pixel.y);
                }
            }
        } else {
            throw new RuntimeException("No such method");
        }
        return arrayList;
    }

    @Override
    public boolean supportParam(Object[] objectArray) {
        return objectArray.length >= 1 && objectArray[0] instanceof DataSet;
    }

    public String toString() {
        return "Shrink";
    }

    private void coverArea(Matrix matrix, boolean[][] blArray, int n, int n2, int n3, int n4) {
        LinkedList<Point> linkedList = new LinkedList<Point>();
        LinkedList<Point> linkedList2 = new LinkedList<Point>();
        Point point = new Point(n, n2);
        linkedList.add(point);
        linkedList2.add(point);
        boolean bl = false;
        while (!linkedList.isEmpty()) {
            Point point2 = (Point)linkedList.remove(0);
            if (blArray[point2.x][point2.y]) continue;
            blArray[point2.x][point2.y] = true;
            for (int i = 0; i < this.cursor_maximum.length; i += 2) {
                int n5 = point2.x + this.cursor_maximum[i][0];
                int n6 = point2.y + this.cursor_maximum[i][1];
                double d = this.min(matrix, n5, n6, n3, n4);
                if (d < 0.0) {
                    bl = true;
                }
                if (d != 0.0 || blArray[n5][n6]) continue;
                Point point3 = new Point(n5, n6);
                linkedList.add(point3);
                if (bl) continue;
                linkedList2.add(point3);
            }
        }
        if (!bl) {
            for (Point point4 : linkedList2) {
                matrix.set(point4.x, point4.y, 1.0);
            }
        }
    }

    private double min(Matrix matrix, int n, int n2, int n3, int n4) {
        if (n >= 0 && n2 >= 0 && n < n3 && n2 < n4) {
            if (matrix.get(n, n2) > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        return -1.0;
    }
}

