/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.statistics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.List;
import se.prediktera.image.count.algorithm.IdentifiedObjectDataClass;
import se.prediktera.image.count.algorithm.IdentifiedObjectListWithSummary;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.type.DataSetGroup;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.FloatWindowContour2D;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;

public class CountStatisticsInfo
extends AbstractStatisticsInfo {
    private static final BasicStroke doubleStroke = new BasicStroke(3.0f, 0, 0, 10.0f);
    private static final BasicStroke borderStroke = new BasicStroke(5.0f, 0, 0, 10.0f);
    private IdentifiedObjectListWithSummary cdc = null;

    @Override
    public void adjustMinMax(AbstractAxisLayer abstractAxisLayer, int n, double[] dArray) {
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        if (this.cdc == null) {
            Case case_ = abstractDataMatrix.getCase();
            DataContainer dataContainer = case_.getDsContainer();
            for (int i = 0; i < dataContainer.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface = dataContainer.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof DataSetGroup)) continue;
                DataSetGroup dataSetGroup = (DataSetGroup)dataTreeInterface;
                for (int j = 0; j < dataSetGroup.getTreeNodeCount(); ++j) {
                    DataTreeInterface dataTreeInterface2 = dataSetGroup.getTreeNodeAt(j);
                    if (!(dataTreeInterface2 instanceof IdentifiedObjectListWithSummary)) continue;
                    this.cdc = (IdentifiedObjectListWithSummary)dataTreeInterface2;
                }
                break;
            }
        }
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return new AbstractSettingsPanel(){};
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (abstractAxisPlot instanceof FloatWindowContour2D) {
            FloatWindowContour2D floatWindowContour2D = (FloatWindowContour2D)abstractAxisPlot;
            if (this.cdc != null) {
                Cloneable cloneable;
                Color color = graphics2D.getColor();
                Stroke stroke = graphics2D.getStroke();
                double[] dArray = new double[2];
                int n2 = abstractDataMatrix.getFoldN();
                if (abstractDataMatrix instanceof FoldMatrix) {
                    cloneable = (FoldMatrix)abstractDataMatrix;
                    n2 = ((ReferenceMatrix)cloneable).getFoldN();
                }
                cloneable = floatWindowContour2D.getRange(1, 0);
                List<IdentifiedObjectDataClass> list = this.cdc.createObjectList();
                for (IdentifiedObjectDataClass identifiedObjectDataClass : list) {
                    AffineTransform affineTransform = graphics2D.getTransform();
                    int n3 = identifiedObjectDataClass.getInteractionCenterPoint();
                    int n4 = n3 / n2 + 1;
                    int n5 = n3 % n2 + 1;
                    floatWindowContour2D.translateToScreenDouble(dArray, n4, ((AxisRange)cloneable).getDataMax() - (double)n5);
                    graphics2D.translate(dArray[0], dArray[1]);
                    graphics2D.setColor(Color.white);
                    graphics2D.setStroke(borderStroke);
                    graphics2D.drawLine(-4, -4, 4, 4);
                    graphics2D.drawLine(-4, 4, 4, -4);
                    graphics2D.setColor(Color.red);
                    graphics2D.setStroke(doubleStroke);
                    graphics2D.drawLine(-3, -3, 3, 3);
                    graphics2D.drawLine(-3, 3, 3, -3);
                    graphics2D.setTransform(affineTransform);
                }
                graphics2D.setColor(color);
                graphics2D.setStroke(stroke);
            }
        }
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void setOption(Object object) {
        if (object instanceof IdentifiedObjectListWithSummary) {
            this.cdc = (IdentifiedObjectListWithSummary)object;
        }
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        DataContainer dataContainer;
        Case case_;
        AbstractDataMatrix abstractDataMatrix;
        if (dataTreeInterface instanceof FloatWindowContour2D && (abstractDataMatrix = ((FloatWindowContour2D)dataTreeInterface).getPlotInit().getMatrix(0)) != null && (case_ = abstractDataMatrix.getCase()) != null && (dataContainer = case_.getDsContainer()) != null) {
            for (int i = 0; i < dataContainer.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface2 = dataContainer.getTreeNodeAt(i);
                if (!(dataTreeInterface2 instanceof DataSetGroup)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toNiceString() {
        return "Object centrum";
    }

    public String toString() {
        return "[OBJECT CENTRUM]";
    }

    @Override
    protected int getType() {
        return 22;
    }
}

