/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import se.prediktera.image.dataimport.ImageImportPanel;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;

public class ImageImportInfo
extends AbstractImportInfo {
    @Override
    public String getDescription() {
        String[] stringArray = this.getExt();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Image files (");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("*." + stringArray[i]);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String[] getExt() {
        Iterator<ImageReaderSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String[] stringArray;
            ImageReaderSpi imageReaderSpi = iterator.next();
            for (String string : stringArray = imageReaderSpi.getFileSuffixes()) {
                if (string.trim().length() <= 0) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public byte getMultipleMergeTypes() {
        return 4;
    }

    @Override
    public boolean supportDataSource() {
        return false;
    }

    @Override
    protected AbstractImportPanel createImportPanel(ImportInterface importInterface) throws Exception {
        return new ImageImportPanel(importInterface.getFiles());
    }

    @Override
    protected boolean isImage() {
        if (this.importPanel instanceof ImageImportPanel) {
            return ((ImageImportPanel)this.importPanel).isNormalimage();
        }
        return true;
    }

    @Override
    public boolean isMultiLayer() {
        return true;
    }

    @Override
    public String getPreviewDescription(File file) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html><body><b>");
                stringBuffer.append(jopensaveDialog.getFileName(file));
                stringBuffer.append("</b><br>");
                stringBuffer.append("<table cellpadding=\"0\">");
                this.addRow(stringBuffer, "Width", bufferedImage.getWidth());
                this.addRow(stringBuffer, "Height", bufferedImage.getHeight());
                stringBuffer.append("</table>");
                return stringBuffer.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void addRow(StringBuffer stringBuffer, String string, int n) {
        stringBuffer.append("<tr><td><font size=\"3\">");
        stringBuffer.append(string);
        stringBuffer.append("</font></td><td><font size=\"3\">");
        stringBuffer.append(n);
        stringBuffer.append("</font></td></tr>");
    }

    @Override
    public File getPreviewFile(File file) {
        return file;
    }

    static {
        IIORegistry.getDefaultInstance().registerServiceProvider(new TIFFImageReaderSpi());
    }
}

