/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.FileTools;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.wizard.MergeException;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ImageImportPanel
extends AbstractImportPanel {
    private static final byte RED = 0;
    private static final byte GREEN = 1;
    private static final byte BLUE = 2;
    private static final byte ALPHA = 3;
    private final List<BufferedImage> imageList = new ArrayList<BufferedImage>();
    private final List<WritableRaster> rasterList = new ArrayList<WritableRaster>();
    private final List<LayerName> nameList = new ArrayList<LayerName>();
    private int width = -1;
    private int height = -1;
    private int arrayIndex;
    private int layerIndex;
    private int layerBands;
    private boolean normalimage = true;

    public static void main(String[] stringArray) throws Exception {
        File file = new File("C:\\test2.jpg");
        ImageImportPanel imageImportPanel = new ImageImportPanel(new File[]{file});
        CellIdentifierModel cellIdentifierModel = imageImportPanel.getTableModel(null, false);
        long l = System.currentTimeMillis();
        for (int i = 0; i < cellIdentifierModel.getColumnCount(); ++i) {
            for (int j = 0; j < cellIdentifierModel.getRowCount(); ++j) {
                cellIdentifierModel.getDoubleAt(j, i);
            }
        }
        System.out.println("Time: " + (System.currentTimeMillis() - l));
    }

    public ImageImportPanel(File[] fileArray) throws Exception {
        super(fileArray);
        for (File file : fileArray) {
            List<BufferedImage> list = this.loadImage(file);
            if (list.isEmpty()) {
                throw new Exception("Cannot load image: " + file.getAbsolutePath());
            }
            if (FileTools.hasExtension(file, "jpg", "jpeg") && list.size() == 2 && list.getLast().getType() == 10) {
                list.remove(1);
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                BufferedImage bufferedImage = list.get(i);
                int n = bufferedImage.getWidth();
                int n2 = bufferedImage.getHeight();
                if (this.width == -1 || this.height == -1) {
                    this.width = n;
                    this.height = n2;
                }
                if (this.width != n || this.height != n2) {
                    object = file.getName() + " contains multiple images which have different resolution and cannot be imported: image " + i + " (" + n + " x " + n2 + " pixels) does not match previous resolution (" + this.width + " x " + this.height + " pixels).";
                    throw new MergeException((String)object);
                }
                this.imageList.add(bufferedImage);
                object = bufferedImage.getRaster();
                this.rasterList.add((WritableRaster)object);
                if (this.normalimage) {
                    this.normalimage = this.checkNormalImage(bufferedImage, n, n2, (WritableRaster)object);
                }
                this.nameList.add(new LayerName(jopensaveDialog.getFileName(file), list.size() > 1 ? i : -1, fileArray.length > 1));
            }
        }
    }

    private boolean checkNormalImage(BufferedImage bufferedImage, int n, int n2, WritableRaster writableRaster) {
        double[] dArray = new double[writableRaster.getNumBands() + (bufferedImage.getColorModel().hasAlpha() ? 1 : 0)];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                writableRaster.getPixel(i, j, dArray);
                for (double d : dArray) {
                    if (!(d < 0.0) && !(d > 255.0)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        if (this.rasterList.isEmpty()) {
            return null;
        }
        return new CellIdentifierModel(this.height, this.width){
            private int currentLayer;

            @Override
            public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
                return fastDecimal.setValue(this.getLayerColor(n, n2));
            }

            @Override
            public int getLayerCount() {
                int n = 0;
                for (WritableRaster writableRaster : ImageImportPanel.this.rasterList) {
                    n += writableRaster.getNumBands();
                }
                return n;
            }

            @Override
            public String getLayerName(int n) {
                this.setIndexFromCurrentLayer(n);
                return ImageImportPanel.this.nameList.get(ImageImportPanel.this.arrayIndex).getName(ImageImportPanel.this.layerBands, ImageImportPanel.this.layerIndex, n);
            }

            @Override
            public int[] getMinMax() {
                if (ImageImportPanel.this.normalimage) {
                    return new int[]{0, 255};
                }
                return null;
            }

            @Override
            public Object getValueAt_Transpose(int n, int n2) {
                return String.valueOf(this.getLayerColor(n, n2));
            }

            @Override
            public boolean isMultiLayer() {
                return true;
            }

            @Override
            public void setCurrentLayer(int n) {
                this.currentLayer = n;
            }

            private int getLayerColor(int n, int n2) {
                this.setIndexFromCurrentLayer(this.currentLayer);
                ColorModel colorModel = ImageImportPanel.this.imageList.get(ImageImportPanel.this.arrayIndex).getColorModel();
                if (colorModel instanceof IndexColorModel) {
                    int n3 = ImageImportPanel.this.rasterList.get(ImageImportPanel.this.arrayIndex).getSample(n2, n, 0);
                    return switch (ImageImportPanel.this.layerIndex) {
                        case 0 -> colorModel.getRed(n3);
                        case 1 -> colorModel.getGreen(n3);
                        case 2 -> colorModel.getBlue(n3);
                        case 3 -> colorModel.getAlpha(n3);
                        default -> 0;
                    };
                }
                return ImageImportPanel.this.rasterList.get(ImageImportPanel.this.arrayIndex).getSample(n2, n, ImageImportPanel.this.layerIndex);
            }

            private void setIndexFromCurrentLayer(int n) {
                int n2 = 0;
                for (int i = 0; i < ImageImportPanel.this.rasterList.size(); ++i) {
                    WritableRaster writableRaster = ImageImportPanel.this.rasterList.get(i);
                    if (n >= (n2 += writableRaster.getNumBands())) continue;
                    ImageImportPanel.this.arrayIndex = i;
                    ImageImportPanel.this.layerBands = writableRaster.getNumBands();
                    ImageImportPanel.this.layerIndex = ImageImportPanel.this.layerBands - n2 + n;
                    break;
                }
            }
        };
    }

    @Override
    public String getType() {
        return "Image";
    }

    @Override
    public boolean hasSettings() {
        return false;
    }

    public boolean isNormalimage() {
        return this.normalimage;
    }

    public List<BufferedImage> loadImage(File file) throws Exception {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> iterator;
            if (imageInputStream == null || imageInputStream.length() == 0L) {
                // empty if block
            }
            if ((iterator = ImageIO.getImageReaders(imageInputStream)) == null || !iterator.hasNext()) {
                throw new IOException("Image file format not supported by ImageIO: " + file.getAbsolutePath());
            }
            ImageReader imageReader = iterator.next();
            iterator = null;
            imageReader.setInput(imageInputStream);
            Exception exception = null;
            int n = imageReader.getNumImages(true);
            for (int i = 0; i < n; ++i) {
                try {
                    arrayList.add(imageReader.read(i));
                    continue;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    Logg.error("Error reading page {} from file {}", i + 1, file.getName(), exception2);
                }
            }
            if (arrayList.isEmpty() && exception != null) {
                throw exception;
            }
        }
        return arrayList;
    }

    private static class LayerName {
        private final String fileName;
        private final int multiplePageIndex;
        private final boolean multipleImages;

        public LayerName(String string, int n, boolean bl) {
            this.fileName = string;
            this.multiplePageIndex = n;
            this.multipleImages = bl;
        }

        public String getName(int n, int n2, int n3) {
            Object object = "";
            if (this.multipleImages) {
                object = this.fileName + " - ";
            }
            if (this.multiplePageIndex >= 0) {
                return String.valueOf(this.multiplePageIndex + 1);
            }
            if (n == 1) {
                return (String)object + "Grayscale";
            }
            switch (n2) {
                case 0: {
                    return (String)object + "Red";
                }
                case 1: {
                    return (String)object + "Green";
                }
                case 2: {
                    return (String)object + "Blue";
                }
                case 3: {
                    return (String)object + "Alpha";
                }
            }
            return "Layer " + (n3 + 1);
        }
    }
}

