/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.calibration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import se.prediktera.image.dataimport.calibration.CubeClass;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.image.hdr.ReferenceTarget;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.simpletableeditor.CMModifierInterface;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class CalibrationAlgorithm
extends DataTreeClass
implements CellIdentifier,
DataTreeExtLibInterface,
CMModifierInterface {
    private final double toLog10 = 1.0 / Math.log(10.0);
    private int nrmissing = 0;
    private int nrexceed = 0;
    private double[] badcoords;
    private CubeClass[] cubeClasses;
    private boolean doline = true;
    private boolean doreflectance = true;
    private boolean capReflectance = false;
    private boolean adjustpixels = false;
    private boolean subtractlines = false;
    private AdjustPixelSettings adjustPixelSettings = new AdjustPixelSettings(this.adjustpixels, 0.01, 1.0E-4);

    public CalibrationAlgorithm() {
        super("Unit Conversion");
    }

    public CalibrationAlgorithm(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.nrmissing = mapProperty.getPropertyInt("nomv");
        this.nrexceed = mapProperty.getPropertyInt("nrexceed");
        this.doline = mapProperty.getPropertyBoolean("line", true);
        this.doreflectance = mapProperty.getPropertyBoolean("refl", true);
        this.capReflectance = mapProperty.getPropertyBoolean("cap", false);
        this.adjustpixels = mapProperty.getPropertyBoolean("adjpix", false);
        this.subtractlines = mapProperty.getPropertyBoolean("sublns", false);
    }

    @Override
    public void applyModifier(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel, AbstractDataMatrix abstractDataMatrix) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.getTreeNodeCount(); ++n) {
            if (!(this.getTreeNodeAt(n) instanceof CubeClass)) continue;
            ++n2;
        }
        n = 0;
        this.cubeClasses = new CubeClass[n2];
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof CubeClass)) continue;
            this.cubeClasses[n++] = (CubeClass)this.getTreeNodeAt(i);
        }
        this.performCalibration(progressManager, cellIdentifierModel, abstractDataMatrix);
    }

    public void closeConnections() {
        if (this.cubeClasses != null) {
            for (CubeClass cubeClass : this.cubeClasses) {
                cubeClass.closeConnections();
            }
        }
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Convertion unit:</TD><TD>").append(this.doreflectance ? "Reflection" : "Pseudo-Absorbance").append("</TD></TR>");
        stringBuilder.append("<TR><TD>Acquisition type:</TD><TD>").append(this.doline ? "Line" : "Layer").append("</TD></TR>");
        stringBuilder.append("<TR><TD>Cap reflectance:</TD><TD>").append(this.capReflectance ? "Yes" : "No").append("</TD></TR>");
        if (this.cubeClasses != null) {
            stringBuilder.append("<TR></TR><TR><TD colspan=\"2\"><B>Image references:</B></TD><TD>");
            for (int i = 0; i < this.cubeClasses.length; ++i) {
                stringBuilder.append("<TR><TD>Reference (" + (i + 1) + "):</TD><TD>").append(this.cubeClasses[i].getPercentage() + " % Reflectance").append("</TD></TR>");
            }
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 11;
    }

    @Override
    public boolean isVisibleInTree() {
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            return true;
        }
        return super.isVisibleInTree();
    }

    /*
     * WARNING - void declaration
     */
    public String performCalibration(final ProgressManager progressManager, CellIdentifierModel cellIdentifierModel, final AbstractDataMatrix abstractDataMatrix) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        abstractDataMatrix.resetMinMax();
        Case case_ = abstractDataMatrix.getCase();
        if (case_ != null) {
            case_.setCalibrationType(this.doreflectance ? (byte)2 : 1);
            case_.setCalibrationCap(this.capReflectance);
        }
        abstractDataMatrix.beginCalculations();
        if (this.doline) {
            int n6 = abstractDataMatrix.getMatrixSize();
            n5 = cellIdentifierModel.analyzeVar();
            n4 = cellIdentifierModel.analyzeLayer();
            for (AbstractDataMatrix abstractDataMatrix2 : this.cubeClasses) {
                n6 += n5 * n4 * ((CubeClass)abstractDataMatrix2).getRowCount();
            }
            progressManager.setMaximumAndReset(n6);
            for (AbstractDataMatrix exception : this.cubeClasses) {
                if (((CubeClass)exception).hasMeanLine()) continue;
                ((CubeClass)exception).calcMeanFrame(progressManager, cellIdentifierModel);
            }
            progressManager.setInfoText("Performing unit conversion per line");
            var8_16 = new Threader(this){
                final /* synthetic */ CalibrationAlgorithm this$0;
                {
                    this.this$0 = calibrationAlgorithm;
                }

                @Override
                protected void doOp(boolean bl, int n, int n2) {
                    for (int i = n; i < n2; ++i) {
                        AbstractDataMatrix abstractDataMatrix2 = abstractDataMatrix.getMatrixAt(i);
                        if (abstractDataMatrix2 == null) continue;
                        int n3 = abstractDataMatrix2.getN();
                        int n4 = abstractDataMatrix2.getK();
                        for (int j = 0; j < n4; ++j) {
                            for (int k = 0; k < n3; ++k) {
                                this.this$0.calibrate(this.this$0.cubeClasses, k, j, i, abstractDataMatrix2, k, j);
                            }
                            progressManager.incStep(n3);
                        }
                    }
                }
            };
            ((Threader)var8_16).execute(n4);
        } else {
            void abstractDataMatrix5;
            progressManager.setMaximumAndReset(abstractDataMatrix.getMatrixSize());
            progressManager.setInfoText("Performing spectral unit conversion per layer");
            int[] nArray = cellIdentifierModel.getDataOrder();
            int[] nArray2 = new int[3];
            int[] nArray3 = new int[3];
            var8_16 = abstractDataMatrix.getMatrixArray();
            int n7 = nArray[2];
            nArray2[n7] = 0;
            n3 = cellIdentifierModel.getCount(n7);
            boolean abstractDataMatrix4 = false;
            while (abstractDataMatrix5 < n3) {
                if (cellIdentifierModel.isTypeData(n7, (int)abstractDataMatrix5)) {
                    nArray3[n7] = abstractDataMatrix5;
                    n2 = nArray[1];
                    nArray2[n2] = 0;
                    n = cellIdentifierModel.getCount(n2);
                    for (int i = 0; i < n; ++i) {
                        if (!cellIdentifierModel.isTypeData(n2, i)) continue;
                        nArray3[n2] = i;
                        int n6 = nArray[0];
                        nArray2[n6] = 0;
                        int n8 = cellIdentifierModel.getCount(n6);
                        for (int j = 0; j < n8; ++j) {
                            if (!cellIdentifierModel.isTypeData(n6, j)) continue;
                            nArray3[n6] = j;
                            cellIdentifierModel.setCurrentLayer(nArray3[2]);
                            this.calibrate(this.cubeClasses, nArray3[0], nArray3[1], nArray3[2], (AbstractDataMatrix)var8_16[nArray2[2]], nArray2[0], nArray2[1]);
                            progressManager.incStep();
                            int n9 = n6;
                            nArray2[n9] = nArray2[n9] + 1;
                        }
                        int n10 = n2;
                        nArray2[n10] = nArray2[n10] + 1;
                    }
                    int n11 = n7;
                    nArray2[n11] = nArray2[n11] + 1;
                }
                ++abstractDataMatrix5;
            }
        }
        if (this.adjustpixels) {
            progressManager.setInfoText("Adjusting pixels");
            DataContainer dataContainer = new DataContainer("Sensor info", -1);
            FilterMask filterMask = new FilterMask();
            for (CubeClass cubeClass : this.cubeClasses) {
                if (!cubeClass.isLoaded()) {
                    try {
                        cubeClass.loadDataFromDisk(progressManager, cellIdentifierModel);
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                    }
                }
                this.getPixelMask(cellIdentifierModel, abstractDataMatrix, cubeClass, this.adjustPixelSettings.getStDevPvalue(), this.adjustPixelSettings.getWlPvalue(), filterMask);
                filterMask.addStdevMatrixToInterface(cubeClass.getPercentage(), dataContainer);
            }
            filterMask.addMaskMatrixToInterface(dataContainer);
            this.addTreeNode(dataContainer);
            this.medianAdjustPixels(cellIdentifierModel, abstractDataMatrix, filterMask);
        }
        if (this.subtractlines) {
            progressManager.setInfoText("Subtracting lines");
            AbstractDataMatrix abstractDataMatrix3 = abstractDataMatrix.getMatrixAt(0);
            n5 = abstractDataMatrix3.getN();
            n4 = abstractDataMatrix.getMatrixCount() - cellIdentifierModel.getReferenceValues();
            int n13 = abstractDataMatrix3.getK();
            double[][] dArray = new double[n13][n4];
            for (n3 = 0; n3 < n4; ++n3) {
                AbstractDataMatrix abstractDataMatrix2 = abstractDataMatrix.getMatrixAt(n3);
                for (n2 = 0; n2 < n13; ++n2) {
                    for (n = 0; n < 5; ++n) {
                        double[] dArray2 = dArray[n2];
                        int n12 = n3;
                        dArray2[n12] = dArray2[n12] + abstractDataMatrix2.getValue(n, n2);
                    }
                    double[] dArray3 = dArray[n2];
                    int n14 = n3;
                    dArray3[n14] = dArray3[n14] / 5.0;
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                AbstractDataMatrix abstractDataMatrix4 = abstractDataMatrix.getMatrixAt(n3);
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n13; ++n) {
                        double d = abstractDataMatrix4.getValue(n2, n);
                        abstractDataMatrix4.setValue(n2, n, d - dArray[n][n3]);
                    }
                }
            }
        }
        abstractDataMatrix.endCalculations();
        abstractDataMatrix.setLayerMinMax();
        cellIdentifierModel.addPostModifier(this);
        this.closeConnections();
        if (this.nrmissing > 0 || this.nrexceed > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.nrmissing > 0) {
                stringBuilder.append(this.nrmissing).append(" non-valid values set to missing. ");
            }
            if (this.nrexceed > 0) {
                stringBuilder.append(this.nrexceed).append(" values exceeded and has been set to 100% reflectance. ");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public void setAbsorbance() {
        this.doreflectance = false;
    }

    public void setAdjustPixels(boolean bl) {
        this.adjustpixels = bl;
        this.adjustPixelSettings = new AdjustPixelSettings(bl, 0.01, 1.0E-4);
    }

    public void setAdjustPixels(Properties properties) {
        try {
            boolean bl = ScriptHelper.getPropertyBool(properties, "spikeremoval");
            double d = ScriptHelper.getPropertyDouble(properties, "stdev_pvalue");
            double d2 = ScriptHelper.getPropertyDouble(properties, "wl_pvalue");
            this.adjustPixelSettings = new AdjustPixelSettings(bl, d, d2);
            this.adjustpixels = bl;
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void setCapReflectance(boolean bl) {
        this.capReflectance = bl;
    }

    public void setCubeClasses(CubeClass[] cubeClassArray) {
        this.cubeClasses = cubeClassArray;
        if (cubeClassArray != null) {
            for (CubeClass cubeClass : cubeClassArray) {
                this.addTreeNode(cubeClass);
            }
        }
    }

    public void setLine() {
        this.doline = true;
    }

    public void setPixel() {
        this.doline = false;
    }

    public void setReflectance() {
        this.doreflectance = true;
    }

    public void setSubtractLines(boolean bl) {
        this.subtractlines = bl;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.badcoords = null;
        this.closeConnections();
        this.cubeClasses = null;
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("nomv", this.nrmissing);
        randomOutputStream.writePropertyInt("nrexceed", this.nrexceed);
        randomOutputStream.writePropertyBoolean("line", this.doline);
        randomOutputStream.writePropertyBoolean("refl", this.doreflectance);
        randomOutputStream.writePropertyBoolean("cap", this.capReflectance);
        randomOutputStream.writePropertyBoolean("adjpix", this.adjustpixels);
        randomOutputStream.writePropertyBoolean("sublns", this.subtractlines);
    }

    private MVmatrix addMaskMatrixes(FilterMask filterMask) {
        int n;
        MVmatrix mVmatrix = new MVmatrix(filterMask.getMask().length, filterMask.getMask()[0].length, "binary mask");
        for (int i = 0; i < filterMask.getMask().length; ++i) {
            for (n = 0; n < filterMask.getMask()[0].length; ++n) {
                if (!filterMask.getMask()[i][n]) continue;
                mVmatrix.setValue(i, n, 1.0);
            }
        }
        this.addTreeNode(mVmatrix);
        MVmatrix mVmatrix2 = new MVmatrix(filterMask.getMask().length, filterMask.getMask()[0].length, "stdev mask");
        for (n = 0; n < filterMask.getMask().length; ++n) {
            for (int i = 0; i < filterMask.getMask()[0].length; ++i) {
                if (!filterMask.getMask()[n][i]) continue;
                mVmatrix2.setValue(n, i, filterMask.getStdevMatrix()[n][i]);
            }
        }
        this.addTreeNode(mVmatrix2);
        return mVmatrix;
    }

    private void calibrate(CubeClass[] cubeClassArray, int n, int n2, int n3, AbstractDataMatrix abstractDataMatrix, int n4, int n5) {
        double d;
        double d2 = abstractDataMatrix.getValue(n4, n5);
        double d3 = cubeClassArray[0].getDoubleAt(n, n2, n3);
        double d4 = (double)cubeClassArray[0].getPercentage() / 100.0;
        double d5 = cubeClassArray[1].getDoubleAt(n, n2, n3);
        double d6 = (double)cubeClassArray[1].getPercentage() / 100.0;
        ReferenceTarget referenceTarget = cubeClassArray[1].getReferenceTarget();
        if (d3 > d5) {
            d = d3;
            d3 = d5;
            d5 = d;
            d = d4;
            d4 = d6;
            d6 = d;
        }
        if ((d = (d5 - d3) / (d6 - d4)) == 0.0) {
            abstractDataMatrix.setValueMinMax(n4, n5, 0.0, true);
            ++this.nrmissing;
            return;
        }
        double d7 = (d2 - (d3 -= d * d4)) / d;
        if (d7 < 0.0) {
            abstractDataMatrix.setValueMinMax(n4, n5, 0.0, true);
            ++this.nrmissing;
            return;
        }
        if (d7 > 1.0 && this.capReflectance) {
            ++this.nrexceed;
            d7 = 1.0;
        }
        if (referenceTarget != null) {
            d7 *= (double)referenceTarget.getValue(n);
        }
        if (this.doreflectance) {
            abstractDataMatrix.setValueMinMax(n4, n5, d7);
        } else if (d7 == 0.0) {
            abstractDataMatrix.setValueMinMax(n4, n5, 0.0, true);
        } else {
            abstractDataMatrix.setValueMinMax(n4, n5, -Math.log(d7) * this.toLog10);
        }
    }

    private double getMedian(ArrayList<Double> arrayList) {
        Collections.sort(arrayList);
        return arrayList.get(arrayList.size() / 2);
    }

    private ArrayList<int[]> getPixelMask(CellIdentifierModel cellIdentifierModel, AbstractDataMatrix abstractDataMatrix, CubeClass cubeClass, double d, double d2, FilterMask filterMask) {
        double[][] dArray = cubeClass.getMeanFrame();
        int n = cubeClass.getFrameCube()[0][0].length;
        int n2 = cellIdentifierModel.analyzeLayer();
        int n3 = cellIdentifierModel.analyzeVar();
        filterMask.init(n3, n2);
        double[][] dArray2 = new double[n3][n2];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray2[i][j] = 0.0;
                for (int k = 0; k < n; ++k) {
                    double[] dArray3 = dArray2[i];
                    int n4 = j;
                    dArray3[n4] = dArray3[n4] + Math.pow(cubeClass.getFrameCube()[i][j][k] - dArray[i][j], 2.0);
                }
                double[] dArray4 = dArray2[i];
                int n5 = j;
                dArray4[n5] = dArray4[n5] / (double)(n - 1);
                dArray2[i][j] = Math.sqrt(dArray2[i][j]);
            }
        }
        filterMask.addStdevMatrix(dArray2);
        boolean[][] blArray = new boolean[n3][n2];
        double d3 = AbstractModel.calculateTvalue(d);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d4 = dArray2[i][j] / dArray[i][j];
                if (!(d4 > d3) && dArray2[i][j] != 0.0) continue;
                filterMask.addPosition(i, j);
                arrayList.add(new int[]{i, j});
                blArray[i][j] = true;
            }
        }
        if (cubeClass.getPercentage() > 50 && d2 < 1.0) {
            double d5 = AbstractModel.calculateTvalue(d2);
            for (int i = 0; i < n3; ++i) {
                int n6;
                double d6 = 0.0;
                double d7 = 0.0;
                for (n6 = 1; n6 < n2; ++n6) {
                    d6 += Math.abs(dArray[i][n6] - dArray[i][n6 - 1]);
                }
                d6 /= (double)(n2 - 1);
                for (n6 = 1; n6 < n2; ++n6) {
                    d7 += Math.pow(Math.abs(dArray[i][n6] - dArray[i][n6 - 1]) - d6, 2.0);
                }
                d7 = Math.sqrt(d7 / (double)(n2 - 1) - 1.0);
                double d8 = d6 + d5 * d7;
                for (int j = 1; j < n2; ++j) {
                    double d9 = Math.abs(dArray[i][j] - dArray[i][j - 1]);
                    if (!(d9 > d8) || filterMask.mask[i][j - 1]) continue;
                    if (dArray[i][j - 1] > dArray[i][j]) {
                        arrayList.add(new int[]{i, j - 1});
                        filterMask.addPosition(i, j - 1);
                        continue;
                    }
                    arrayList.add(new int[]{i, j});
                    filterMask.addPosition(i, j);
                }
            }
        }
        return arrayList;
    }

    private void medianAdjustPixels(CellIdentifierModel cellIdentifierModel, AbstractDataMatrix abstractDataMatrix, FilterMask filterMask) {
        int n = cellIdentifierModel.analyzeLayer();
        int n2 = abstractDataMatrix.getMatrixAt(0).getN();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n2; ++i) {
            for (int[] nArray : filterMask.getIdxs()) {
                arrayList.clear();
                int n3 = nArray[0];
                int n4 = Math.max(0, nArray[1] - 2);
                int n5 = Math.min(nArray[1] + 2, n - 1);
                for (int j = n4; j <= n5; ++j) {
                    if (filterMask.getMask()[n3][j] || j == nArray[1]) continue;
                    arrayList.add(abstractDataMatrix.getMatrixAt(j).getValue(i, n3));
                }
                if (arrayList.size() <= 0) continue;
                double d = this.getMedian(arrayList);
                abstractDataMatrix.getMatrixAt(nArray[1]).setValue(i, nArray[0], d);
            }
        }
    }

    private void slidingWindowFiltering(FilterMask filterMask, CubeClass cubeClass) {
        double d = 0.0;
        double d2 = 0.0;
        double[][] dArray = cubeClass.getMeanFrame();
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 1; j < n2 - 5; ++j) {
                int n3;
                d = 0.0;
                d2 = 0.0;
                for (n3 = 0; n3 < 5; ++n3) {
                    d += dArray[i][j + n3];
                }
                d /= 5.0;
                for (n3 = 0; n3 < 5; ++n3) {
                    d2 += Math.pow(dArray[i][j + n3] - d, 2.0);
                }
                d2 /= 4.0;
                for (n3 = 0; n3 < 5; ++n3) {
                    if (!(dArray[i][j + n3] / d2 > 100.0)) continue;
                    filterMask.addPosition(i, j + n3);
                }
            }
        }
    }

    public static final class AdjustPixelSettings {
        private final boolean enabled;
        private final double stDevPvalue;
        private final double wlPvalue;

        public AdjustPixelSettings(boolean bl, double d, double d2) {
            this.enabled = bl;
            this.stDevPvalue = d;
            this.wlPvalue = d2;
        }

        public double getStDevPvalue() {
            return this.stDevPvalue;
        }

        public double getWlPvalue() {
            return this.wlPvalue;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private static class FilterMask {
        private boolean[][] mask;
        private double[][] stdevMatrix;
        private ArrayList<int[]> idxs;

        public FilterMask() {
        }

        public FilterMask(int n, int n2) {
            this.init(n, n2);
        }

        public void addStdevMatrix(double[][] dArray) {
            this.stdevMatrix = dArray;
        }

        public boolean init(int n, int n2) {
            if (this.mask != null) {
                return false;
            }
            this.mask = new boolean[n][n2];
            this.idxs = new ArrayList();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.mask[i][j] = false;
                }
            }
            return true;
        }

        private void addMaskMatrixToInterface(DataContainer dataContainer) {
            MVmatrix mVmatrix = new MVmatrix(this.mask.length, this.mask[0].length, "Binary mask");
            for (int i = 0; i < this.mask.length; ++i) {
                for (int j = 0; j < this.mask[0].length; ++j) {
                    if (!this.mask[i][j]) continue;
                    mVmatrix.setValue(i, j, 1.0);
                }
            }
            dataContainer.addTreeNode(mVmatrix);
        }

        private void addPosition(int n, int n2) {
            if (!this.mask[n][n2]) {
                this.mask[n][n2] = true;
                this.idxs.add(new int[]{n, n2});
            }
        }

        private void addStdevMatrixToInterface(Object object, DataContainer dataContainer) {
            MVmatrix mVmatrix = new MVmatrix(this.stdevMatrix.length, this.stdevMatrix[0].length, "Stdev mask (" + String.valueOf(object) + "%)");
            for (int i = 0; i < this.stdevMatrix.length; ++i) {
                for (int j = 0; j < this.stdevMatrix[0].length; ++j) {
                    mVmatrix.setValue(i, j, this.stdevMatrix[i][j]);
                }
            }
            dataContainer.addTreeNode(mVmatrix);
        }

        private ArrayList<int[]> getIdxs() {
            return this.idxs;
        }

        private boolean[][] getMask() {
            return this.mask;
        }

        private double[][] getStdevMatrix() {
            return this.stdevMatrix;
        }

        private void setIdxs(ArrayList<int[]> arrayList) {
            this.idxs = arrayList;
        }

        private void setMask(boolean[][] blArray) {
            this.mask = blArray;
        }
    }
}

