/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.calibration;

import java.io.File;
import java.util.Properties;
import se.prediktera.image.dataimport.calibration.CalibrationAlgorithm;
import se.prediktera.image.dataimport.calibration.CubeClass;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.image.sac.SacImageImportInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class CalibrationAnalysisInfo
extends AbstractAnalysisInfo
implements CellIdentifier {
    @Override
    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        int n;
        String string;
        CalibrationAlgorithm calibrationAlgorithm = new CalibrationAlgorithm();
        CellIdentifierModel cellIdentifierModel = (CellIdentifierModel)objectArray[0];
        AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)objectArray[1];
        String string2 = ScriptHelper.getProperty(properties, "convertto");
        if (string2.equalsIgnoreCase("reflectance")) {
            calibrationAlgorithm.setReflectance();
        } else if (string2.equalsIgnoreCase("absorbance")) {
            calibrationAlgorithm.setAbsorbance();
        } else {
            throw new RuntimeException("No such unit conversion: " + string2);
        }
        if (ScriptHelper.hasKey(properties, "spikeremoval")) {
            calibrationAlgorithm.setAdjustPixels(properties);
        }
        if (ScriptHelper.hasKey(properties, "subtractlines")) {
            calibrationAlgorithm.setSubtractLines(ScriptHelper.getPropertyBool(properties, "subtractlines"));
        }
        if ((string = ScriptHelper.getProperty(properties, "type")).equalsIgnoreCase("line")) {
            calibrationAlgorithm.setLine();
        } else if (string.equalsIgnoreCase("pixel")) {
            calibrationAlgorithm.setPixel();
        } else {
            throw new RuntimeException("No such type: " + string);
        }
        if (ScriptHelper.hasKey(properties, "capreflectance")) {
            calibrationAlgorithm.setCapReflectance(ScriptHelper.getPropertyBool(properties, "capreflectance"));
        }
        if ((n = ScriptHelper.getPropertyInt(properties, "nrimages")) != 2) {
            throw new RuntimeException("Unit conversion only support two images");
        }
        CubeClass[] cubeClassArray = new CubeClass[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            String string3 = ScriptHelper.getProperty(properties, "file" + n2);
            File file = new File(string3);
            if (!file.exists()) {
                throw new RuntimeException("File not found: " + file.getAbsolutePath());
            }
            int n3 = ScriptHelper.getPropertyInt(properties, "percentage" + n2);
            cubeClassArray[i] = new CubeClass(n3);
            AbstractImportInfo abstractImportInfo = LoadHelper.getImportInfo(null, file);
            if (abstractImportInfo instanceof SacImageImportInfo) {
                ((SacImageImportInfo)abstractImportInfo).setSacType(n3 < 50 ? (byte)2 : 1);
            }
            cubeClassArray[i].setFile(progressManager, file, abstractImportInfo);
            cubeClassArray[i].setProperties(properties);
        }
        calibrationAlgorithm.setCubeClasses(cubeClassArray);
        calibrationAlgorithm.performCalibration(progressManager, cellIdentifierModel, abstractDataMatrix);
        return calibrationAlgorithm;
    }

    @Override
    public boolean supportParam(Object[] objectArray) {
        return objectArray.length == 2 && objectArray[0] instanceof CellIdentifierModel && objectArray[1] instanceof AbstractDataMatrix;
    }

    public String toString() {
        return "Unit Conversion";
    }
}

