/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.calibration;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.image.dataimport.calibration.CalibrationAlgorithm;
import se.prediktera.image.dataimport.calibration.CubeClass;
import se.prediktera.image.dataimport.calibration.CubePanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.FileChooserPage;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.image.hdr.HdrDataSource;
import se.prediktera.map.dataimport.image.hdr.HdrImageImportInfo;
import se.prediktera.map.dataimport.image.sac.SacImageImportInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class CalibrationPanel
extends WizardPageClass {
    private JRadioButton absorbanceRadioButton;
    private JLabel acquisitionTypeLabel;
    private JCheckBox adjustPixelsCheckBox;
    private ButtonGroup buttonGroup;
    private ButtonGroup buttonGroup2;
    private JCheckBox calibrationCheckBox;
    private JCheckBox capReflectanceCheckBox;
    private JLabel convertToLabel;
    private JPanel cubePanel;
    private JComboBox cubesComboBox;
    private JLabel cubesLabel;
    private JPanel dynamicCubePanel;
    private JRadioButton lineRadioButton;
    private JLabel otherSettingsLabel;
    private JRadioButton pixelRadioButton;
    private JRadioButton reflectanceRadioButton;
    private JPanel settingsPanel;

    public static void main(String[] stringArray) {
        final CalibrationPanel calibrationPanel = new CalibrationPanel(null);
        File[] fileArray = new File[1];
        try {
            int n;
            fileArray[0] = new File("C:\\data\\Arla\\yogurt_normalised_-1.raw");
            final LayerMatrix layerMatrix = new LayerMatrix(null);
            final HdrDataSource hdrDataSource = new HdrDataSource(fileArray, 0);
            int n2 = hdrDataSource.getRowCount();
            int n3 = hdrDataSource.getColumnCount();
            for (n = 0; n < hdrDataSource.getLayerCount(); ++n) {
                MVmatrix mVmatrix = new MVmatrix(n2, n3);
                layerMatrix.addMatrix(mVmatrix);
            }
            for (n = 0; n < hdrDataSource.getRowCount(); ++n) {
                for (int i = 0; i < hdrDataSource.getLayerCount(); ++i) {
                    hdrDataSource.setCurrentLayer(i);
                    AbstractDataMatrix abstractDataMatrix = layerMatrix.getMatrixAt(i);
                    for (int j = 0; j < hdrDataSource.getColumnCount(); ++j) {
                        abstractDataMatrix.setValue(n, j, hdrDataSource.getDoubleAt(n, j).getValue());
                    }
                }
            }
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                @Override
                public Object doWork() {
                    JPanel jPanel = calibrationPanel.getDynamicCubePanel();
                    ((CubePanel)jPanel.getComponent(0)).setFile(this, new File("C:\\data\\Arla\\dark_ref_yogurt-1.raw"), new HdrImageImportInfo());
                    ((CubePanel)jPanel.getComponent(1)).setFile(this, new File("C:\\data\\Arla\\white_ref_yogurt-1.raw"), new HdrImageImportInfo());
                    calibrationPanel.calibrationCheckBox.setSelected(true);
                    calibrationPanel.finishImport(this, hdrDataSource, layerMatrix);
                    return null;
                }
            };
            progressManagerImpl.invokeNow();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    public CalibrationPanel(AbstractWizard abstractWizard) {
        super(abstractWizard);
        this.initComponents();
        for (int i = 1; i < 10; ++i) {
            this.cubesComboBox.addItem("" + (i + 1));
        }
        this.cubesComboBox.setSelectedIndex(0);
        this.cubesComboBox.setEnabled(false);
        this.pixelRadioButton.setEnabled(false);
        this.updateCubes();
        this.capReflectanceCheckBox.setSelected(false);
        this.absorbanceRadioButton.setSelected(true);
        this.calibrationCheckBoxItemStateChanged(null);
        this.adjustPixelsCheckBox.setSelected(false);
        AbstractImportInfo abstractImportInfo = this.getImportInfo();
        if (abstractImportInfo != null && abstractImportInfo.isBreezeImport()) {
            Properties properties = new Properties();
            abstractImportInfo.setCalibrationProperties(properties, true);
            try {
                int n;
                String string;
                AbstractImportInfo abstractImportInfo2 = null;
                boolean bl = this.isSac(abstractImportInfo);
                abstractImportInfo2 = bl ? new SacImageImportInfo() : new HdrImageImportInfo();
                if (ScriptHelper.hasKey(properties, "file1")) {
                    string = ScriptHelper.getProperty(properties, "file1");
                    n = ScriptHelper.getPropertyInt(properties, "percentage1");
                    if (bl) {
                        ((SacImageImportInfo)abstractImportInfo2).setSacType((byte)1);
                    }
                    this.setBalanceFile(new File(string), abstractImportInfo2, n > 50);
                    this.calibrationCheckBox.setSelected(true);
                }
                if (ScriptHelper.hasKey(properties, "file2")) {
                    string = ScriptHelper.getProperty(properties, "file2");
                    n = ScriptHelper.getPropertyInt(properties, "percentage2");
                    if (bl) {
                        ((SacImageImportInfo)abstractImportInfo2).setSacType((byte)2);
                    }
                    this.setBalanceFile(new File(string), abstractImportInfo2, n > 50);
                }
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        } else if (this.isSac(abstractImportInfo) && abstractWizard instanceof ImportWizard) {
            this.handleSac((ImportWizard)abstractWizard);
        } else if (this.isUncompressedSac() && abstractWizard instanceof ImportWizard) {
            this.handleUncompressedSac((ImportWizard)abstractWizard);
        }
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    @Override
    public String finishImport(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel, AbstractDataMatrix abstractDataMatrix) {
        if (!this.calibrationCheckBox.isSelected()) {
            return null;
        }
        int n = this.dynamicCubePanel.getComponentCount() - 1;
        CubeClass[] cubeClassArray = new CubeClass[n];
        for (int i = 0; i < n; ++i) {
            JComponent jComponent = (JComponent)this.dynamicCubePanel.getComponent(i);
            if (!(jComponent instanceof CubePanel)) continue;
            cubeClassArray[i] = ((CubePanel)jComponent).getCubeClass();
        }
        CalibrationAlgorithm calibrationAlgorithm = new CalibrationAlgorithm();
        calibrationAlgorithm.setCubeClasses(cubeClassArray);
        if (this.lineRadioButton.isSelected()) {
            calibrationAlgorithm.setLine();
        } else {
            calibrationAlgorithm.setPixel();
        }
        if (this.reflectanceRadioButton.isSelected()) {
            calibrationAlgorithm.setReflectance();
        } else {
            calibrationAlgorithm.setAbsorbance();
        }
        calibrationAlgorithm.setCapReflectance(this.capReflectanceCheckBox.isSelected());
        calibrationAlgorithm.setAdjustPixels(this.adjustPixelsCheckBox.isSelected());
        return calibrationAlgorithm.performCalibration(progressManager, cellIdentifierModel, abstractDataMatrix);
    }

    public JPanel getDynamicCubePanel() {
        return this.dynamicCubePanel;
    }

    @Override
    public boolean nextPressed() {
        if (this.calibrationCheckBox.isSelected()) {
            int n = this.dynamicCubePanel.getComponentCount() - 1;
            CubePanel[] cubePanelArray = new CubePanel[n];
            for (int i = 0; i < n; ++i) {
                JComponent jComponent = (JComponent)this.dynamicCubePanel.getComponent(i);
                if (!(jComponent instanceof CubePanel)) continue;
                cubePanelArray[i] = (CubePanel)jComponent;
                if (cubePanelArray[i].isReady(((ImportWizard)this.wizard).getCellIdentifierModel(), this.pixelRadioButton.isSelected())) continue;
                return false;
            }
        }
        return super.nextPressed();
    }

    @Override
    public void pageShown() {
        CellIdentifierModel cellIdentifierModel = ((ImportWizard)this.wizard).getCellIdentifierModel();
        this.calibrationCheckBox.setEnabled(cellIdentifierModel.isMultiLayer());
    }

    private void calibrationCheckBoxItemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.calibrationCheckBox.isSelected();
        int n = this.dynamicCubePanel.getComponentCount() - 1;
        CubePanel[] cubePanelArray = new CubePanel[n];
        for (int i = 0; i < n; ++i) {
            JComponent jComponent = (JComponent)this.dynamicCubePanel.getComponent(i);
            if (!(jComponent instanceof CubePanel)) continue;
            cubePanelArray[i] = (CubePanel)jComponent;
            cubePanelArray[i].setEnabled(bl);
        }
        this.reflectanceRadioButton.setEnabled(bl);
        this.absorbanceRadioButton.setEnabled(bl);
        this.lineRadioButton.setEnabled(bl);
        this.capReflectanceCheckBox.setEnabled(bl);
        if (this.wizard != null && ((ImportWizard)this.wizard).getCellIdentifierModel() != null) {
            ((ImportWizard)this.wizard).getCellIdentifierModel().setCalibrated(bl);
        }
    }

    private void cubesComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.updateCubes();
    }

    private AbstractImportInfo getImportInfo() {
        for (int i = 0; i < this.wizard.getPageCount(); ++i) {
            Component component = this.wizard.getPageAt(i);
            if (!(component instanceof FileChooserPage)) continue;
            return ((FileChooserPage)component).getImportInfo();
        }
        return null;
    }

    private void handleSac(ImportWizard importWizard) {
        File file = null;
        if (importWizard.getFiles() != null && importWizard.getFiles().length > 0) {
            file = importWizard.getFiles()[0];
        }
        if (file != null) {
            this.calibrationCheckBox.setSelected(true);
            SacImageImportInfo sacImageImportInfo = new SacImageImportInfo();
            sacImageImportInfo.setSacType((byte)2);
            this.setBalanceFile(file, sacImageImportInfo, false);
            sacImageImportInfo.setSacType((byte)1);
            this.setBalanceFile(file, sacImageImportInfo, true);
        }
    }

    private boolean handleUncompressedSac(ImportWizard importWizard) {
        File file = null;
        if (importWizard.getFiles() != null && importWizard.getFiles().length > 0) {
            file = importWizard.getFiles()[0];
        }
        if (file == null) {
            return false;
        }
        File[] fileArray = HdrImageImportInfo.getReferenceFiles(file);
        if (fileArray != null) {
            try {
                HdrImageImportInfo hdrImageImportInfo = new HdrImageImportInfo();
                this.setBalanceFile(fileArray[0], hdrImageImportInfo, false);
                this.setBalanceFile(fileArray[1], hdrImageImportInfo, true);
                this.calibrationCheckBox.setSelected(true);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
                return false;
            }
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.cubePanel = new JPanel();
        this.dynamicCubePanel = new JPanel();
        this.cubesComboBox = new JComboBox();
        this.cubesLabel = new JLabel();
        this.settingsPanel = new JPanel();
        this.reflectanceRadioButton = new JRadioButton();
        this.absorbanceRadioButton = new JRadioButton();
        this.lineRadioButton = new JRadioButton();
        this.pixelRadioButton = new JRadioButton();
        this.convertToLabel = new JLabel();
        this.otherSettingsLabel = new JLabel();
        this.calibrationCheckBox = new JCheckBox();
        this.acquisitionTypeLabel = new JLabel();
        this.capReflectanceCheckBox = new JCheckBox();
        this.adjustPixelsCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.cubePanel.setBorder(BorderFactory.createTitledBorder("Reference images"));
        this.cubePanel.setLayout(new GridBagLayout());
        this.dynamicCubePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.cubePanel.add((Component)this.dynamicCubePanel, gridBagConstraints);
        this.cubesComboBox.setPreferredSize(new Dimension(80, 20));
        this.cubesComboBox.addItemListener(itemEvent -> this.cubesComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.cubePanel.add((Component)this.cubesComboBox, gridBagConstraints);
        this.cubesLabel.setText("Number of images");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.cubePanel.add((Component)this.cubesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.cubePanel, gridBagConstraints);
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Unit conversion settings"));
        this.settingsPanel.setLayout(new GridBagLayout());
        this.buttonGroup.add(this.reflectanceRadioButton);
        this.reflectanceRadioButton.setSelected(true);
        this.reflectanceRadioButton.setText("Reflectance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 36);
        this.settingsPanel.add((Component)this.reflectanceRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.absorbanceRadioButton);
        this.absorbanceRadioButton.setText("Pseudo-Absorbance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 36);
        this.settingsPanel.add((Component)this.absorbanceRadioButton, gridBagConstraints);
        this.buttonGroup2.add(this.lineRadioButton);
        this.lineRadioButton.setSelected(true);
        this.lineRadioButton.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 36);
        this.settingsPanel.add((Component)this.lineRadioButton, gridBagConstraints);
        this.buttonGroup2.add(this.pixelRadioButton);
        this.pixelRadioButton.setText("Layer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 36);
        this.settingsPanel.add((Component)this.pixelRadioButton, gridBagConstraints);
        this.convertToLabel.setFont(new Font("Tahoma", 1, 11));
        this.convertToLabel.setText("Convert unit to:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 36);
        this.settingsPanel.add((Component)this.convertToLabel, gridBagConstraints);
        this.otherSettingsLabel.setFont(new Font("Tahoma", 1, 11));
        this.otherSettingsLabel.setText("Other settings");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.settingsPanel.add((Component)this.otherSettingsLabel, gridBagConstraints);
        this.calibrationCheckBox.setText("Enable spectral unit conversion");
        this.calibrationCheckBox.addItemListener(itemEvent -> this.calibrationCheckBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.settingsPanel.add((Component)this.calibrationCheckBox, gridBagConstraints);
        this.acquisitionTypeLabel.setFont(new Font("Tahoma", 1, 11));
        this.acquisitionTypeLabel.setText("Acquisition type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 36);
        this.settingsPanel.add((Component)this.acquisitionTypeLabel, gridBagConstraints);
        this.capReflectanceCheckBox.setText("Cap reflectance values higher than one unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.settingsPanel.add((Component)this.capReflectanceCheckBox, gridBagConstraints);
        this.adjustPixelsCheckBox.setText("Replace spikes with median");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.settingsPanel.add((Component)this.adjustPixelsCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.settingsPanel, gridBagConstraints);
    }

    private boolean isSac(AbstractImportInfo abstractImportInfo) {
        if (abstractImportInfo instanceof SacImageImportInfo || abstractImportInfo.isBreezeImport()) {
            if (abstractImportInfo.isBreezeImport()) {
                AbstractImportPanel abstractImportPanel = abstractImportInfo.getCurrentPanel();
                return abstractImportPanel.isSac();
            }
            return true;
        }
        return false;
    }

    private boolean isUncompressedSac() {
        if (!(this.wizard instanceof ImportWizard)) {
            return false;
        }
        return HdrImageImportInfo.isHdrFile(((ImportWizard)this.wizard).getFiles()[0]);
    }

    private boolean setBalanceFile(File file, AbstractImportInfo abstractImportInfo, boolean bl) {
        boolean bl2 = false;
        for (Component component : this.dynamicCubePanel.getComponents()) {
            if (!(component instanceof CubePanel)) continue;
            if (bl && !bl2) {
                bl2 = true;
                continue;
            }
            ((CubePanel)component).setFile(null, file, abstractImportInfo);
            return true;
        }
        return false;
    }

    private void updateCubes() {
        String string = (String)this.cubesComboBox.getSelectedItem();
        int n = Integer.parseInt(string);
        this.dynamicCubePanel.removeAll();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)((double)i / (double)(n - 1) * 100.0);
            CubePanel cubePanel = new CubePanel(n2);
            this.dynamicCubePanel.add((Component)cubePanel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 6, 6, 6), 0, 0));
        }
        this.dynamicCubePanel.add((Component)new JLabel(""), new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dynamicCubePanel.revalidate();
        this.dynamicCubePanel.repaint();
    }
}

