/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.calibration;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.image.AbstractHeaderDataSource;
import se.prediktera.map.dataimport.image.hdr.HdrParser;
import se.prediktera.map.dataimport.image.hdr.ReferenceTarget;
import se.prediktera.map.dataimport.image.sac.SacImageImportInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class CubeClass
extends LayerMatrix
implements ImportInterface,
CellIdentifier,
DataTreeExtLibInterface {
    private int percentage;
    private CellIdentifierModel cubeModel;
    private File file;
    private double[][] meanFrame = null;
    private double[][][] frameCube = null;
    private ReferenceTarget referenceTarget;

    public CubeClass(int n) {
        super((int[])null);
        this.percentage = n;
    }

    public CubeClass(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.percentage = mapProperty.getPropertyInt("percentage");
        String string = mapProperty.getPropertyStringUTF("fname");
        if (string != null) {
            this.file = new File(string);
        }
        this.meanFrame = mapProperty.getPropertyDoubleArray2d("meanLine");
        float[] fArray = mapProperty.getPropertyFloatArray("referenceTarget", null);
        if (fArray != null) {
            this.referenceTarget = new ReferenceTarget(fArray);
        }
    }

    public double[][] calcMeanFrame(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel) {
        int n;
        int n2;
        int n3 = this.cubeModel.getRowCount();
        this.meanFrame = new double[cellIdentifierModel.analyzeVar()][cellIdentifierModel.analyzeLayer()];
        int n4 = this.cubeModel.getRowCount() / 1;
        this.frameCube = new double[this.meanFrame.length][this.meanFrame[0].length][n4];
        progressManager.setInfoText("Calculating mean line for " + this.percentage + "% white data cube");
        int[] nArray = this.cubeModel.getDataOrder();
        int[] nArray2 = new int[]{1, 1, 1};
        int[] nArray3 = new int[3];
        int[] nArray4 = new int[3];
        int n5 = nArray[2];
        nArray3[n5] = 0;
        int n6 = this.count(cellIdentifierModel, n5);
        for (int i = 0; i < n6; i += nArray2[n5]) {
            if (n5 != 0 && !cellIdentifierModel.isTypeData(n5, i)) continue;
            nArray4[n5] = i;
            int n7 = nArray[1];
            nArray3[n7] = 0;
            n2 = this.count(cellIdentifierModel, n7);
            for (n = 0; n < n2; n += nArray2[n7]) {
                if (n7 != 0 && !cellIdentifierModel.isTypeData(n7, n)) continue;
                nArray4[n7] = n;
                int n8 = nArray[0];
                nArray3[n8] = 0;
                int n9 = this.count(cellIdentifierModel, n8);
                for (int j = 0; j < n9; j += nArray2[n8]) {
                    if (n8 != 0 && !cellIdentifierModel.isTypeData(n8, j)) continue;
                    nArray4[n8] = j;
                    this.cubeModel.setCurrentLayer(nArray4[2]);
                    double d = this.cubeModel.getDirectDoubleAtNoMissing(nArray4[0], nArray4[1]);
                    double[] dArray = this.meanFrame[nArray3[1]];
                    int n10 = nArray3[2];
                    dArray[n10] = dArray[n10] + d;
                    if (nArray3[0] < this.frameCube[nArray3[1]][nArray3[2]].length) {
                        this.frameCube[nArray3[1]][nArray3[2]][nArray3[0]] = d;
                    }
                    progressManager.incStep(1);
                    int n11 = n8;
                    nArray3[n11] = nArray3[n11] + 1;
                }
                int n12 = n7;
                nArray3[n12] = nArray3[n12] + 1;
            }
            int n13 = n5;
            nArray3[n13] = nArray3[n13] + 1;
        }
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d += 1.0;
        }
        for (n2 = 0; n2 < this.meanFrame.length; ++n2) {
            n = 0;
            while (n < this.meanFrame[n2].length) {
                double[] dArray = this.meanFrame[n2];
                int n14 = n++;
                dArray[n14] = dArray[n14] / d;
            }
        }
        this.setDefaultBand(cellIdentifierModel.getDefaultBand());
        this.setRowType(64);
        this.setName(this.getName());
        for (n2 = 0; n2 < this.meanFrame.length; ++n2) {
            for (n = 0; n < this.meanFrame[n2].length; ++n) {
                AbstractDataMatrix abstractDataMatrix;
                if (n2 == 0) {
                    abstractDataMatrix = new MVmatrix(1, this.meanFrame.length);
                    abstractDataMatrix.setRowType(64);
                    this.addMatrix(abstractDataMatrix, true);
                    abstractDataMatrix.setName(cellIdentifierModel.getLayerName(n));
                }
                abstractDataMatrix = this.getMatrixAt(n);
                abstractDataMatrix.setValue(0, n2, this.meanFrame[n2][n]);
            }
        }
        return this.meanFrame;
    }

    public void closeConnections() {
        if (this.cubeModel != null) {
            try {
                this.cubeModel.closeConnections();
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
    }

    public CellIdentifierModel getCubeModel() {
        return this.cubeModel;
    }

    public double getDoubleAt(int n, int n2, int n3) {
        if (this.meanFrame != null) {
            return this.meanFrame[n2][n3];
        }
        this.cubeModel.setCurrentLayer(n3);
        return this.cubeModel.getDirectDoubleAtNoMissing(n, n2);
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public File[] getFiles() {
        return new File[]{this.file};
    }

    public double[][][] getFrameCube() {
        return this.frameCube;
    }

    public double[][] getMeanFrame() {
        return this.meanFrame;
    }

    @Override
    public byte getMergeType() {
        return 0;
    }

    @Override
    public String getName() {
        return "Reference (" + this.percentage + "%)";
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    public int getPercentage() {
        return this.percentage;
    }

    public ReferenceTarget getReferenceTarget() {
        return this.referenceTarget;
    }

    public int getRowCount() {
        if (this.cubeModel != null) {
            return this.cubeModel.getRowCount();
        }
        return 0;
    }

    @Override
    public byte getTreeType() {
        return 12;
    }

    public boolean hasMeanLine() {
        return this.meanFrame != null;
    }

    @Override
    public boolean includeFileNames() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.meanFrame != null && this.frameCube != null;
    }

    public void loadDataFromDisk(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel) throws Exception {
        AbstractImportInfo abstractImportInfo = LoadHelper.getImportInfo(null, this.file);
        if (abstractImportInfo instanceof SacImageImportInfo) {
            ((SacImageImportInfo)abstractImportInfo).setSacType(this.percentage < 50 ? (byte)2 : 1);
        }
        this.setFile(progressManager, this.file, abstractImportInfo);
        this.calcMeanFrame(progressManager, cellIdentifierModel);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("percentage", this.percentage);
        randomOutputStream.writePropertyStringUTF("fname", this.file != null ? this.file.getAbsolutePath() : null);
        randomOutputStream.writePropertyDoubleArray("meanLine", this.meanFrame);
        if (this.referenceTarget != null) {
            randomOutputStream.writePropertyFloatArray("referenceTarget", this.referenceTarget.getValues());
        }
    }

    public void setFile(ProgressManager progressManager, File file, AbstractImportInfo abstractImportInfo) {
        this.file = file;
        AbstractImportPanel abstractImportPanel = abstractImportInfo.getImportPanel(this, null);
        this.cubeModel = abstractImportPanel.getCellIdentifierModel(progressManager, false);
        this.referenceTarget = this.readReferenceTarget();
    }

    private ReferenceTarget readReferenceTarget() {
        if (this.cubeModel instanceof AbstractHeaderDataSource) {
            try {
                File file = ((AbstractHeaderDataSource)this.cubeModel).getHeaderFile();
                if (file != null && file.exists()) {
                    HdrParser hdrParser = new HdrParser(file);
                    return ReferenceTarget.fromHdr(hdrParser.getFloatArray("reference target"));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public void setPercentage(int n) {
        this.percentage = n;
    }

    public void setProperties(Properties properties) {
        this.cubeModel.setProperties(properties);
    }

    private int count(CellIdentifierModel cellIdentifierModel, int n) {
        if (n == 0) {
            return this.cubeModel.getRowCount();
        }
        return cellIdentifierModel.getCount(n);
    }
}

