/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.calibration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.prediktera.image.dataimport.calibration.CubeClass;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.filechooser.ExtensionFilter;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.dataimport.image.hdr.HdrImageImportInfo;
import se.prediktera.map.dataimport.raw.RawImportInfo;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class CubePanel
extends JPanel {
    private final JLabel imageCubeLabel = new JLabel();
    private final JComboBox percentageComboBox = new JComboBox();
    private final JTextField fileTextField = new JTextField();
    private final JButton browseButton = new JButton("Browse");
    private final CubeClass cubeClass;

    public CubePanel(int n) {
        this.cubeClass = new CubeClass(n);
        this.init();
    }

    public CubeClass getCubeClass() {
        return this.cubeClass;
    }

    public int getPercentage() {
        return this.cubeClass.getPercentage();
    }

    public boolean isReady(CellIdentifierModel cellIdentifierModel, boolean bl) {
        if (this.cubeClass == null || this.cubeClass.getFile() == null) {
            JOptionPane.showConfirmDialog(this, "No file is chosen for the \"" + String.valueOf(this.percentageComboBox.getSelectedItem()) + "\" data cube", "No file", -1, 1);
            return false;
        }
        CellIdentifierModel cellIdentifierModel2 = this.cubeClass.getCubeModel();
        if (cellIdentifierModel2 == null || cellIdentifierModel == null) {
            return false;
        }
        if (bl && cellIdentifierModel.getRowCount() != cellIdentifierModel2.getRowCount() || cellIdentifierModel.getColumnCount() != cellIdentifierModel2.getColumnCount() || cellIdentifierModel.getLayerCount() != cellIdentifierModel2.getLayerCount()) {
            JOptionPane.showConfirmDialog(this, "Dimension for \"" + String.valueOf(this.percentageComboBox.getSelectedItem()) + "\" data cube does not agree with imported data", "Dimension does not agree", -1, 1);
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.percentageComboBox.setEnabled(bl);
        this.browseButton.setEnabled(bl);
    }

    public void setFile(ProgressManager progressManager, File file, AbstractImportInfo abstractImportInfo) {
        try {
            this.cubeClass.setFile(progressManager, file, abstractImportInfo);
            this.fileTextField.setText(file.getName());
        }
        catch (Exception exception) {
            if (progressManager != null) {
                progressManager.Finish();
            }
            this.fileTextField.setText("");
            JOptionPane.showConfirmDialog(this, exception.getMessage(), "File error", -1, 0);
        }
    }

    private ImageIcon createImageCube(int n) {
        BufferedImage bufferedImage = new BufferedImage(41, 41, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n2 = 255 * n / 100;
        graphics2D.setColor(new Color(n2, n2, n2));
        graphics2D.fillRect(0, 8, 32, 32);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 8, 32, 32);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 8.0f);
        generalPath.lineTo(32.0f, 8.0f);
        generalPath.lineTo(40.0f, 0.0f);
        generalPath.lineTo(8.0f, 0.0f);
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(32.0f, 8.0f);
        generalPath2.lineTo(32.0f, 40.0f);
        generalPath2.lineTo(40.0f, 32.0f);
        generalPath2.lineTo(40.0f, 0.0f);
        generalPath2.closePath();
        int n3 = Math.min(n2 + 25, 255);
        graphics2D.setColor(new Color(n3, n3, n3));
        graphics2D.fill(generalPath);
        graphics2D.fill(generalPath2);
        graphics2D.setColor(Color.black);
        graphics2D.draw(generalPath);
        graphics2D.draw(generalPath2);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private jopensaveDialog createOpenDialog() {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select reference file", null);
        Vector<AbstractImportInfo> vector = ImportHelper.getExternImportInfo();
        for (int i = 0; i < vector.size(); ++i) {
            jopensaveDialog2.addExtension(vector.elementAt(i));
        }
        class SACReferenceImportInfo
        extends HdrImageImportInfo {
            SACReferenceImportInfo() {
            }

            @Override
            public String getDescription() {
                return CubePanel.this.getPercentage() > 50 ? "SAC white reference file (*.wrw)" : "SAC dark reference file (*.drw)";
            }

            @Override
            public String[] getExt() {
                return new String[]{CubePanel.this.getPercentage() > 50 ? "wrw" : "drw"};
            }
        }
        jopensaveDialog2.addExtension(new SACReferenceImportInfo());
        jopensaveDialog2.addAllSupported();
        jopensaveDialog2.addAllFiles();
        jopensaveDialog2.addFiltersIntoDialog();
        File file = IniManager.getWorkDir((byte)1);
        if (file != null) {
            jopensaveDialog2.setCurrentDirectory(file);
        }
        return jopensaveDialog2;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.imageCubeLabel.setIcon(this.createImageCube(this.cubeClass.getPercentage()));
        this.add((Component)this.imageCubeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        for (int i = 0; i <= 100; ++i) {
            PercentageClass percentageClass = new PercentageClass(i, "reflectance");
            this.percentageComboBox.addItem(percentageClass);
        }
        this.percentageComboBox.setSelectedIndex(this.cubeClass.getPercentage());
        this.percentageComboBox.addItemListener(itemEvent -> {
            this.cubeClass.setPercentage(this.percentageComboBox.getSelectedIndex());
            this.imageCubeLabel.setIcon(this.createImageCube(this.cubeClass.getPercentage()));
        });
        this.add((Component)this.percentageComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.fileTextField.setEnabled(false);
        this.fileTextField.setEditable(false);
        this.add((Component)this.fileTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.browseButton.addActionListener(actionEvent -> {
            final jopensaveDialog jopensaveDialog2 = this.createOpenDialog();
            if (jopensaveDialog2.showOpenDialog(this) == 0) {
                ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                    final /* synthetic */ CubePanel this$0;
                    {
                        this.this$0 = cubePanel;
                    }

                    @Override
                    public Object doWork() {
                        ExtensionFilter extensionFilter = jopensaveDialog2.getMatchingFilter();
                        AbstractImportInfo abstractImportInfo = extensionFilter == null ? new RawImportInfo() : (AbstractImportInfo)extensionFilter.object;
                        this.this$0.setFile(this, jopensaveDialog2.getSelectedFile(), abstractImportInfo);
                        return null;
                    }
                };
                progressManagerImpl.invokeLater();
            }
        });
        this.add((Component)this.browseButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
    }

    private static class PercentageClass {
        private final int percentage;
        public String name;

        public PercentageClass(int n, String string) {
            this.percentage = n;
            this.name = string;
        }

        public String toString() {
            return this.percentage + "% " + this.name;
        }
    }
}

