/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.hips;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import se.prediktera.map.dataimport.breeze.Interleave;
import se.prediktera.map.dataimport.image.AbstractHeaderDataSource;

public class HIPSDataSource
extends AbstractHeaderDataSource {
    private final File headerFile;
    private double[] wavelength;

    public HIPSDataSource(File[] fileArray, byte by) throws IOException {
        super(fileArray[0], by);
        String string = fileArray[0].getAbsolutePath();
        this.headerFile = new File(string);
        if (!this.headerFile.exists()) {
            throw new IOException("Cannot locate header file");
        }
        this.readHeader();
    }

    @Override
    public String getLayerName(int n) {
        if (this.wavelength != null) {
            return String.valueOf(this.wavelength[n]);
        }
        return "Layer " + (n + 1);
    }

    @Override
    public String getName() {
        return "HIPS";
    }

    @Override
    public byte getTreeType() {
        return 7;
    }

    @Override
    protected void readHeader() throws IOException {
        int[] nArray;
        BufferedReader bufferedReader;
        block9: {
            bufferedReader = new BufferedReader(new FileReader(this.headerFile));
            nArray = new int[]{0, 0, 0};
            int n = 0;
            int n2 = 0;
            do {
                String string = bufferedReader.readLine();
                try {
                    int n3;
                    nArray[n] = n3 = Integer.parseInt(string);
                    if (++n != 3) continue;
                    break block9;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            } while (++n2 <= 100);
            throw new IOException("Incorrect file format");
        }
        bufferedReader.close();
        this.imageStart = 0L;
        this.interleave = Interleave.BSQ;
        short s = (short)nArray[2];
        this.imageWidth = s;
        this.columns = s;
        short s2 = (short)nArray[1];
        this.imageHeight = s2;
        this.rows = s2;
        this.layerCount = (short)nArray[0];
        long l = this.headerFile.length();
        int n = (int)(l / (long)(this.rows * this.columns * this.layerCount));
        if (n >= 8) {
            this.fileDataType = (byte)5;
            this.sampleSize = 8;
        } else if (n >= 4) {
            this.fileDataType = (byte)4;
            this.sampleSize = 4;
        } else if (n >= 2) {
            this.fileDataType = 1;
            this.sampleSize = 2;
        } else {
            this.fileDataType = 0;
            this.sampleSize = 1;
        }
        this.dataType = this.fileDataType;
        this.imageStart = l - (long)(this.rows * this.columns * this.layerCount * this.sampleSize);
    }
}

