/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.raman;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import se.prediktera.image.dataimport.raman.RamanDataSource;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.raw.DelimiterPanel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class RamanImportPanel
extends AbstractImportPanel {
    private DelimiterPanel delimiterPanel;
    private RamanDataSource dsciModel;

    public RamanImportPanel(ImportInterface importInterface) {
        super((LayoutManager)new BorderLayout(), importInterface.getFiles());
        try {
            this.dsciModel = new RamanDataSource(this.filenames, importInterface.getMergeType(), importInterface.includeFileNames());
            this.delimiterPanel = new DelimiterPanel(this.dsciModel){

                @Override
                public void updatePreviewTable() {
                    RamanImportPanel.this.updatePreviewTable();
                }
            };
            this.analyseDelimiter(true);
            this.add((Component)this.delimiterPanel, "Center");
        }
        catch (IOException iOException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public CellIdentifierModel getCashedCiModel() {
        TableModel tableModel;
        if (this.delimiterPanel != null && (tableModel = this.delimiterPanel.getTableModel()) instanceof CellIdentifierModel) {
            return (CellIdentifierModel)tableModel;
        }
        return null;
    }

    @Override
    public CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        System.gc();
        this.dsciModel.indexDataSource(progressManager, this.delimiterPanel.getDelimiterIndex(), this.delimiterPanel.treatConsecutiveDelimitersAsOne(), bl);
        return this.dsciModel;
    }

    @Override
    public String getType() {
        return "Text";
    }

    @Override
    public boolean hasSettings() {
        return true;
    }

    public void setDelimiter(String string) {
        this.delimiterPanel.setDelimiter(string);
    }

    @Override
    public void updateInfo(ImportInterface importInterface) {
        this.delimiterPanel.setTableModel(new DefaultTableModel());
        super.updateInfo(importInterface);
        try {
            this.dsciModel.set(importInterface.getFiles(), importInterface.getMergeType(), importInterface.includeFileNames());
        }
        catch (IOException iOException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
        this.analyseDelimiter(false);
        this.updatePreviewTable();
    }

    public void updatePreviewTable() {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                this.setInfoText("Checking file");
                CellIdentifierModel cellIdentifierModel = RamanImportPanel.this.getCellIdentifierModel(this, true);
                if (cellIdentifierModel != null) {
                    RamanImportPanel.this.delimiterPanel.setTableModel(cellIdentifierModel);
                }
                return null;
            }
        };
        SwingUtilities.invokeLater(progressManagerImpl);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.dsciModel = null;
        if (this.delimiterPanel != null) {
            this.delimiterPanel.cleanUp();
            this.delimiterPanel = null;
        }
    }

    private void analyseDelimiter(boolean bl) {
        if (this.delimiterPanel != null) {
            this.delimiterPanel.analyzeDelimiter(bl);
        }
    }
}

