/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.spf;

import java.io.File;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.dataimport.image.AbstractHeaderDataSource;

public class SpfDataSource
extends AbstractHeaderDataSource {
    public SpfDataSource(File[] fileArray, byte by) throws IOException {
        super(fileArray[0], by);
        this.readHeader();
    }

    public SpfDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public String getLayerName(int n) {
        return "Layer " + n;
    }

    @Override
    public String getName() {
        return "SPF";
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    @Override
    protected void readHeader() throws IOException {
        this.inStream.seek(15L);
        byte by = this.inStream.readByte();
        if (by != 66 && by != 70 && by != 74) {
            throw new IOException("Unknown MatrixNIR/Sapphire file type (" + by + ")");
        }
        System.out.println("SourceMode " + by);
        if (by == 66) {
            this.skip(17);
        } else {
            this.skip(25);
        }
        this.layerCount = this.inStream.readByte();
        this.skip(14);
        this.imageWidth = this.readShort();
        this.imageHeight = this.readShort();
        this.readInt();
        this.readInt();
        if (by == 70) {
            this.skip(218);
        } else {
            this.skip(16);
        }
        byte[] byArray = new byte[this.readShort()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.inStream.readByte();
        }
        System.out.println(new String(byArray));
        if (by == 74) {
            this.skip(210);
        } else {
            this.skip(4);
        }
        this.imageStart = this.inStream.getFilePointer();
        this.currentLayer = 0;
        this.rows = this.imageHeight;
        this.columns = this.imageWidth;
        this.sampleSize = 4;
        this.fileDataType = (byte)4;
        this.dataType = this.fileDataType;
    }

    protected int readInt() throws IOException {
        this.inStream.read(this.bytes);
        return this.correctByteOrderInt(this.bytes, 0);
    }

    protected short readShort() throws IOException {
        this.inStream.read(this.bytes, 0, 2);
        return this.correctByteOrderShort(this.bytes, 0);
    }

    private void skip(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.inStream.readByte();
        }
    }
}

