/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.dataimport.tiff;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class TiffImageReader
extends ImageReader {
    private static int[] byteSizes = new int[]{1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private boolean gotHeader = false;
    private ImageInputStream stream = null;
    private int width;
    private int height;
    private int rowsPerStrip;
    private int samplesPerPixel = 3;
    private long[] stripOffsets;
    private Compression compression = Compression.none;
    private short[] sampleType = new short[]{1, 1, 1};

    public TiffImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.height;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nArray = new int[]{0, 1, 2};
        arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, false, false));
        return arrayList.iterator();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.width;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        int n2 = 2;
        if (this.samplesPerPixel < 4) {
            n2 = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, n2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (this.stripOffsets != null) {
            int n3 = 0;
            for (long l : this.stripOffsets) {
                this.stream.seek(l);
                for (int i = 0; i < this.rowsPerStrip && n3 < this.height; ++i, ++n3) {
                    for (int j = 0; j < this.width; ++j) {
                        for (int k = 0; k < this.samplesPerPixel; ++k) {
                            long l2 = this.readAsLong(this.sampleType[k]);
                            if (this.sampleType[k] == 3) {
                                l2 >>= 8;
                            } else if (this.sampleType[k] == 4) {
                                l2 >>= 24;
                            }
                            writableRaster.setSample(j, n3, k, (int)l2);
                        }
                    }
                }
            }
        }
        return bufferedImage;
    }

    public void readHeader() throws IOException {
        int n;
        if (this.gotHeader) {
            return;
        }
        this.gotHeader = true;
        if (this.stream == null) {
            throw new IllegalStateException("No input stream");
        }
        byte[] byArray = new byte[2];
        try {
            this.stream.readFully(byArray);
            if (byArray[0] == 73) {
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            n = this.stream.readShort();
            if (n != 42) {
                throw new IIOException("Bad magic number!");
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Error reading signature", iOException);
        }
        try {
            n = this.stream.readInt();
            this.stream.seek(n);
            int n2 = this.stream.readShort();
            block13: for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                long[] lArray = null;
                double[] dArray = null;
                short s = this.stream.readShort();
                short s2 = this.stream.readShort();
                int n5 = this.stream.readInt();
                int n6 = n5 * this.getTypeByteSize(s2);
                boolean bl = n6 > 4;
                int n7 = n4 = bl ? this.stream.readInt() : this.readPaddedInt(s2);
                if (bl) {
                    this.stream.mark();
                    this.stream.seek(n4);
                    if (s2 == 5 || s2 == 11 || s2 == 12) {
                        dArray = new double[n5];
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray[n3] = this.readAsDouble(s2);
                        }
                    } else {
                        lArray = new long[n5];
                        for (n3 = 0; n3 < n5; ++n3) {
                            lArray[n3] = this.readAsLong(s2);
                        }
                    }
                    this.stream.reset();
                }
                System.out.printf("0x%x %d %d %d (0x%x)\n", s, s2, n5, n4, n4);
                switch (s) {
                    case 256: {
                        this.width = n4;
                        continue block13;
                    }
                    case 257: {
                        this.height = n4;
                        continue block13;
                    }
                    case 258: {
                        if (lArray == null) continue block13;
                        if (n5 > this.sampleType.length) {
                            this.sampleType = new short[n5];
                        }
                        for (n3 = 0; n3 < n5; ++n3) {
                            if (lArray[n3] <= 8L) {
                                this.sampleType[n3] = 1;
                                continue;
                            }
                            if (lArray[n3] <= 16L) {
                                this.sampleType[n3] = 3;
                                continue;
                            }
                            if (lArray[n3] > 32L) continue;
                            this.sampleType[n3] = 4;
                        }
                        continue block13;
                    }
                    case 259: {
                        if (n4 == 2) {
                            this.compression = Compression.huffman;
                            continue block13;
                        }
                        if (n4 == 5) {
                            this.compression = Compression.lzw;
                            continue block13;
                        }
                        if (n4 == 6) {
                            this.compression = Compression.jpeg;
                            continue block13;
                        }
                        if (n4 != 32773) continue block13;
                        this.compression = Compression.packbits;
                        continue block13;
                    }
                    case 273: {
                        if (lArray == null) {
                            this.stripOffsets = new long[]{n4};
                            continue block13;
                        }
                        this.stripOffsets = lArray;
                        continue block13;
                    }
                    case 277: {
                        this.samplesPerPixel = n4;
                        if (this.sampleType.length == this.samplesPerPixel) continue block13;
                        short[] sArray = new short[this.samplesPerPixel];
                        System.arraycopy(this.sampleType, 0, sArray, 0, Math.min(sArray.length, this.sampleType.length));
                        this.sampleType = sArray;
                        continue block13;
                    }
                    case 278: {
                        this.rowsPerStrip = n4;
                        continue block13;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Error reading header", iOException);
        }
        if (this.compression != Compression.none) {
            throw new IIOException("No support for compressed TIFFs yet. Please resave as uncompressed and try again.");
        }
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object == null) {
            this.stream = null;
            return;
        }
        if (!(object instanceof ImageInputStream)) {
            throw new IllegalArgumentException("bad input");
        }
        this.stream = (ImageInputStream)object;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("bad index");
        }
    }

    private int getTypeByteSize(short s) {
        if (s < 1 || s >= byteSizes.length) {
            return 0;
        }
        return byteSizes[s - 1];
    }

    private double readAsDouble(short s) throws IOException {
        return switch (s) {
            case 5, 10 -> (double)this.stream.readInt() / (double)this.stream.readInt();
            case 11 -> this.stream.readFloat();
            case 12 -> this.stream.readDouble();
            default -> this.readAsLong(s);
        };
    }

    private long readAsLong(short s) throws IOException {
        if (s == 7 || s > 12 || s < 1) {
            return 0L;
        }
        return switch (s) {
            case 1, 2, 6 -> this.stream.readByte();
            case 3, 8 -> this.stream.readShort();
            case 4 -> this.stream.readInt();
            default -> (long)this.readAsDouble(s);
        };
    }

    private int readPaddedInt(short s) throws IOException {
        int n = 0;
        switch (s) {
            case 1: 
            case 2: {
                n = this.stream.readByte();
                this.stream.readByte();
                this.stream.readShort();
                break;
            }
            case 3: {
                n = this.stream.readShort();
                this.stream.readShort();
                break;
            }
            default: {
                n = this.stream.readInt();
            }
        }
        return n;
    }

    private static enum Compression {
        none,
        huffman,
        packbits,
        lzw,
        jpeg;

    }
}

