/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.plot;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Vector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.plot.axisplot.windows.PlotZone;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlot;

public class PlotZoneSpectral
extends PlotZone
implements DataTreeExtLibInterface {
    private final DataTreeInterface dti;
    private final int index;
    private final SpectralPlot samPlot = new SpectralPlot();

    public PlotZoneSpectral(double d, double d2, DataTreeInterface dataTreeInterface, int n) {
        super(d, d2, (byte)1);
        this.dti = dataTreeInterface;
        this.index = n;
        this.initSpectral();
    }

    public PlotZoneSpectral(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.dti = mapProperty.resolveNodeFromName(randomInputStream, "dti");
        this.index = mapProperty.getPropertyInt("i");
        this.initSpectral();
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 6;
    }

    @Override
    protected void paint(Graphics2D graphics2D, byte by, double d) {
        if (this.bkcolor != null) {
            graphics2D.setColor(this.bkcolor);
            graphics2D.fillRect(this.origoX, this.origoY, this.width - 1, this.height - 1);
        }
        Stroke stroke = graphics2D.getStroke();
        if (this.width > 4 && this.height > 4) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(this.origoX + 2, this.origoY + 2);
            this.samPlot.paint(graphics2D, this.width - 4, this.height - 4);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setStroke(stroke);
        if (this.bordercolor != null) {
            graphics2D.setColor(this.bordercolor);
            graphics2D.drawRect(this.origoX, this.origoY, this.width - 1, this.height - 1);
        }
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("dti", this.dti);
        randomOutputStream.writePropertyInt("i", this.index);
    }

    private void initSpectral() {
        AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)this.dti;
        int n = abstractDataMatrix.isModel() ? abstractDataMatrix.getN() : abstractDataMatrix.getK();
        DataWrapper dataWrapper = new DataWrapper(n, abstractDataMatrix.getFoldName(this.index));
        for (int i = 0; i < n; ++i) {
            dataWrapper.setYvalueAt(i, abstractDataMatrix.isModel() ? (float)abstractDataMatrix.getValue(i, this.index) : (float)abstractDataMatrix.getValue(this.index, i));
        }
        Vector<DataWrapper> vector = new Vector<DataWrapper>();
        if (dataWrapper != null) {
            vector.add(dataWrapper);
        }
        this.samPlot.setData(vector);
        this.samPlot.setPreview();
    }
}

