/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.plot;

import java.io.IOException;
import se.prediktera.image.plot.FloatWindowRgbImage;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;

public class RgbImagePlot
extends AbstractPlotBaseWindow
implements DataTreeExtLibInterface {
    public RgbImagePlot(Plot_GUI plot_GUI, PlotInit plotInit) {
        super(plot_GUI, plotInit);
        try {
            plotInit.range_plot = true;
            FloatWindowRgbImage floatWindowRgbImage = new FloatWindowRgbImage(this, plotInit, 0.1, 0.1, 0.9, 0.9);
            this.floatPlotWindow = floatWindowRgbImage;
            this.addWindow(this.floatPlotWindow, 0, 4);
            floatWindowRgbImage.setShowGrid(false);
            floatWindowRgbImage.setShowZeroLines(false);
            floatWindowRgbImage.setTitle(plotInit.title);
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    public RgbImagePlot(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    @Override
    public int getInteractiveTag() {
        return 3;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    @Override
    protected String getDefaultTitle() {
        return "RGB Image";
    }

    @Override
    protected String getHelpID() {
        return "evinceContour2d";
    }
}

