/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.plot.info;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.PredictionHelper;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2DInfo;

public class Contour2DPredictionInfo
extends Contour2DInfo {
    private AbstractModel model = null;
    private final JPanel predictionPanel = new JPanel(new GridBagLayout());
    private final JComboBox predictionComboBox = new JComboBox();

    @Override
    public void beginWizard(DataTreeInterface dataTreeInterface) {
        super.beginWizard(dataTreeInterface);
        this.predictionComboBox.removeAllItems();
        PredictionHelper.addPredictionToComboBox(dataTreeInterface, this.predictionComboBox, Boolean.TRUE);
        this.predictionComboBox.setEnabled(this.predictionComboBox.getItemCount() > 1);
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        this.predictionComboBox.removeAllItems();
        this.model = null;
    }

    @Override
    public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
        DataTreeInterface dataTreeInterface;
        PlotInit plotInit = (PlotInit)abstractInit;
        if (this.predictionComboBox.getItemCount() == 0) {
            PredictionHelper.addPredictionToComboBox(abstractInit.getDataTreeInterface(), this.predictionComboBox, Boolean.TRUE);
        }
        if ((dataTreeInterface = (DataTreeInterface)this.predictionComboBox.getSelectedItem()) instanceof AbstractPrediction) {
            AbstractPrediction abstractPrediction = (AbstractPrediction)dataTreeInterface;
            this.model = abstractPrediction.getModel();
            plotInit.setDataTreeInterface(abstractPrediction.getDataSetMatrixToPredictInX());
        }
        return super.createWindow(abstractWindow_GUI, abstractInit);
    }

    @Override
    public Vector<JComponent> createWizard() {
        Vector<JComponent> vector = super.createWizard();
        this.predictionPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Choose prediction"));
        this.predictionPanel.add((Component)new JLabel("Prediction:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.predictionPanel.add((Component)this.predictionComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(6, 6, 6, 12), 0, 0));
        vector.add(0, this.predictionPanel);
        return vector;
    }

    @Override
    public String getScript() {
        if (this.model != null) {
            return "plot.setColor(\"prediction category\", \"Pred. " + String.valueOf(this.model) + "\");plot.addLegend(\"color\");";
        }
        return "";
    }

    @Override
    public String getWizardInfo() {
        return "Creates a Contour 2D prediction plot from the selected data. This plot shows an overview of the entire matrix in two dimensions. The color is according to prediction category and the legend shows the class names";
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        return PredictionHelper.getPredictions(dataTreeInterface, Boolean.TRUE).size() > 0;
    }

    @Override
    public String toString() {
        return "Contour 2D Prediction";
    }
}

