/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.prediktera.image.process.ImageProcessMatrix;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.dataimport.breeze.image.process.ImageProcessHelper;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptManager;

public class ImageProcessDialog
extends CleanUpDialog {
    public static final int[] METHOD_KERNEL_SIZE = new int[]{5, 5, 5, 5, 7, 0, 3, 3, 0, 15};
    private JComboBox algorithmComboBox;
    private JLabel algorithmLabel;
    private JButton applyButton;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JLabel kernelLabel;
    private JTextField kernelTextField;
    private JButton okButton;
    private JLabel optionLabel;
    private JTextField optionTextField;
    private JCheckBox previewCheckBox;
    private JPanel previewPanel;
    private Project_GUI project_GUI;
    private AbstractDataMatrix matrix;
    private PreviewImagePanel previewImagePanel;
    private boolean isupdating = false;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(() -> {
            ImageProcessDialog imageProcessDialog = new ImageProcessDialog((Frame)new JFrame(), true);
            imageProcessDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            imageProcessDialog.setVisible(true);
        });
    }

    public static void showDialog(Project_GUI project_GUI, AbstractDataMatrix abstractDataMatrix) {
        ImageProcessDialog imageProcessDialog = new ImageProcessDialog(IniManager.getMainFrame(), false);
        imageProcessDialog.project_GUI = project_GUI;
        imageProcessDialog.matrix = abstractDataMatrix;
        imageProcessDialog.processImage(true);
        imageProcessDialog.setTitle("Process Image");
        imageProcessDialog.pack();
        imageProcessDialog.setLocationRelativeTo(null);
        imageProcessDialog.setVisible(true);
    }

    public ImageProcessDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        for (String string : ImageProcessHelper.METHOD_NAME) {
            this.algorithmComboBox.addItem(string);
        }
        this.previewImagePanel = new PreviewImagePanel();
        this.previewPanel.add((Component)this.previewImagePanel, "Center");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && ImageProcessDialog.this.previewCheckBox.isSelected()) {
                    ImageProcessDialog.this.processImage(true);
                }
            }
        };
        this.kernelTextField.addKeyListener(keyAdapter);
        this.optionTextField.addKeyListener(keyAdapter);
    }

    @Override
    protected void cleanUpChild() {
        this.project_GUI = null;
        this.matrix = null;
    }

    private void algorithmComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            int n = this.algorithmComboBox.getSelectedIndex();
            this.kernelTextField.setText(String.valueOf(METHOD_KERNEL_SIZE[n]));
            if (this.previewCheckBox.isSelected()) {
                this.processImage(true);
            }
        }
    }

    private void applyButtonActionPerformed(ActionEvent actionEvent) {
        this.processImage(false);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void initComponents() {
        this.algorithmLabel = new JLabel();
        this.algorithmComboBox = new JComboBox();
        this.optionLabel = new JLabel();
        this.optionTextField = new JTextField();
        this.kernelLabel = new JLabel();
        this.kernelTextField = new JTextField();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.previewPanel = new JPanel();
        this.previewCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.algorithmLabel.setText("Algorithm");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.algorithmLabel, gridBagConstraints);
        this.algorithmComboBox.addItemListener(itemEvent -> this.algorithmComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.algorithmComboBox, gridBagConstraints);
        this.optionLabel.setText("Option");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.getContentPane().add((Component)this.optionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.optionTextField, gridBagConstraints);
        this.kernelLabel.setText("Kernel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.getContentPane().add((Component)this.kernelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.kernelTextField, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(81, 26));
        this.okButton.addActionListener(actionEvent -> this.okButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.jPanel1.add((Component)this.okButton, gridBagConstraints);
        this.applyButton.setText("Apply");
        this.applyButton.setPreferredSize(new Dimension(81, 26));
        this.applyButton.addActionListener(actionEvent -> this.applyButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.jPanel1.add((Component)this.applyButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(81, 26));
        this.cancelButton.addActionListener(actionEvent -> this.cancelButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.jPanel1.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.previewPanel.setPreferredSize(new Dimension(400, 300));
        this.previewPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ImageProcessDialog.this.previewPanelComponentResized(componentEvent);
            }
        });
        this.previewPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.getContentPane().add((Component)this.previewPanel, gridBagConstraints);
        this.previewCheckBox.setSelected(true);
        this.previewCheckBox.setText("Automatic preview");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.previewCheckBox, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.processImage(false);
        this.dispose();
    }

    private void previewPanelComponentResized(ComponentEvent componentEvent) {
        if (this.previewCheckBox.isSelected()) {
            this.processImage(true);
        }
    }

    private void processImage(final boolean bl) {
        if (!this.isupdating || !bl) {
            this.isupdating = true;
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                final /* synthetic */ ImageProcessDialog this$0;
                {
                    this.this$0 = imageProcessDialog;
                }

                @Override
                public Object doWork() {
                    try {
                        Properties properties = new Properties();
                        properties.put("preview", bl ? "true" : "false");
                        byte by = (byte)this.this$0.algorithmComboBox.getSelectedIndex();
                        double d = NiceDataFormat.toNumber(this.this$0.optionTextField.getText());
                        int n = (int)NiceDataFormat.toNumber(this.this$0.kernelTextField.getText());
                        ImageProcessMatrix imageProcessMatrix = ImageProcessMatrix.processImage(this, this.this$0.matrix, by, d, n, properties);
                        if (bl) {
                            this.this$0.previewImagePanel.contentPaint(imageProcessMatrix);
                        } else {
                            ScriptManager scriptManager = new ScriptManager(this.this$0.project_GUI);
                            scriptManager.addVariable(imageProcessMatrix, "matrix");
                            Object object = "plot = createPlot(\"contour2D\", matrix, {\"aspectratio=true\"});";
                            if (by == 5 || by == 8 || by == 7 || by == 6) {
                                object = (String)object + "plot.setColor(\"fixed\", \"black\");";
                            }
                            scriptManager.evaluteScript(this, (String)object, false, true);
                        }
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                    }
                    this.this$0.isupdating = false;
                    return null;
                }
            };
            progressManagerImpl.invokeLater();
        }
    }

    private class PreviewImagePanel
    extends JPanel {
        private BufferedImage image = null;
        private int stopX;
        private int startY;
        private int stopY;

        private PreviewImagePanel() {
        }

        public void contentPaint(ImageProcessMatrix imageProcessMatrix) {
            double d;
            double d2;
            double d3;
            int n = this.getWidth();
            int n2 = this.getHeight();
            double d4 = imageProcessMatrix.getK();
            double d5 = (double)n / d4;
            if (d5 > (d3 = (double)n2 / (d2 = (double)imageProcessMatrix.getN()))) {
                n = (int)((double)n / d5 * d3);
                d5 = d3;
            } else {
                n2 = (int)((double)n2 / d3 * d5);
                d3 = d5;
            }
            d3 *= -1.0;
            if (n <= 0) {
                n = 1;
            }
            if (n2 <= 0) {
                n2 = 1;
            }
            byte by = imageProcessMatrix.getProcessType();
            this.image = new BufferedImage(n, n2, 2);
            double d6 = 0.0;
            double d7 = 0.0;
            boolean bl = true;
            int n3 = 0;
            while ((double)n3 < d2) {
                int n4 = 0;
                while ((double)n4 < d4) {
                    d = imageProcessMatrix.getValue(n3, n4);
                    if (!imageProcessMatrix.isMissing(n3, n4)) {
                        if (bl) {
                            d6 = d;
                            d7 = d;
                            bl = false;
                        } else {
                            if (d < d6) {
                                d6 = d;
                            }
                            if (d > d7) {
                                d7 = d;
                            }
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            double d8 = 1.0 / d5;
            d = -1.0 / d3;
            if (d8 < 1.0) {
                d8 = 1.0;
            }
            if (d < 1.0) {
                d = 1.0;
            }
            WritableRaster writableRaster = this.image.getRaster();
            int n5 = 0;
            this.startY = 0;
            for (double d9 = 0.0; d9 < d2; d9 += d) {
                this.stopY = this.minCeil((d9 + d) / d2, n2);
                if (this.startY == this.stopY) continue;
                n5 = 0;
                for (double d10 = 0.0; d10 < d4; d10 += d8) {
                    this.stopX = this.minCeil((d10 + d8) / d4, n);
                    if (n5 == this.stopX) continue;
                    double d11 = imageProcessMatrix.getValue((int)d9, (int)d10);
                    int n6 = (int)((d11 - d6) / (d7 - d6) * 255.0);
                    boolean bl2 = imageProcessMatrix.isMissing((int)d9, (int)d10);
                    if (bl2) {
                        n6 = 255;
                    } else if (by == 5 || by == 8 || by == 7 || by == 6) {
                        n6 = d11 == 0.0 ? 255 : 0;
                    }
                    for (int i = this.startY; i < this.stopY; ++i) {
                        for (int j = n5; j < this.stopX; ++j) {
                            writableRaster.setSample(j, i, 0, n6);
                            writableRaster.setSample(j, i, 1, n6);
                            writableRaster.setSample(j, i, 2, n6);
                            writableRaster.setSample(j, i, 3, 255);
                        }
                    }
                    n5 = this.stopX;
                }
                this.startY = this.stopY;
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.image != null) {
                graphics2D.drawImage((Image)this.image, 0, 0, null);
            }
        }

        private int minCeil(double d, int n) {
            return (int)Math.min(Math.ceil(d * (double)n), (double)n);
        }
    }
}

