/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.sam;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.image.sam.SAMselectionPanel;
import se.prediktera.image.sam.SamAlgorithm;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractAxisPlotInfo;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2D;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2DInfo;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.Contour3D;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.Contour3DInfo;

public class SAMDialog
extends JDialog {
    private final SAMselectionPanel samSelectionPanel;
    private boolean result = false;
    private final AbstractAxisPlot axisPlot;
    private JButton cancelButton;
    private JButton createButton;
    private JPanel jPanel1;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(() -> {
            SAMDialog sAMDialog = new SAMDialog(new JFrame(), null, true);
            sAMDialog.pack();
            sAMDialog.setVisible(true);
        });
    }

    public SAMDialog(JFrame jFrame, AbstractAxisPlot abstractAxisPlot, boolean bl) {
        super((Frame)jFrame, bl);
        this.axisPlot = abstractAxisPlot;
        this.initComponents();
        this.samSelectionPanel = new SAMselectionPanel((AbstractPlotBaseWindow)abstractAxisPlot.getPlotLayout());
        this.samSelectionPanel.setCreatePanel();
        this.getContentPane().add((Component)this.samSelectionPanel, "Center");
        this.setTitle("Create Spectral Angle Map");
    }

    public DataTreeInterface showModal() {
        DenseVector denseVector;
        this.setModal(true);
        this.setVisible(true);
        if (this.result && (denseVector = this.samSelectionPanel.getReference()) != null) {
            AbstractPlotBaseWindow abstractPlotBaseWindow;
            PlotInit plotInit;
            AbstractAxisPlotInfo abstractAxisPlotInfo;
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)this.axisPlot.getPlotInit().getDataTreeInterface();
            if (abstractDataMatrix instanceof FoldMatrix) {
                abstractDataMatrix = ((FoldMatrix)abstractDataMatrix).getRootReferencedMatrix();
            }
            AbstractDataMatrix abstractDataMatrix2 = SamAlgorithm.createSamMatrix(abstractDataMatrix, denseVector);
            Case case_ = abstractDataMatrix.getCase();
            abstractDataMatrix2.setName(case_.getUniqueName("SAM matrix"));
            case_.addData(abstractDataMatrix2);
            if (this.samSelectionPanel.isContour2D()) {
                abstractAxisPlotInfo = new Contour2DInfo();
                plotInit = (PlotInit)abstractAxisPlotInfo.getInit(abstractDataMatrix2);
                plotInit.dofold = true;
                abstractPlotBaseWindow = (Contour2D)((Contour2DInfo)abstractAxisPlotInfo).createWindow((AbstractWindow_GUI)this.axisPlot.getPlotGui(), plotInit);
                this.axisPlot.getPlotGui().addWindow((AbstractWindow)abstractPlotBaseWindow, false, true);
                abstractPlotBaseWindow.getAxisPlot().hideComboBoxOfType((byte)9);
            }
            if (this.samSelectionPanel.isContour3D()) {
                abstractAxisPlotInfo = new Contour3DInfo();
                plotInit = (PlotInit)abstractAxisPlotInfo.getInit(abstractDataMatrix2);
                plotInit.dofold = true;
                abstractPlotBaseWindow = (Contour3D)((Contour3DInfo)abstractAxisPlotInfo).createWindow((AbstractWindow_GUI)this.axisPlot.getPlotGui(), plotInit);
                this.axisPlot.getPlotGui().addWindow((AbstractWindow)abstractPlotBaseWindow, false, true);
                abstractPlotBaseWindow.getAxisPlot().hideComboBoxOfType((byte)9);
            }
        }
        return null;
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        this.result = true;
        this.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.createButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new GridBagLayout());
        this.createButton.setText("OK");
        this.createButton.setMinimumSize(new Dimension(81, 26));
        this.createButton.setPreferredSize(new Dimension(81, 26));
        this.createButton.addActionListener(actionEvent -> this.createButtonActionPerformed(actionEvent));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.jPanel1.add((Component)this.createButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(81, 26));
        this.cancelButton.setPreferredSize(new Dimension(81, 26));
        this.cancelButton.addActionListener(actionEvent -> this.cancelButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.jPanel1.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }
}

