/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.sam;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.image.sam.SamAlgorithm;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.selection.AbstractSelectionPage;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlot;

public class SAMselectionPanel
extends AbstractSelectionPage {
    private int selectionType = 0;
    private final Vector<DataWrapper> referencePointList = new Vector();
    private JLabel angleLabel;
    private ButtonGroup buttonGroup;
    private JPanel cardPanel;
    private JCheckBox contour2DCheckBox;
    private JCheckBox contour3DCheckBox;
    private JPanel createPanel;
    private JRadioButton fileRadioButton;
    private JList referenceList;
    private JPanel referencePanel;
    private JScrollPane referenceScrollPane;
    private SpectralPlot samPlot;
    private JPanel selectionPanel;
    private JRadioButton selectionRadioButton;
    private JLabel threasholdLabel;
    private JSpinner threasholdSpinner;
    private JPanel treasholdPanel;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        SAMselectionPanel sAMselectionPanel = new SAMselectionPanel(null);
        sAMselectionPanel.loadFromFile();
        jFrame.getContentPane().add(sAMselectionPanel);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public SAMselectionPanel(AbstractPlotBaseWindow abstractPlotBaseWindow) {
        super(abstractPlotBaseWindow);
        this.initComponents();
        this.window = abstractPlotBaseWindow;
        this.loadFromFile();
        this.fileRadioButton.setVisible(false);
        this.selectionRadioButton.setPreferredSize(new Dimension(150, 20));
        this.referenceScrollPane.setVisible(false);
        this.threasholdSpinner.setModel(new SpinnerNumberModel(10, 1, 90, 1));
        this.doInteraction(null);
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        if (this.selectionRadioButton.isSelected()) {
            this.selectionRadioButtonItemStateChanged(null);
        } else {
            this.fileRadioButtonItemStateChanged(null);
        }
        return false;
    }

    public DenseVector getReference() {
        if (!this.referencePointList.isEmpty()) {
            return this.referencePointList.get(0).getDenseVector();
        }
        return null;
    }

    public boolean isContour2D() {
        return this.contour2DCheckBox.isSelected();
    }

    public boolean isContour3D() {
        return this.contour3DCheckBox.isSelected();
    }

    public void loadFromFile() {
        try {
            Vector<DataWrapper> vector = new Vector<DataWrapper>();
            Random random = new Random();
            for (int i = 0; i < 10; ++i) {
                float f = 0.0f;
                float[] fArray = new float[256];
                for (int j = 0; j < fArray.length; ++j) {
                    fArray[j] = f;
                    f = (float)((double)f + ((double)random.nextFloat() - 0.5));
                }
                DataWrapper dataWrapper = new DataWrapper(fArray, "Example spectra " + (i + 1));
                vector.addElement(dataWrapper);
            }
            this.referenceList.setListData(vector);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    public void prepareInteraction() {
        if (!this.referencePointList.isEmpty()) {
            Project_GUI project_GUI = this.window.getProject_GUI();
            InteractionArray interactionArray = project_GUI.getInteractionArray(1, 0);
            if (interactionArray != null && this.selectionType != 0) {
                interactionArray = interactionArray.cloneArray();
            }
            AbstractDataMatrix abstractDataMatrix = this.getMatrix();
            abstractDataMatrix.beginCalculations();
            int n = abstractDataMatrix.isModel() ? abstractDataMatrix.getK() : abstractDataMatrix.getN();
            InteractionArray interactionArray2 = project_GUI.getInteractionArray(abstractDataMatrix.getAncestor(), 1, n, 0);
            if (interactionArray == null || interactionArray.size() == 0) {
                if (this.selectionType == 2) {
                    abstractDataMatrix.endCalculations();
                    return;
                }
                interactionArray = interactionArray2;
            }
            double d = (double)((Integer)this.threasholdSpinner.getValue()).intValue() * Math.PI / 180.0;
            block0: for (int i = 0; i < n; ++i) {
                for (DataWrapper dataWrapper : this.referencePointList) {
                    if (SamAlgorithm.getSam(abstractDataMatrix, i, dataWrapper.getDenseVector()) < d) {
                        if (this.selectionType == 2) {
                            interactionArray2.set(i, i < interactionArray.size() && interactionArray.get(i));
                            continue block0;
                        }
                        interactionArray2.set(i);
                        continue block0;
                    }
                    if (this.selectionType != 1 || i >= interactionArray.size() || !interactionArray.get(i)) continue;
                    interactionArray2.set(i);
                }
            }
            abstractDataMatrix.endCalculations();
        }
    }

    public void setCreatePanel() {
        this.setPreferredSize(new Dimension(540, 380));
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "card3");
        this.treasholdPanel.setVisible(false);
        this.contour2DCheckBox.setSelected(true);
        this.selectionRadioButtonItemStateChanged(null);
    }

    @Override
    protected void doSelection(int n) {
        this.selectionType = n;
        this.window.getProject_GUI().doInteraction(this);
    }

    @Override
    protected void initPage(AbstractWindow abstractWindow) {
        this.selectionRadioButtonItemStateChanged(null);
    }

    private void fileRadioButtonItemStateChanged(ItemEvent itemEvent) {
        this.referenceList.setBackground(Color.white);
        this.referenceList.setEnabled(true);
        this.referenceListValueChanged(null);
    }

    private AbstractDataMatrix getMatrix() {
        if (this.window == null) {
            return null;
        }
        AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)this.window.getAbstractInit().getDataTreeInterface();
        Case case_ = abstractDataMatrix.getCase();
        if (case_ != null) {
            return case_.getOriginalMatrix();
        }
        if (abstractDataMatrix instanceof FoldMatrix) {
            return ((FoldMatrix)abstractDataMatrix).getReferencedMatrix();
        }
        return abstractDataMatrix;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.treasholdPanel = new JPanel();
        this.threasholdSpinner = new JSpinner();
        this.threasholdLabel = new JLabel();
        this.angleLabel = new JLabel();
        this.referencePanel = new JPanel();
        this.samPlot = new SpectralPlot();
        this.cardPanel = new JPanel();
        this.selectionPanel = new JPanel();
        this.fileRadioButton = new JRadioButton();
        this.selectionRadioButton = new JRadioButton();
        this.referenceScrollPane = new JScrollPane();
        this.referenceList = new JList();
        this.createPanel = new JPanel();
        this.contour3DCheckBox = new JCheckBox();
        this.contour2DCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.treasholdPanel.setLayout(new GridBagLayout());
        this.treasholdPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.threasholdSpinner.setMinimumSize(new Dimension(60, 20));
        this.threasholdSpinner.setPreferredSize(new Dimension(60, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.treasholdPanel.add((Component)this.threasholdSpinner, gridBagConstraints);
        this.threasholdLabel.setText("Angle threshold:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.treasholdPanel.add((Component)this.threasholdLabel, gridBagConstraints);
        this.angleLabel.setText("degrees");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.treasholdPanel.add((Component)this.angleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.treasholdPanel, gridBagConstraints);
        this.referencePanel.setLayout(new BorderLayout());
        this.referencePanel.setBorder(BorderFactory.createTitledBorder("Spectral preview"));
        this.referencePanel.add((Component)this.samPlot, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.referencePanel, gridBagConstraints);
        this.cardPanel.setLayout(new CardLayout());
        this.selectionPanel.setLayout(new GridBagLayout());
        this.selectionPanel.setBorder(BorderFactory.createTitledBorder("Select reference spectra(s)"));
        this.buttonGroup.add(this.fileRadioButton);
        this.fileRadioButton.setText("From file");
        this.fileRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.fileRadioButton.addItemListener(itemEvent -> this.fileRadioButtonItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.selectionPanel.add((Component)this.fileRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.selectionRadioButton);
        this.selectionRadioButton.setSelected(true);
        this.selectionRadioButton.setText("From selection");
        this.selectionRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.selectionRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.selectionRadioButton.addItemListener(itemEvent -> this.selectionRadioButtonItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.selectionPanel.add((Component)this.selectionRadioButton, gridBagConstraints);
        this.referenceList.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.referenceList.setEnabled(false);
        this.referenceList.addListSelectionListener(listSelectionEvent -> this.referenceListValueChanged(listSelectionEvent));
        this.referenceScrollPane.setViewportView(this.referenceList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 18, 6, 0);
        this.selectionPanel.add((Component)this.referenceScrollPane, gridBagConstraints);
        this.cardPanel.add((Component)this.selectionPanel, "card2");
        this.createPanel.setLayout(new GridBagLayout());
        this.createPanel.setBorder(BorderFactory.createTitledBorder("Create SAM as"));
        this.contour3DCheckBox.setText("Contour 3D");
        this.contour3DCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.contour3DCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 6, 6);
        this.createPanel.add((Component)this.contour3DCheckBox, gridBagConstraints);
        this.contour2DCheckBox.setText("Contour 2D");
        this.contour2DCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.contour2DCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.createPanel.add((Component)this.contour2DCheckBox, gridBagConstraints);
        this.cardPanel.add((Component)this.createPanel, "card3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.cardPanel, gridBagConstraints);
    }

    private void referenceListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.referencePointList.clear();
        int[] nArray = this.referenceList.getSelectedIndices();
        AbstractListModel abstractListModel = (AbstractListModel)this.referenceList.getModel();
        for (int n : nArray) {
            this.referencePointList.add((DataWrapper)abstractListModel.getElementAt(n));
        }
        this.samPlot.setData(this.referencePointList);
    }

    private void selectionRadioButtonItemStateChanged(ItemEvent itemEvent) {
        this.referenceList.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.referenceList.setEnabled(false);
        this.referencePointList.clear();
        DataWrapper dataWrapper = null;
        AbstractDataMatrix abstractDataMatrix = this.getMatrix();
        InteractionArray interactionArray = this.getInteractionArray(1);
        if (abstractDataMatrix == null || interactionArray == null) {
            this.samPlot.setData(this.referencePointList);
            return;
        }
        for (int i = 0; i < interactionArray.size(); ++i) {
            if (!interactionArray.get(i)) continue;
            int n = abstractDataMatrix.isModel() ? abstractDataMatrix.getN() : abstractDataMatrix.getK();
            dataWrapper = new DataWrapper(n, abstractDataMatrix.getFoldName(i));
            for (int j = 0; j < n; ++j) {
                dataWrapper.setYvalueAt(j, abstractDataMatrix.isModel() ? (float)abstractDataMatrix.getValue(j, i) : (float)abstractDataMatrix.getValue(i, j));
            }
            break;
        }
        if (dataWrapper != null) {
            this.referencePointList.add(dataWrapper);
        }
        this.samPlot.setData(this.referencePointList);
    }

    @Override
    public InteractionArray getInteractionArray(int n) {
        return this.window.getProject_GUI().getInteractionArray(n, 0);
    }

    private static class MVvector {
        private final DenseVector vector;
        private final String name;

        public MVvector(DenseVector denseVector, String string) {
            this.vector = denseVector;
            this.name = string;
        }

        public DenseVector getVector() {
            return this.vector;
        }

        public String toString() {
            return this.name;
        }
    }
}

