/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.sam;

import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.Threader;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;

public class SamAlgorithm {
    public static AbstractDataMatrix createSamMatrix(final AbstractDataMatrix abstractDataMatrix, final DenseVector denseVector) {
        final MVmatrix mVmatrix = new MVmatrix(abstractDataMatrix.getN(), 1);
        mVmatrix.beginCalculations();
        mVmatrix.setFoldN(abstractDataMatrix.getFoldN());
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n, int n2) {
                for (int i = n; i < n2; ++i) {
                    mVmatrix.setValue(i, 0, SamAlgorithm.getSam(abstractDataMatrix, i, denseVector));
                }
            }
        };
        threader.execute(abstractDataMatrix.getN());
        mVmatrix.endCalculations();
        return mVmatrix;
    }

    public static double getSam(AbstractDataMatrix abstractDataMatrix, int n, DenseVector denseVector) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = abstractDataMatrix.isModel();
        for (int i = 0; i < denseVector.size(); ++i) {
            double d4 = denseVector.get(i);
            double d5 = bl ? abstractDataMatrix.getValue(i, n) : abstractDataMatrix.getValue(n, i);
            d += d4 * d5;
            d2 += d4 * d4;
            d3 += d5 * d5;
        }
        return Math.acos(d / Math.sqrt(d2 * d3));
    }

    private SamAlgorithm() {
    }
}

