/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.template;

import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.script.AbstractImportScriptInfo;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ImagePredictionScriptInfo
extends AbstractImportScriptInfo {
    private AbstractModel model = null;

    @Override
    public int getDefaultIndex() {
        return 2;
    }

    @Override
    public String getScript() {
        StringBuilder stringBuilder = new StringBuilder("prediction = calibrationmodel.createPrediction(dataset);");
        if (this.model.getModelName().equals("PLS-DA") || this.model.getModelName().equals("SIMCA")) {
            if (this.model.isConcentration()) {
                stringBuilder.append("ypred = prediction.get(\"ypred\");");
                stringBuilder.append("plot = createPlot(\"Single Ypred 2D Images (Concentration)\", ypred);");
            } else {
                stringBuilder.append("xtr = dataset.get(\"xtraining\");");
                stringBuilder.append("plot = createPlot(\"contour2D\", xtr, {\"fold=true\"});");
                stringBuilder.append("plot.setTitle(\"Predicted data ($case)\");");
            }
        } else if (this.model.getModelName().equals("PLS")) {
            stringBuilder.append("ypred = prediction.get(\"Ypred\");");
            stringBuilder.append("plot = createPlot(\"contour2D\", ypred.getLastSubMatrix(), {\"fold=true\"});");
            stringBuilder.append("plot.addLegend(\"color\");");
            stringBuilder.append("plot.setTitle(\"Contour 2D - PLS prediction (Ypred)\");");
        }
        if (this.model.getModelName().equals("SIMCA") || this.model.getModelName().equals("PLS-DA")) {
            if (this.model.isConcentration()) {
                stringBuilder.append("createTable(\"quantificationtable\", prediction);");
            } else {
                stringBuilder.append("plot.setColor(\"prediction category\", \"Pred. ").append(this.model.toString()).append("\");");
                stringBuilder.append("plot.addLegend(\"color\");");
                stringBuilder.append("createTable(\"predictiontable\", prediction);");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getScriptInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Use this template to create a prediction from an ");
        stringBuilder.append(this.model.getModelName());
        stringBuilder.append(" image model.");
        stringBuilder.append("\nReplace missing values with median is default");
        return stringBuilder.toString();
    }

    @Override
    public String getSubType() {
        return null;
    }

    @Override
    public String getType() {
        return "prediction";
    }

    @Override
    public boolean isReplaceMissingWithMedian() {
        return true;
    }

    @Override
    public boolean supportObject(Object object) {
        Object object2;
        Object[] objectArray;
        if (object instanceof CellIdentifierModel) {
            CellIdentifierModel cellIdentifierModel = (CellIdentifierModel)object;
            this.model = cellIdentifierModel.getCalibrationModel();
            return cellIdentifierModel.isMultiLayer();
        }
        if (object instanceof AbstractModel) {
            this.model = (AbstractModel)object;
            return this.model.isUnfolded();
        }
        if (object instanceof Object[] && (objectArray = (Object[])object).length == 2 && (object2 = objectArray[0]) instanceof DataSet) {
            DataSet dataSet = (DataSet)object2;
            if (objectArray[1] instanceof AbstractModel) {
                this.model = (AbstractModel)objectArray[1];
                return dataSet.isMultiLayer();
            }
        }
        return false;
    }

    public String toString() {
        return "Standard Image Prediction";
    }
}

