/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.help.HelpSet;
import se.prediktera.map.PropertiesHelper;
import se.prediktera.map.common.AbstractPanelInfo;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.data.MatrixOperationInfo;
import se.prediktera.map.data.datasettable.DataSetTableInfo;
import se.prediktera.map.data.datasettable.NewDataSetTableInfo;
import se.prediktera.map.data.modeltable.ModelTableInfo;
import se.prediktera.map.data.quicktable.QuickTableInfo;
import se.prediktera.map.data.tablegenerator.AbstractTableInfo;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.dataexport.ExportCSV;
import se.prediktera.map.dataexport.ExportHTML;
import se.prediktera.map.dataexport.ExportHdf;
import se.prediktera.map.dataexport.ExportRaw;
import se.prediktera.map.dataexport.ExportXLS;
import se.prediktera.map.dataexport.matlab.ExportMAT;
import se.prediktera.map.dataexport.matlab.ExportMATRaw;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.arff.ArffImportInfo;
import se.prediktera.map.dataimport.jdf.JdfImportInfo;
import se.prediktera.map.dataimport.map.MapImportInfo;
import se.prediktera.map.dataimport.mat.HdfImportInfo;
import se.prediktera.map.dataimport.mat.MatImportInfo;
import se.prediktera.map.dataimport.raw.RawImportInfo;
import se.prediktera.map.dataimport.spc.SpcImportInfo;
import se.prediktera.map.dataimport.xls.XlsImportInfo;
import se.prediktera.map.datasetcontainer.dataset.selection.AbstractSelectionInfo;
import se.prediktera.map.datasetcontainer.dataset.selection.EvenlySpreadAlgorithm;
import se.prediktera.map.datasetcontainer.dataset.selection.RepresentativeAlgorithm;
import se.prediktera.map.datasetcontainer.transform.AbstractTransformInfo;
import se.prediktera.map.datasetcontainer.transform.baseline.BaseLineCorrectionInfo;
import se.prediktera.map.datasetcontainer.transform.category.CategoryAnalysisInfo;
import se.prediktera.map.datasetcontainer.transform.category.CategoryInfo;
import se.prediktera.map.datasetcontainer.transform.category.EqualSizeAnalysisInfo;
import se.prediktera.map.datasetcontainer.transform.center.TCenterInfo;
import se.prediktera.map.datasetcontainer.transform.cr.ContinuumRemovalInfo;
import se.prediktera.map.datasetcontainer.transform.derivative.DerivativeInfo;
import se.prediktera.map.datasetcontainer.transform.function.FunctionInfo;
import se.prediktera.map.datasetcontainer.transform.interactionterm.InteractionTermInfo;
import se.prediktera.map.datasetcontainer.transform.logarithm.LogarithmInfo;
import se.prediktera.map.datasetcontainer.transform.msc.MscInfo;
import se.prediktera.map.datasetcontainer.transform.pareto.ParetoInfo;
import se.prediktera.map.datasetcontainer.transform.quadterm.QuadTermInfo;
import se.prediktera.map.datasetcontainer.transform.reduce.ReduceInfo;
import se.prediktera.map.datasetcontainer.transform.savitzky.SavitzkyInfo;
import se.prediktera.map.datasetcontainer.transform.snv.SnvInfo;
import se.prediktera.map.datasetcontainer.transform.uvscale.TUVScaleInfo;
import se.prediktera.map.datasetcontainer.transform.value.AddedValueAnalysisInfo;
import se.prediktera.map.datasetcontainer.transform.value.ObservationAddedValueInfo;
import se.prediktera.map.datasetcontainer.transform.value.VariablesAddedValueInfo;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.extclass.ExtLibException;
import se.prediktera.map.main.extclass.InitInterface;
import se.prediktera.map.main.script.gui.template.AbstractScriptTemplateInfo;
import se.prediktera.map.main.script.gui.template.BatchScriptTemplateInfo;
import se.prediktera.map.main.script.gui.template.ImportScriptTemplateInfo;
import se.prediktera.map.main.script.gui.template.PlotScriptTemplateInfo;
import se.prediktera.map.main.script.gui.template.TableScriptTemplateInfo;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.model.analysis.CompareAnalysisInfo;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2DInfo;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.QuickSpectralInfo;
import se.prediktera.map.plot.axisplot.plot2D.radar.design.Design2DInfo;
import se.prediktera.map.plot.axisplot.plot2D.scatter.DensityScatter2DInfo;
import se.prediktera.map.plot.axisplot.plot2D.scatter.Scatter2DInfo;
import se.prediktera.map.plot.axisplot.plot2D.scatter.intensity.IntensityAnalysisInfo;
import se.prediktera.map.plot.axisplot.plot2D.scatter.intensity.IntensityPanelInfo;
import se.prediktera.map.plot.axisplot.plot2D.scatter.nnearest.NnearestPanelInfo;
import se.prediktera.map.plot.axisplot.plot2D.scatter.statistic.HistogramStatisticsInfo;
import se.prediktera.map.plot.axisplot.plot2D.scatter.statistic.LimitsScatter2DStatisticsInfo;
import se.prediktera.map.plot.axisplot.plot2D.scatter.statistic.RegressionStatisticsInfo;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.DendogramInfo;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.Histogram2DInfo;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.bucket.BucketAnalysisInfo;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.bucket2D.Bucket2DAnalysisInfo;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.Serie2DInfo;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.Serie2DStackedInfo;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.box.Box2DInfo;
import se.prediktera.map.plot.axisplot.plot2D.serie.statistic.LimitsSerieStatisticInfo;
import se.prediktera.map.plot.axisplot.plot2D.spectral.SpectralInfo;
import se.prediktera.map.plot.axisplot.plot2D.spectral.SpectralStackedInfo;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.Contour3DInfo;
import se.prediktera.map.plot.axisplot.plot3D.cube3D.Cube3DInfo;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.DensityScatter3DInfo;
import se.prediktera.map.plot.axisplot.plot3D.scatter3D.Scatter3DInfo;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;
import se.prediktera.map.plot.axisplot.settings.Statistics.ConfidenceIntervalInfo;
import se.prediktera.map.plot.axisplot.windows.ImageDescInfo;
import se.prediktera.map.plot.layout.AbstractDescInfo;
import se.prediktera.map.plot.plotgenerator.AbstractPlotInfo;

public class InitClass
implements InitInterface {
    private static UpdateHelper.UpdateVersion EvinceVersion;
    public static final Integer Version;
    public static final int majorVersionStart = 177;
    public static String VersionString;
    public static final Integer OldestPlotVersion;
    private static String Build;
    private static boolean Internal;
    private static Date Timestamp;
    private static boolean IsReleaseVersion;
    public static final int DATAIMPORT = 0;
    public static final int DATASET = 1;
    public static final int CENTER = 2;
    public static final int UVSCALE = 3;
    public static final int COMPOSITE = 5;
    public static final int MERGE = 6;
    public static final int REALTIME = 7;
    private static final String[][] versiondates;
    public static final int TESTDISTRIBUTION = 99;

    public static String getBuild() {
        return Build;
    }

    public static boolean isInternal() {
        return Internal;
    }

    public static Date getTimestamp() {
        return Timestamp;
    }

    public static boolean isReleaseVersion() {
        return IsReleaseVersion;
    }

    public static Date getLastVersionDate() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            return simpleDateFormat.parse(versiondates[0][1]);
        }
        catch (ParseException parseException) {
            ErrorHandler.logAndReportException(parseException);
            return null;
        }
    }

    public static String getNextVersionString() {
        return InitClass.getEvinceVersion().toString();
    }

    public static String GetVersionString() {
        return InitClass.getEvinceVersion().toString();
    }

    public static UpdateHelper.UpdateVersion getEvinceVersion() {
        if (EvinceVersion == null) {
            Properties properties = PropertiesHelper.loadProperties(InitClass.class, "evince.properties");
            if (properties != null) {
                EvinceVersion = new UpdateHelper.UpdateVersion(properties.getProperty("evince_version"));
            } else {
                return new UpdateHelper.UpdateVersion("0.0.0");
            }
        }
        return EvinceVersion;
    }

    @Override
    public DataTreeExtLibInterface createExtLibNodeFromStream(Byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException, ExtLibException {
        return null;
    }

    public AbstractAnalysisInfo[] getAnalysisInfo() {
        return new AbstractAnalysisInfo[]{new EqualSizeAnalysisInfo(), new BucketAnalysisInfo(), new Bucket2DAnalysisInfo(), new CategoryAnalysisInfo(), new AddedValueAnalysisInfo(), new MatrixOperationInfo(), new IntensityAnalysisInfo(), new CompareAnalysisInfo()};
    }

    public AbstractDescInfo[] getDescInfo() {
        return new AbstractDescInfo[]{new ImageDescInfo()};
    }

    public AbstractExportInfo[] getExportInfo() {
        return new AbstractExportInfo[]{new ExportRaw(), new ExportCSV(), new ExportXLS(), new ExportHTML(), new ExportHdf(), new ExportMAT(), new ExportMATRaw()};
    }

    public HelpSet getHelpSet() {
        return null;
    }

    @Override
    public AbstractInfo[] getInfo(Byte by) {
        return switch (by) {
            case 1 -> this.getPlotInfo();
            case 0 -> this.getTableInfo();
            case 2 -> this.getModelInfo();
            case 3 -> this.getImportInfo();
            case 6 -> this.getExportInfo();
            case 7 -> this.getTransformInfo();
            case 11 -> this.getStatisticsInfo();
            case 15 -> this.getPanelInfo();
            case 17 -> this.getScriptTemplateInfo();
            case 16 -> this.getAnalysisInfo();
            case 10 -> this.getDescInfo();
            case 19 -> this.getScriptSelectionInfo();
            default -> null;
        };
    }

    @Override
    public String getName() {
        return "Evince";
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.EVINCE;
    }

    public AbstractStatisticsInfo[] getStatisticsInfo() {
        return new AbstractStatisticsInfo[]{new ConfidenceIntervalInfo(), new RegressionStatisticsInfo(), new LimitsScatter2DStatisticsInfo(), new LimitsSerieStatisticInfo(), new HistogramStatisticsInfo()};
    }

    public AbstractTransformInfo[] getTransformInfo() {
        return new AbstractTransformInfo[]{new CategoryInfo(), new ObservationAddedValueInfo(), new VariablesAddedValueInfo(), new TCenterInfo(), new TUVScaleInfo(), new ParetoInfo(), new QuadTermInfo(), new InteractionTermInfo(), new FunctionInfo(), new LogarithmInfo(), new ReduceInfo(), new MscInfo(), new DerivativeInfo(), new SavitzkyInfo(), new SnvInfo(), new BaseLineCorrectionInfo(), new ContinuumRemovalInfo()};
    }

    @Override
    public Integer getVersion() {
        return Version;
    }

    @Override
    public String getVersionString() {
        return InitClass.getEvinceVersion().toString();
    }

    @Override
    public void Init() {
    }

    public String toString() {
        return "EVINCE";
    }

    private AbstractImportInfo[] getImportInfo() {
        return new AbstractImportInfo[]{new RawImportInfo(), new XlsImportInfo(), new MatImportInfo(), new HdfImportInfo(), new JdfImportInfo(), new SpcImportInfo(), new MapImportInfo(), new ArffImportInfo()};
    }

    private AbstractModelInfo[] getModelInfo() {
        return new AbstractModelInfo[0];
    }

    private AbstractPanelInfo[] getPanelInfo() {
        return new AbstractPanelInfo[]{new NnearestPanelInfo(), new IntensityPanelInfo()};
    }

    private AbstractPlotInfo[] getPlotInfo() {
        return new AbstractPlotInfo[]{new Scatter2DInfo(), new DensityScatter2DInfo(), new Scatter3DInfo(), new Cube3DInfo(), new DensityScatter3DInfo(), new Histogram2DInfo(), new DendogramInfo(), new Serie2DInfo(), new Serie2DStackedInfo(), new SpectralInfo(), new SpectralStackedInfo(), new Contour2DInfo(), new Contour3DInfo(), new Design2DInfo(), new QuickSpectralInfo(), new Box2DInfo()};
    }

    private AbstractSelectionInfo[] getScriptSelectionInfo() {
        return new AbstractSelectionInfo[]{new RepresentativeAlgorithm(), new EvenlySpreadAlgorithm()};
    }

    private AbstractScriptTemplateInfo[] getScriptTemplateInfo() {
        return new AbstractScriptTemplateInfo[]{new ImportScriptTemplateInfo(), new BatchScriptTemplateInfo(), new PlotScriptTemplateInfo(), new TableScriptTemplateInfo()};
    }

    private AbstractTableInfo[] getTableInfo() {
        AbstractTableInfo[] abstractTableInfoArray = new AbstractTableInfo[5];
        abstractTableInfoArray[0] = new QuickTableInfo();
        abstractTableInfoArray[1] = new DataSetTableInfo();
        abstractTableInfoArray[2] = new NewDataSetTableInfo();
        abstractTableInfoArray[4] = new ModelTableInfo();
        return abstractTableInfoArray;
    }

    static {
        Version = 183;
        VersionString = "2.7";
        OldestPlotVersion = 65;
        Build = "development";
        Internal = false;
        Timestamp = null;
        IsReleaseVersion = false;
        Properties properties = PropertiesHelper.loadProperties(InitClass.class, "build.properties");
        if (properties != null) {
            try {
                Build = properties.getProperty("build", "0");
                Internal = Boolean.parseBoolean(properties.getProperty("internal", "false"));
                String string = properties.getProperty("timestamp", null);
                if (string != null) {
                    Timestamp = new SimpleDateFormat("yyyyMMddHHmmss").parse(string);
                }
            }
            catch (Exception exception) {
                Logg.error("Cannot parse build.properties", exception);
            }
            IsReleaseVersion = true;
        }
        versiondates = new String[][]{{"2.6.0", "2013/03/27"}, {"2.5.0", "2010/10/08"}, {"2.4.0", "2010/04/16"}};
    }
}

