/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.com.bitmap;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.FileInputStream;
import java.io.IOException;

public class BmpDecoder {
    public static double constructDouble(byte[] byArray, int n) {
        long l = BmpDecoder.constructLong(byArray, n);
        return Double.longBitsToDouble(l);
    }

    public static int constructInt(byte[] byArray, int n) {
        int n2 = byArray[n + 3] & 0xFF;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    public static int constructInt3(byte[] byArray, int n) {
        int n2 = 255;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    public static long constructLong(byte[] byArray, int n) {
        long l = (long)byArray[n + 7] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 6] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 5] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 4] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 3] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 2] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 1] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 0] & 0xFFL;
        return l;
    }

    public static short constructShort(byte[] byArray, int n) {
        short s = (short)(byArray[n + 1] & 0xFF);
        s = (short)(s << 8 | (short)(byArray[n + 0] & 0xFF));
        return s;
    }

    public static Image read(FileInputStream fileInputStream) {
        try {
            BitmapHeader bitmapHeader = new BitmapHeader();
            bitmapHeader.read(fileInputStream);
            if (bitmapHeader.nbitcount == 24) {
                return BmpDecoder.readMap24(fileInputStream, bitmapHeader);
            }
            if (bitmapHeader.nbitcount == 32) {
                return BmpDecoder.readMap32(fileInputStream, bitmapHeader);
            }
            if (bitmapHeader.nbitcount == 8) {
                return BmpDecoder.readMap8(fileInputStream, bitmapHeader);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected static Image readMap24(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
        int n = bitmapHeader.nsizeimage / bitmapHeader.nheight - bitmapHeader.nwidth * 3;
        int[] nArray = new int[bitmapHeader.nheight * bitmapHeader.nwidth];
        byte[] byArray = new byte[(bitmapHeader.nwidth + n) * 3 * bitmapHeader.nheight];
        fileInputStream.read(byArray, 0, (bitmapHeader.nwidth + n) * 3 * bitmapHeader.nheight);
        int n2 = 0;
        for (int i = 0; i < bitmapHeader.nheight; ++i) {
            for (int j = 0; j < bitmapHeader.nwidth; ++j) {
                nArray[bitmapHeader.nwidth * (bitmapHeader.nheight - i - 1) + j] = BmpDecoder.constructInt3(byArray, n2);
                n2 += 3;
            }
            n2 += n;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.nwidth, bitmapHeader.nheight, nArray, 0, bitmapHeader.nwidth));
        fileInputStream.close();
        return image;
    }

    protected static Image readMap32(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
        int[] nArray = new int[bitmapHeader.nheight * bitmapHeader.nwidth];
        byte[] byArray = new byte[bitmapHeader.nwidth * 4 * bitmapHeader.nheight];
        fileInputStream.read(byArray, 0, bitmapHeader.nwidth * 4 * bitmapHeader.nheight);
        int n = 0;
        for (int i = 0; i < bitmapHeader.nheight; ++i) {
            for (int j = 0; j < bitmapHeader.nwidth; ++j) {
                nArray[bitmapHeader.nwidth * (bitmapHeader.nheight - i - 1) + j] = BmpDecoder.constructInt3(byArray, n);
                n += 4;
            }
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.nwidth, bitmapHeader.nheight, nArray, 0, bitmapHeader.nwidth));
        fileInputStream.close();
        return image;
    }

    protected static Image readMap8(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
        int n;
        int n2 = 0;
        n2 = bitmapHeader.nclrused > 0 ? bitmapHeader.nclrused : 1 << bitmapHeader.nbitcount;
        if (bitmapHeader.nsizeimage == 0) {
            bitmapHeader.nsizeimage = (bitmapHeader.nwidth * bitmapHeader.nbitcount + 31 & 0xFFFFFFE0) >> 3;
            bitmapHeader.nsizeimage *= bitmapHeader.nheight;
        }
        int[] nArray = new int[n2];
        byte[] byArray = new byte[n2 * 4];
        fileInputStream.read(byArray, 0, n2 * 4);
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            nArray[n] = BmpDecoder.constructInt3(byArray, n3);
            n3 += 4;
        }
        n = bitmapHeader.nsizeimage / bitmapHeader.nheight - bitmapHeader.nwidth;
        int[] nArray2 = new int[bitmapHeader.nwidth * bitmapHeader.nheight];
        byte[] byArray2 = new byte[(bitmapHeader.nwidth + n) * bitmapHeader.nheight];
        fileInputStream.read(byArray2, 0, (bitmapHeader.nwidth + n) * bitmapHeader.nheight);
        n3 = 0;
        for (int i = 0; i < bitmapHeader.nheight; ++i) {
            for (int j = 0; j < bitmapHeader.nwidth; ++j) {
                nArray2[bitmapHeader.nwidth * (bitmapHeader.nheight - i - 1) + j] = nArray[byArray2[n3] & 0xFF];
                ++n3;
            }
            n3 += n;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.nwidth, bitmapHeader.nheight, nArray2, 0, bitmapHeader.nwidth));
        return image;
    }

    static class BitmapHeader {
        public int nsize;
        public int nbisize;
        public int nwidth;
        public int nheight;
        public int nplanes;
        public int nbitcount;
        public int ncompression;
        public int nsizeimage;
        public int nxpm;
        public int nypm;
        public int nclrused;
        public int nclrimp;

        BitmapHeader() {
        }

        public void read(FileInputStream fileInputStream) throws IOException {
            byte[] byArray = new byte[14];
            fileInputStream.read(byArray, 0, 14);
            byte[] byArray2 = new byte[40];
            fileInputStream.read(byArray2, 0, 40);
            this.nsize = BmpDecoder.constructInt(byArray, 2);
            this.nbisize = BmpDecoder.constructInt(byArray2, 2);
            this.nwidth = BmpDecoder.constructInt(byArray2, 4);
            this.nheight = BmpDecoder.constructInt(byArray2, 8);
            this.nplanes = BmpDecoder.constructShort(byArray2, 12);
            this.nbitcount = BmpDecoder.constructShort(byArray2, 14);
            this.ncompression = BmpDecoder.constructInt(byArray2, 16);
            this.nsizeimage = BmpDecoder.constructInt(byArray2, 20);
            this.nxpm = BmpDecoder.constructInt(byArray2, 24);
            this.nypm = BmpDecoder.constructInt(byArray2, 28);
            this.nclrused = BmpDecoder.constructInt(byArray2, 32);
            this.nclrimp = BmpDecoder.constructInt(byArray2, 36);
        }
    }
}

