/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.com.bitmap;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import se.prediktera.map.common.error.ErrorHandler;

public class BmpEncoder
extends Component {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private final byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private final int bfReserved1 = 0;
    private final int bfReserved2 = 0;
    private final int bfOffBits = 54;
    private final int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private final int biPlanes = 1;
    private final int biBitCount = 24;
    private final int biCompression = 0;
    private int biSizeImage = 196608;
    private final int biXPelsPerMeter = 0;
    private final int biYPelsPerMeter = 0;
    private final int biClrUsed = 0;
    private final int biClrImportant = 0;
    private int[] bitmap;
    private FileOutputStream fo;

    public void saveBitmap(File file, Image image, int n, int n2) throws Exception {
        this.fo = new FileOutputStream(file);
        this.save(image, n, n2);
        this.fo.close();
    }

    private boolean convertImage(Image image, int n, int n2) {
        this.bitmap = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, this.bitmap, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            ErrorHandler.logAndReportException(interruptedException);
            return false;
        }
        int n3 = (4 - n * 3 % 4) * n2;
        this.biSizeImage = n * n2 * 3 + n3;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = n;
        this.biHeight = n2;
        return true;
    }

    private byte[] intToDWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    private byte[] intToWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return byArray;
    }

    private void save(Image image, int n, int n2) {
        try {
            this.convertImage(image, n, n2);
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void writeBitmap() {
        int n;
        byte[] byArray = new byte[3];
        int n2 = this.biWidth * this.biHeight - 1;
        int n3 = 4 - this.biWidth * 3 % 4;
        if (n3 == 4) {
            n3 = 0;
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = n = n2 - this.biWidth;
        try {
            for (int i = 0; i < n2; ++i) {
                int n7 = this.bitmap[n];
                byArray[0] = (byte)(n7 & 0xFF);
                byArray[1] = (byte)(n7 >> 8 & 0xFF);
                byArray[2] = (byte)(n7 >> 16 & 0xFF);
                this.fo.write(byArray);
                if (n4 == this.biWidth) {
                    n5 += n3;
                    for (int j = 1; j <= n3; ++j) {
                        this.fo.write(0);
                    }
                    n4 = 1;
                    n6 = n = n6 - this.biWidth;
                } else {
                    ++n4;
                }
                ++n;
            }
            this.bfSize += n5 - n3;
            this.biSizeImage += n5 - n3;
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void writeBitmapFileHeader() {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize));
            this.fo.write(this.intToWord(0));
            this.fo.write(this.intToWord(0));
            this.fo.write(this.intToDWord(54));
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void writeBitmapInfoHeader() {
        try {
            this.fo.write(this.intToDWord(40));
            this.fo.write(this.intToDWord(this.biWidth));
            this.fo.write(this.intToDWord(this.biHeight));
            this.fo.write(this.intToWord(1));
            this.fo.write(this.intToWord(24));
            this.fo.write(this.intToDWord(0));
            this.fo.write(this.intToDWord(this.biSizeImage));
            this.fo.write(this.intToDWord(0));
            this.fo.write(this.intToDWord(0));
            this.fo.write(this.intToDWord(0));
            this.fo.write(this.intToDWord(0));
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }
}

