/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.com.gif;

import java.io.IOException;
import java.io.OutputStream;

class BitFile {
    private final OutputStream output_;
    private final byte[] buffer_;
    private int index_;
    private int bitsLeft_;

    public BitFile(OutputStream outputStream) {
        this.output_ = outputStream;
        this.buffer_ = new byte[256];
        this.index_ = 0;
        this.bitsLeft_ = 8;
    }

    public void Flush() throws IOException {
        int n = this.index_ + (this.bitsLeft_ == 8 ? 0 : 1);
        if (n > 0) {
            this.output_.write(n);
            this.output_.write(this.buffer_, 0, n);
            this.buffer_[0] = 0;
            this.index_ = 0;
            this.bitsLeft_ = 8;
        }
    }

    public void WriteBits(int n, int n2) throws IOException {
        do {
            if (this.index_ == 254 && this.bitsLeft_ == 0 || this.index_ > 254) {
                this.output_.write(255);
                this.output_.write(this.buffer_, 0, 255);
                this.buffer_[0] = 0;
                this.index_ = 0;
                this.bitsLeft_ = 8;
            }
            if (n2 <= this.bitsLeft_) {
                int n3 = this.index_;
                this.buffer_[n3] = (byte)(this.buffer_[n3] | (n & (1 << n2) - 1) << 8 - this.bitsLeft_);
                this.bitsLeft_ -= n2;
                n2 = 0;
                continue;
            }
            int n4 = this.index_++;
            this.buffer_[n4] = (byte)(this.buffer_[n4] | (n & (1 << this.bitsLeft_) - 1) << 8 - this.bitsLeft_);
            n >>= this.bitsLeft_;
            n2 -= this.bitsLeft_;
            this.buffer_[this.index_] = 0;
            this.bitsLeft_ = 8;
        } while (n2 != 0);
    }
}

