/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.progress.ProgressManager;

public abstract class AbstractRandomStream
extends CleanUpClass
implements Serializable {
    public static final byte RANDOM = 0;
    public static final byte STREAM = 1;
    public static final byte ROOT = 0;
    public static final byte DATATREE = 1;
    public static final byte DESCRIPTION = 2;
    public static final byte DATABASEID = 3;
    public static final byte SAVEVERSION = 4;
    public static final byte IMAGE = 5;
    public static final byte COMPRESSION = 7;
    public static final byte CLASSESSETTINGS = 8;
    public static final byte CML = 9;
    public static final byte ENDPROPERTIES = -1;
    public static final byte BOOLEAN = 0;
    public static final byte INT = 1;
    public static final byte LONG = 2;
    public static final byte DOUBLE = 3;
    public static final byte UTF = 4;
    public static final byte BYTE = 5;
    public static final byte BOOLEANARRAY = 6;
    public static final byte INTARRAY = 7;
    public static final byte LONGARRAY = 8;
    public static final byte DOUBLEARRAY = 9;
    public static final byte BYTEARRAY = 10;
    public static final byte BLOCK = 11;
    public static final byte FLOAT = 12;
    public static final byte BOOLEANARRAY2D = 13;
    public static final byte DOUBLEARRAY2D = 14;
    public static final byte PROPERTIES = 15;
    public static final byte UTFARRAY = 16;
    public static final byte INTARRAY2D = 17;
    public static final byte FLOATARRAY = 18;
    protected final int BUFFSIZE = 4096;
    protected final int BUFFSIZE_HALF = 2048;
    protected final byte[] versionName = new byte[]{77, 65, 80};
    protected File file;
    protected long[][] indexTable = new long[10][2];
    protected int MAPversion;
    protected ProgressManager pmanager;
    protected RandomAccessFile randomAccessFile;
    protected byte accesstype;

    public static void CopyFile(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public AbstractRandomStream(File file, String string, ProgressManager progressManager) throws IOException {
        super("AbstractRandomStream");
        this.randomAccessFile = new RandomAccessFile(file, string);
        this.file = file;
        this.pmanager = progressManager;
        this.accesstype = 0;
    }

    public AbstractRandomStream(ProgressManager progressManager) throws IOException {
        super("AbstractRandomStream");
        this.pmanager = progressManager;
        this.accesstype = 1;
    }

    public AbstractRandomStream(String string, String string2, ProgressManager progressManager) throws IOException {
        this(new File(string), string2, progressManager);
    }

    public abstract void close() throws IOException;

    public final boolean eof() throws IOException {
        return this.getFilePointer() >= this.length();
    }

    public int getDatabaseID() {
        return (int)this.indexTable[3][0];
    }

    public long getEndIndex(byte by) {
        return this.indexTable[by][1];
    }

    public File getFile() {
        return this.file;
    }

    public final long getFilePointer() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.getFilePointer();
            default -> 0L;
        };
    }

    public int getMAPversion() {
        return this.MAPversion;
    }

    public ProgressManager getProgressManager() {
        return this.pmanager;
    }

    public int getRootID() {
        return (int)this.indexTable[0][0];
    }

    public long getSaveVersion() {
        return this.indexTable[4][0];
    }

    public long getStartIndex(byte by) {
        return this.indexTable[by][0];
    }

    public void goToIndex(byte by) throws IOException {
        this.seek(this.indexTable[by][0]);
    }

    public boolean isRandom() {
        return this.accesstype == 0;
    }

    public final long length() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.length();
            default -> 0L;
        };
    }

    public void seek(long l) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.seek(l);
            }
        }
    }

    public void setDatabaseID(int n) {
        this.indexTable[3][0] = n;
    }

    public void setProgressManager(ProgressManager progressManager) {
        this.pmanager = progressManager;
    }

    public void setRootID(int n) {
        this.indexTable[0][0] = n;
    }

    public int sizeof(boolean bl) {
        return 1;
    }

    public int sizeof(byte by) {
        return 1;
    }

    public int sizeof(char c) {
        return 2;
    }

    public int sizeof(double d) {
        return 8;
    }

    public int sizeof(float f) {
        return 4;
    }

    public int sizeof(int n) {
        return 4;
    }

    public int sizeof(long l) {
        return 8;
    }

    public int sizeof(short s) {
        return 2;
    }

    public int SizeOf(byte by) {
        return switch (by) {
            case 0 -> 1;
            default -> -1;
        };
    }

    public void skip(int n) throws IOException {
        if (this.accesstype == 0) {
            this.randomAccessFile.skipBytes(n);
        }
    }

    public boolean useCompression() {
        return this.indexTable[7][0] != 0L;
    }

    public void useCompression(boolean bl) {
        this.indexTable[7][0] = bl ? 1L : 0L;
    }

    protected boolean isDatabase() {
        return this.getDatabaseID() > 0;
    }
}

