/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

public class BooleanArray {
    protected boolean[] array;
    private int firstSet;
    private int lastSet;

    public BooleanArray(boolean[] blArray) {
        int n;
        this.array = blArray;
        this.firstSet = blArray.length;
        this.lastSet = -1;
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            this.firstSet = n;
            break;
        }
        for (n = blArray.length - 1; n >= 0; --n) {
            if (!blArray[n]) continue;
            this.lastSet = n;
            break;
        }
    }

    public BooleanArray(int n) {
        this.array = new boolean[n];
        this.firstSet = this.array.length;
        this.lastSet = -1;
    }

    public BooleanArray cloneArray() {
        return new BooleanArray((boolean[])this.array.clone());
    }

    public final boolean get(int n) {
        return n >= this.firstSet && n <= this.lastSet && this.array[n];
    }

    public int getFirstSet() {
        return this.firstSet;
    }

    public boolean[] getInternalArray() {
        return this.array;
    }

    public int getLastSet() {
        return this.lastSet;
    }

    public int getSetCount() {
        int n = 0;
        for (int i = this.firstSet; i <= this.lastSet; ++i) {
            if (!this.array[i]) continue;
            ++n;
        }
        return n;
    }

    public boolean hasSelection() {
        for (int i = this.firstSet; i <= this.lastSet; ++i) {
            if (!this.array[i]) continue;
            return true;
        }
        return false;
    }

    public final void reset() {
        for (int i = this.firstSet; i <= this.lastSet; ++i) {
            this.array[i] = false;
        }
        this.firstSet = this.array.length;
        this.lastSet = -1;
    }

    public final void set(int n) {
        if (n >= 0 && n < this.array.length) {
            if (n < this.firstSet) {
                this.firstSet = n;
            }
            if (n > this.lastSet) {
                this.lastSet = n;
            }
            this.array[n] = true;
        }
    }

    public final void set(int n, boolean bl) {
        if (n >= 0 && n < this.array.length) {
            if (bl) {
                if (n < this.firstSet) {
                    this.firstSet = n;
                }
                if (n > this.lastSet) {
                    this.lastSet = n;
                }
            }
            this.array[n] = bl;
        }
    }

    public int size() {
        return this.array.length;
    }
}

