/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.IniManager;

public class BrowserLauncher {
    public static void openPredikteraWebSite() {
        BrowserLauncher.open(IniManager.getWebSite());
    }

    public static void open(File file) {
        BrowserLauncher.open(file.toURI());
    }

    public static void open(String string) {
        try {
            BrowserLauncher.open(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public static void open(URI uRI) {
        try {
            Desktop desktop = Desktop.getDesktop();
            if (Desktop.isDesktopSupported() && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(uRI);
            } else {
                ProcessBuilder processBuilder = new ProcessBuilder(BrowserLauncher.getCommand(uRI.toString()));
                processBuilder.start();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static List<String> getCommand(String string) throws IOException {
        UpdateHelper.Platform platform = UpdateHelper.getPlatform();
        return switch (platform) {
            default -> throw new MatchException(null, null);
            case UpdateHelper.Platform.Linux, UpdateHelper.Platform.LinuxArm, UpdateHelper.Platform.Unknown -> List.of("xdg-open", string);
            case UpdateHelper.Platform.MacOSX -> List.of("open", string);
            case UpdateHelper.Platform.Windows -> List.of("rundll32", "url.dll,FileProtocolHandler", string);
        };
    }
}

