/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.ReportDialog;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.register.RegisterKeyManager;

public class ErrorDialog
extends ReportDialog {
    private static final Logger logger = LoggerFactory.getLogger(ErrorDialog.class);
    public static boolean filterall = false;
    private static Throwable lastError = null;
    private static long lastErrorTime = 0L;
    private final Vector<String> errorLog;
    private String anonymousScript = null;
    private final JPanel infoPanel = new JPanel(new GridBagLayout());
    private boolean showerrorpanel = false;
    private final JButton detailsButton = new JButton("Details");
    private final JLabel infoLabel = new JLabel();

    public static void main(String[] stringArray) throws Exception {
        Evince.initNoShow();
        RegisterKeyManager registerKeyManager = new RegisterKeyManager(UpdateHelper.Product.Evince);
        registerKeyManager.parseRegAndVerifyInfoFile();
        ExtClassLoader.findExtendedLibrariesByClassDir();
        for (int i = 0; i < 2; ++i) {
            try {
                ErrorDialog.nullPointerException();
                continue;
            }
            catch (Exception exception) {
                ErrorDialog.showErrorDialog(exception);
            }
        }
        try {
            ErrorDialog.outOfBoundException();
        }
        catch (Exception exception) {
            ErrorDialog.showErrorDialog(exception);
        }
        try {
            ErrorDialog.arithmeticExceptionFiltered();
        }
        catch (Exception exception) {
            ErrorDialog.showErrorDialog(exception);
        }
        new ReportDialog(null).setVisible(true);
        SwingUtilities.invokeAndWait(new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                ErrorDialog.showErrorDialog(null);
                return null;
            }
        });
        SwingUtilities.invokeAndWait(new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ErrorDialog.showErrorDialog(null);
                return null;
            }
        });
    }

    public static void showErrorDialog(Throwable throwable) {
        ProgressManagerImpl progressManagerImpl = ProgressManagerImpl.getProgressManager();
        if (progressManagerImpl == null) {
            ErrorDialog.showErrorDialog(Main_GUI.get(), throwable);
        } else {
            Window window = progressManagerImpl.getWindow();
            if (window != null && !window.isVisible()) {
                try {
                    for (int i = 0; i < 6 && !window.isVisible(); ++i) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ErrorDialog.showErrorDialog(Main_GUI.get(), throwable);
        }
    }

    public static void writeErrorLog(Throwable throwable) {
        if (!ErrorDialog.isFiltered(throwable)) {
            new ErrorDialog((JFrame)null, throwable).writeErrorLog();
            lastError = throwable;
            lastErrorTime = System.currentTimeMillis();
        } else if (throwable != null) {
            System.out.println("#### FOLLOWING STACKTRACE HAS BEEN FILTERED ####");
            ErrorHandler.logAndReportException(throwable);
            System.out.println("#### STACKTRACE FILTERED ####");
        }
    }

    private static void arithmeticExceptionFiltered() {
        double d = 1 / 0;
        System.out.println("We never get here " + d);
    }

    private static boolean equals(Throwable throwable, Throwable throwable2) {
        StackTraceElement[] stackTraceElementArray;
        if (throwable == null || throwable2 == null) {
            return false;
        }
        if (throwable.getMessage() == null) {
            return throwable2.getMessage() == null;
        }
        if (!throwable.getMessage().equals(throwable2.getMessage())) {
            return false;
        }
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        if (stackTraceElementArray2.length != (stackTraceElementArray = throwable2.getStackTrace()).length) {
            return false;
        }
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            if (stackTraceElementArray2[i].equals(stackTraceElementArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isFiltered(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray;
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray = throwable == null ? null : throwable.getStackTrace();
        if (filterall || stackTraceElementArray == null || stackTraceElementArray.length == 0 || stackTraceElementArray[0].getClassName().equals("java.util.ConcurrentModificationException")) {
            return true;
        }
        if (stackTraceElementArray[0].getClassName().equals("javax.swing.plaf.basic.BasicProgressBarUI")) {
            return true;
        }
        if (throwable instanceof ArrayIndexOutOfBoundsException) {
            if (stackTraceElementArray[0].getClassName().equals("java.awt.Container") && stackTraceElementArray[0].getMethodName().equals("getComponent")) {
                return true;
            }
            if (stackTraceElementArray.length > 1 && stackTraceElementArray[0].getClassName().equals("java.util.Vector") && stackTraceElementArray[0].getMethodName().equals("elementAt") && stackTraceElementArray[1].getClassName().equals("javax.swing.tree.DefaultMutableTreeNode") && stackTraceElementArray[1].getMethodName().equals("getChildAt")) {
                return true;
            }
            if (stackTraceElementArray.length > 1 && stackTraceElementArray[0].getClassName().equals("java.util.Vector") && stackTraceElementArray[0].getMethodName().equals("elementAt") && stackTraceElementArray[1].getClassName().equals("javax.swing.table.DefaultTableColumnModel") && stackTraceElementArray[1].getMethodName().equals("getColumn")) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("sun.awt.shell.Win32ShellFolder2") && stackTraceElementArray[0].getMethodName().equals("getFileChooserIcon")) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("apple.awt.CWindow") && stackTraceElementArray[0].getMethodName().equals("displayChanged")) {
                return true;
            }
        }
        if (throwable instanceof NullPointerException) {
            if (stackTraceElementArray[0].getClassName().equals("javax.swing.plaf.basic.BasicTreeUI") && (stackTraceElementArray[0].getMethodName().equals("paintRow") || stackTraceElementArray[0].getMethodName().equals("paint") || stackTraceElementArray[0].getMethodName().equals("paintCell") || stackTraceElementArray[0].getMethodName().equals("getPathForRow") || stackTraceElementArray[0].getMethodName().equals("getLeadSelectionPath"))) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("javax.swing.DefaultDesktopManager") && stackTraceElementArray[0].getMethodName().equals("activateFrame")) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("javax.swing.plaf.basic.BasicTreeUI")) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("javax.swing.text.PlainView") && stackTraceElementArray[0].getMethodName().equals("updateMetrics")) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("javax.swing.plaf.basic.BasicTableUI")) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("javax.swing.JComponent")) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("com.sun.java.swing.plaf.windows.WindowsProgressBarUI")) {
                return true;
            }
            if (stackTraceElementArray.length > 3 && stackTraceElementArray[0].getClassName().equals("javax.swing.JComponent") && stackTraceElementArray[0].getMethodName().equals("repaint") && stackTraceElementArray[1].getClassName().equals("sun.swing.FilePane$2") && stackTraceElementArray[1].getMethodName().equals("repaintListSelection") && stackTraceElementArray[2].getClassName().equals("sun.swing.FilePane$2") && stackTraceElementArray[2].getMethodName().equals("repaintSelection") && stackTraceElementArray[3].getClassName().equals("sun.swing.FilePane$2") && stackTraceElementArray[3].getMethodName().equals("focusLost")) {
                return true;
            }
        }
        if (throwable instanceof ClassCastException && stackTraceElementArray[0].getClassName().equals("javax.swing.LayoutComparator") && stackTraceElementArray[0].getMethodName().equals("compare")) {
            return true;
        }
        if (throwable instanceof ArithmeticException) {
            if (stackTraceElementArray[0].getClassName().equals("common.ErrorDialog") && stackTraceElementArray[0].getMethodName().equals("arithmeticExceptionFiltered")) {
                return true;
            }
            if (stackTraceElementArray[0].getClassName().equals("com.sun.java.swing.plaf.windows.WindowsProgressBarUI") && stackTraceElementArray[0].getMethodName().equals("getBox")) {
                return true;
            }
        }
        if (throwable instanceof BadLocationException && stackTraceElementArray[0].getClassName().equals("javax.swing.text.GlyphView") && stackTraceElementArray[0].getMethodName().equals("getText")) {
            return true;
        }
        if (throwable instanceof IllegalComponentStateException && stackTraceElementArray[0].getClassName().equals("java.awt.Component") && stackTraceElementArray[0].getMethodName().equals("getLocationOnScreen_NoTreeLock")) {
            return true;
        }
        if (throwable instanceof InternalError && stackTraceElementArray[0].getClassName().equals("javax.swing.plaf.basic.BasicTreeUI")) {
            return true;
        }
        if (throwable instanceof IllegalArgumentException && stackTraceElementArray[0].getClassName().equals("org.jgraph.plaf.basic.BasicGraphUI")) {
            return true;
        }
        if (System.currentTimeMillis() - lastErrorTime < 10000L && ErrorDialog.equals(throwable, lastError)) {
            lastErrorTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    private static void nullPointerException() {
        Object var0 = null;
        var0[2] = "Bar";
    }

    private static void outOfBoundException() {
        double[] dArray = new double[]{};
        dArray[1] = 1.0;
    }

    private static void showErrorDialog(JFrame jFrame, Throwable throwable) {
        if (!ErrorDialog.isFiltered(throwable)) {
            ErrorDialog errorDialog = new ErrorDialog(jFrame, throwable);
            errorDialog.writeErrorLog();
            errorDialog.setVisible(true);
            lastError = throwable;
            lastErrorTime = System.currentTimeMillis();
        }
    }

    public ErrorDialog(JFrame jFrame, Throwable throwable) {
        super(jFrame, "Error Dialog");
        this.errorLog = new Vector();
        if (throwable == null) {
            throwable = new Throwable("ErrorDialog created with null Throwable");
        }
        if (throwable.toString().equals("java.lang.OutOfMemoryError: Java heap space")) {
            JOptionPane.showMessageDialog(null, "Evince has reached its maximum memory limit and cannot continue with \nthe current operation. Please contact Prediktera for information \nabout running Evince in 64bit mode.\n\n Program will now terminate.", "Out of memory", 2, null);
            System.exit(2);
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        Object object = stackTraceElementArray;
        int n = ((StackTraceElement[])object).length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement = object[i];
            this.errorLog.add(stackTraceElement.toString());
        }
        Container container = IniManager.getMainFrame();
        if (container instanceof Main_GUI && (container = ((Main_GUI)(object = (Main_GUI)container)).getCurrentProject()) != null && ((Project_GUI)container).getHistory_GUI() != null) {
            this.anonymousScript = "N/A";
        }
        try {
            this.subjectField.setText(throwable.toString());
            this.infoLabel.setText(throwable.toString());
            this.init();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public ErrorDialog(JFrame jFrame, Vector<String> vector) {
        super(jFrame, "Error Dialog");
        this.errorLog = vector;
        try {
            this.init();
        }
        catch (Exception exception) {
            logger.error("Error initializing error dialog", (Throwable)exception);
        }
    }

    @Override
    protected String getAnonymousScript() {
        if (this.anonymousScript != null) {
            return this.anonymousScript;
        }
        return "";
    }

    @Override
    protected String getStackTrace() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.errorLog != null && !this.errorLog.isEmpty()) {
            stringBuilder.append(this.encode(this.errorLog.get(0)));
            for (int i = 1; i < this.errorLog.size(); ++i) {
                stringBuilder.append(this.encode("\n" + this.errorLog.get(i)));
            }
        }
        return stringBuilder.toString();
    }

    protected void init() throws Exception {
        this.setAlwaysOnTop(true);
        this.detailsButton.addActionListener(actionEvent -> {
            this.showerrorpanel = !this.showerrorpanel;
            this.detailButtonPressed();
        });
        this.infoPanel.add((Component)this.detailsButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(6, 0, 6, 6), 0, 0));
        this.infoPanel.add((Component)this.infoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(6, 6, 6, 6), 0, 0));
        this.mainPanel.add((Component)this.infoPanel, "North");
        this.detailPanel.setVisible(false);
        this.typeComboBox.setEnabled(false);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        StringBuilder stringBuilder = new StringBuilder().append(this.informationArea.getText()).append("\nStackTrace:");
        for (int i = 0; i < this.errorLog.size(); ++i) {
            if (this.errorLog.elementAt(i) == null) continue;
            stringBuilder.append("\n\t").append(this.errorLog.elementAt(i));
        }
        stringBuilder.append("\n\nAnonymised script:");
        if (this.anonymousScript != null) {
            stringBuilder.append("\n").append(this.anonymousScript);
        }
        this.informationArea.setText(stringBuilder.toString());
        this.informationArea.setRows(5);
        this.informationArea.setColumns(25);
        this.informationArea.setCaretPosition(0);
        this.detailButtonPressed();
    }

    private void detailButtonPressed() {
        this.detailPanel.setVisible(this.showerrorpanel);
        if (this.showerrorpanel) {
            this.detailsButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/hidedetail.gif")));
        } else {
            this.detailsButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/showdetail.gif")));
        }
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrorLog() {
        RandomOutputStream randomOutputStream = null;
        try {
            randomOutputStream = new RandomOutputStream(IniManager.getEvinceSettingsFile("error.log"), true, null);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z");
            String string = "\n\n########## EVINCE LOG, " + simpleDateFormat.format(new Date()) + " ##########\n\n" + this.getInformationText();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\n') {
                    stringBuilder.append("\r");
                }
                stringBuilder.append(string.charAt(i));
            }
            randomOutputStream.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
        }
        finally {
            if (randomOutputStream != null) {
                try {
                    randomOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

