/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.error.ErrorHandler;

public class JTextFieldButtonUppDown
extends JSpinner
implements ChangeListener {
    private final boolean doubleValues;
    private SpinnerNumberModel spinnerNumberModel;
    private JValidateNumberField.NumberChangedInterface numberChangedInterface;
    private boolean doevent = true;

    public JTextFieldButtonUppDown() {
        this(-2.147483648E9, 2.147483647E9, true);
    }

    public JTextFieldButtonUppDown(boolean bl) {
        this(-2.147483648E9, 2.147483647E9, bl);
    }

    public JTextFieldButtonUppDown(double d, double d2, boolean bl) {
        this(0, d, d2, bl);
    }

    public JTextFieldButtonUppDown(int n, double d, double d2, boolean bl) {
        this.doubleValues = bl;
        this.setMinMax(d, d2);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public double getNumber() {
        if (this.spinnerNumberModel != null && this.spinnerNumberModel.getValue() != null) {
            return ((Number)this.spinnerNumberModel.getValue()).doubleValue();
        }
        return 0.0;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public boolean isCorrectInput() {
        try {
            JComponent jComponent = this.getEditor();
            if (jComponent instanceof JSpinner.DefaultEditor) {
                JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
                Double.parseDouble(jFormattedTextField.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public void setDecimals(int n) {
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }

    public void setMinMax(double d, double d2) {
        double d3 = this.getNumber();
        if (d3 > d2) {
            d3 = d2;
        } else if (d3 < d) {
            d3 = d;
        }
        if (d > d2) {
            d3 = d = d2;
        }
        if (this.doubleValues) {
            this.spinnerNumberModel = new SpinnerNumberModel(d3, d, d2, 0.5);
            this.setModel(this.spinnerNumberModel);
        } else {
            this.spinnerNumberModel = new SpinnerNumberModel(d3, d, d2, 1.0);
            this.setModel(this.spinnerNumberModel);
        }
    }

    public void setNumber(double d) {
        this.setNumberIntern(d);
    }

    public void setNumberChangedInterface(JValidateNumberField.NumberChangedInterface numberChangedInterface) {
        this.numberChangedInterface = numberChangedInterface;
    }

    public void setNumberIntern(double d) {
        this.doevent = false;
        this.spinnerNumberModel.setValue(d);
        this.doevent = true;
    }

    public void setRoundDoubles(boolean bl) {
    }

    public void setStepSize(double d) {
        this.spinnerNumberModel.setStepSize(d);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.doevent) {
            SwingUtilities.invokeLater(() -> {
                if (this.numberChangedInterface != null) {
                    this.numberChangedInterface.NumberChanged(0, this.getNumber());
                }
            });
        }
    }

    private void jbInit() throws Exception {
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor((JSpinner)this, "#.####");
        this.setEditor(numberEditor);
        this.setPreferredSize(new Dimension(50, 20));
        this.setMinimumSize(new Dimension(50, 20));
        this.addChangeListener(this);
    }
}

