/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.StatusBar;

public class JValidateNumberField
extends JTextField {
    private final ExitValidator exitValidator;
    private double number;
    private double min;
    private double max;
    private final boolean doubleValues;
    private boolean roundDoubles = true;
    private int decimals = 5;
    private NumberChangedInterface numberChangedInterface;
    private boolean canBeEmpty = false;

    public JValidateNumberField() {
        this(-2.147483647E9, 2.147483647E9, true);
    }

    public JValidateNumberField(boolean bl) {
        this(-2.147483647E9, 2.147483647E9, bl);
    }

    public JValidateNumberField(double d, double d2, boolean bl) {
        this(0, d, d2, bl);
    }

    public JValidateNumberField(int n, double d, double d2, boolean bl) {
        super(n);
        this.doubleValues = bl;
        this.setMinMax(d, d2);
        this.number = d > 0.0 ? d : 0.0;
        this.exitValidator = new ExitValidator();
        this.addFocusListener(this.exitValidator);
        this.addKeyListener(new KeyValidator());
    }

    public void forceValidateInput() {
        this.exitValidator.focusLost(null);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getNumber() {
        return this.number;
    }

    public void handleChanges() {
        String string = this.getText();
        try {
            double d = Double.parseDouble(string);
            if (!this.doubleValues) {
                d = (int)d;
            }
            if (d > this.getMax() || d < this.getMin()) {
                throw new NumberFormatException(".");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setForeground(Color.RED);
            return;
        }
        this.setForeground(Color.BLACK);
        class WaitThread
        extends Thread {
            String textSaved;

            public WaitThread(String string) {
                this.textSaved = string;
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String string = JValidateNumberField.this.getText();
                if (string != null && string.equals(this.textSaved)) {
                    double d = Double.parseDouble(this.textSaved);
                    if (JValidateNumberField.this.doubleValues) {
                        d = (int)d;
                    }
                    if (JValidateNumberField.this.getNumber() == d) {
                        return;
                    }
                    int n = JValidateNumberField.this.getCaretPosition();
                    JValidateNumberField.this.forceValidateInput();
                    n = n > JValidateNumberField.this.getText().length() ? JValidateNumberField.this.getText().length() : n;
                    JValidateNumberField.this.setCaretPosition(n);
                }
            }
        }
        new WaitThread(string).start();
    }

    public void setCanBeEmpty() {
        this.canBeEmpty = true;
    }

    public void setDecimals(int n) {
        if (n > 0) {
            this.decimals = Math.min(n, 10);
        }
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
        if (this.number < d) {
            this.number = d;
        }
        if (this.number > d2) {
            this.number = d2;
        }
        if (this.doubleValues) {
            this.setText(NiceDataFormat.toString(this.number));
        } else {
            this.setText(NiceDataFormat.toString((int)this.number));
        }
        if (d == -2.147483647E9 && d2 == 2.147483647E9) {
            this.setToolTipText("Number value");
        } else if (d2 == 2.147483647E9) {
            this.setToolTipText("Number above zero");
        } else {
            this.setToolTipText("Number between " + NiceDataFormat.toString(d) + " and " + NiceDataFormat.toString(d2));
        }
    }

    public void setNumber(double d) {
        if (this.doubleValues) {
            this.number = this.roundDoubles ? (double)Math.round(10.0 * d) / 10.0 : d;
            this.setText(NiceDataFormat.toString(this.fixedDecimals(this.number, this.decimals)));
        } else {
            this.number = d;
            this.setText(NiceDataFormat.toString((int)this.number));
        }
    }

    public void setNumberChangedInterface(NumberChangedInterface numberChangedInterface) {
        this.numberChangedInterface = numberChangedInterface;
    }

    public void setNumberIntern(double d) {
        if (Double.compare(this.number, d) != 0) {
            this.setNumber(d);
            if (this.numberChangedInterface != null) {
                this.numberChangedInterface.NumberChanged(0, d);
            }
        }
    }

    public void setRoundDoubles(boolean bl) {
        this.roundDoubles = bl;
    }

    public void setupAutoChange() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                JValidateNumberField.this.handleChanges();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                JValidateNumberField.this.handleChanges();
            }
        });
    }

    private double fixedDecimals(double d, int n) {
        return new BigDecimal(d).setScale(n, RoundingMode.HALF_EVEN).doubleValue();
    }

    class ExitValidator
    extends FocusAdapter {
        private boolean showerror = true;
        private double value;

        ExitValidator() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ((JTextField)focusEvent.getSource()).selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.validateInput();
            JValidateNumberField.this.setNumberIntern(this.value);
        }

        public boolean validateInput() {
            Object object;
            try {
                object = JValidateNumberField.this.getText();
                object = ((String)object).replace(',', '.');
                if (((String)object).length() == 0 && JValidateNumberField.this.canBeEmpty) {
                    return true;
                }
                this.value = Double.parseDouble((String)object);
                if (this.value >= JValidateNumberField.this.min && this.value <= JValidateNumberField.this.max) {
                    Main_GUI.resetStatusMessage();
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.value = JValidateNumberField.this.min;
            }
            if (this.showerror) {
                this.showerror = false;
                object = JValidateNumberField.this.min == -2.147483647E9 && JValidateNumberField.this.max == 2.147483647E9 ? "The input value must be a valid number" : "The input value must be a number between " + NiceDataFormat.toString(JValidateNumberField.this.min) + " and " + NiceDataFormat.toString(JValidateNumberField.this.max);
                Main_GUI.setStatusMessage(StatusBar.MessageType.WARNING, (String)object, 0);
                this.showerror = true;
                JValidateNumberField.this.requestFocus();
                JValidateNumberField.this.selectAll();
            }
            if (JValidateNumberField.this.min <= 0.0 && JValidateNumberField.this.max >= 0.0) {
                this.value = 0.0;
            } else if (this.value < JValidateNumberField.this.min) {
                this.value = JValidateNumberField.this.min;
            } else if (this.value > JValidateNumberField.this.max) {
                this.value = JValidateNumberField.this.max;
            }
            JValidateNumberField.this.setNumberIntern(this.value);
            if (JValidateNumberField.this.canBeEmpty) {
                JValidateNumberField.this.setText("");
            }
            return false;
        }

        private double getValue() {
            return this.value;
        }
    }

    class KeyValidator
    extends KeyAdapter {
        KeyValidator() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && JValidateNumberField.this.exitValidator.validateInput()) {
                JValidateNumberField.this.setNumberIntern(JValidateNumberField.this.exitValidator.getValue());
            }
        }
    }

    public static interface NumberChangedInterface {
        public void NumberChanged(int var1, double var2);
    }
}

