/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.Color;
import java.awt.Image;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class MacHelper {
    public static void setup(Window window, String string, ImageIcon imageIcon) {
        Logg.debug("Updating window settings for macOS", new Object[0]);
        MacHelper.enableOSXFullscreen(window);
        MacHelper.requestToggleFullScreen(window);
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        if (UpdateHelper.getPlatform().equals((Object)UpdateHelper.Platform.MacOSX)) {
            UIManager.put("Table.gridColor", new ColorUIResource(Color.lightGray));
        }
        MacHelper.setDockIcon(window, imageIcon);
    }

    public static void enableOSXFullscreen(Window window) {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
            Method method = clazz.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE);
            method.setAccessible(true);
            method.invoke(null, window, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logg.error("Class com.apple.eawt.FullScreenUtilities not found", classNotFoundException);
        }
        catch (Exception exception) {
            Logg.error("Cannot enable Mac OSX full screen", exception);
        }
    }

    public static void requestToggleFullScreen(Window window) {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Method method = clazz.getMethod("getApplication", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = object.getClass().getMethod("requestToggleFullScreen", Window.class);
            method2.setAccessible(true);
            method2.invoke(object, window);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logg.error("Class com.apple.eawt.Application not found", classNotFoundException);
        }
        catch (Exception exception) {
            Logg.error("Cannot enable request toggle full screen on Mac OSX", exception);
        }
    }

    public static void setDockIcon(Window window, ImageIcon imageIcon) {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Method method = clazz.getMethod("getApplication", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("setDockIconImage", Image.class);
            method2.setAccessible(true);
            method2.invoke(object, imageIcon.getImage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logg.error("Class com.apple.eawt.Application not found", classNotFoundException);
        }
        catch (Exception exception) {
            Logg.error("Cannot set dock icon on Mac OSX", exception);
        }
    }
}

