/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import se.prediktera.map.plot.ScientificFormat;

public final class NiceDataFormat {
    private static ScientificFormat sciFormat = new ScientificFormat(3, 3, true);
    private static SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
    private static SimpleDateFormat viewformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String convertDelimiters(String string) {
        return string.replace(",", ".");
    }

    public static double getConversionValue(byte by) {
        return 1.0;
    }

    public static String getUnitName(byte by) {
        return "";
    }

    public static boolean isNumber(String string) {
        return !Double.isNaN(NiceDataFormat.toNumber(string));
    }

    public static boolean isNumberScientific(String string) {
        return string.contains("e");
    }

    public static boolean isNumberOrNA(String string) {
        if (string.equals("NA")) {
            return true;
        }
        return NiceDataFormat.isNumber(string);
    }

    public static void main(String[] stringArray) {
        double d = -10.1232345;
        System.out.println(d + " became " + NiceDataFormat.toString(d));
        d = 1000.1232345;
        System.out.println(d + " became " + NiceDataFormat.toString(d));
        d = 125000.0;
        System.out.println(d + " became " + NiceDataFormat.toString(d));
        d = 3.19;
        System.out.println(d + " became " + NiceDataFormat.toString(d));
        d = 0.0;
        System.out.println(d + " became " + NiceDataFormat.toString(d));
        d = -0.0;
        System.out.println(d + " became " + NiceDataFormat.toString(d));
        d = -3.9999;
        System.out.println(d + " became " + NiceDataFormat.toString(d, 2));
        String.valueOf(d);
        for (d = 4.656612875245797E-10; d < 2.147483647E9; d *= 10.0) {
            System.out.println(d + " became " + NiceDataFormat.toString(d, 4));
        }
        for (d = 4.656612875245797E-10; d < 2.147483647E9; d *= 10.0) {
            System.out.println(-d + " became " + NiceDataFormat.toString(-d, 4));
        }
    }

    public static double toNumber(String string) {
        if (string != null) {
            try {
                return Double.parseDouble(NiceDataFormat.convertDelimiters(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public static int toNumberInt(String string) {
        return (int)NiceDataFormat.toNumber(string);
    }

    public static String toSimpleDate(String string) {
        try {
            Date date = format.parse(string);
            string = viewformat.format(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string;
    }

    public static String toPercent(double d) {
        return NiceDataFormat.toPercent(d, true);
    }

    public static String toPercent(double d, boolean bl) {
        String string = NiceDataFormat.toString(d * 100.0, 4);
        if (bl) {
            return string + "%";
        }
        return string;
    }

    public static String[] toString(double[] dArray) {
        return NiceDataFormat.toString(dArray, 6);
    }

    public static String toString(double d) {
        return NiceDataFormat.toString(d, 6);
    }

    public static String[] toString(double[] dArray, int n) {
        if (dArray == null) {
            return new String[]{"N/A"};
        }
        String[] stringArray = new String[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            stringArray[i] = NiceDataFormat.toString(dArray[i]);
        }
        return stringArray;
    }

    public static String toString(double d, int n) {
        return NiceDataFormat.toString(d, n, true);
    }

    public static String toString(double d, int n, boolean bl) {
        if (Double.isInfinite(d)) {
            return "Inf";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == 0.0) {
            return "0";
        }
        if (n < 0) {
            return String.valueOf(d);
        }
        double d2 = Math.abs(d);
        int n2 = (int)d2;
        boolean bl2 = n2 != 0;
        int n3 = NiceDataFormat.exp10(d2, bl2);
        if (bl && (bl2 ? n3 > n : n + n3 < 3)) {
            return NiceDataFormat.toSciString(d, n >= 6 ? n - 3 : n);
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        decimalFormat.applyPattern(NiceDataFormat.createPattern(n3, n));
        return decimalFormat.format(d);
    }

    public static String tryGetNiceString(String string) {
        try {
            Double d = Double.valueOf(string);
            return NiceDataFormat.toString(d);
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    private static String createPattern(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (n < 0) {
            stringBuilder.append("#.");
            stringBuilder.append("#".repeat(Math.max(0, n2 - 1)));
        } else {
            int n3 = 0;
            while (n3 < n2) {
                if (n == -1) {
                    stringBuilder.append(".");
                }
                stringBuilder.append("#");
                ++n3;
                --n;
            }
        }
        return stringBuilder.toString();
    }

    private static int exp10(double d, boolean bl) {
        int n = 0;
        double d2 = 1.0;
        if (bl) {
            while (d2 < d) {
                d2 *= 10.0;
                ++n;
            }
        } else {
            d2 /= 10.0;
            while (d2 > d) {
                d2 /= 10.0;
                --n;
            }
        }
        return n;
    }

    private static String toSciString(double d, int n) {
        if (sciFormat == null || sciFormat.getSigDigits() != n) {
            sciFormat = new ScientificFormat(n, n, true);
        }
        return sciFormat.format(d);
    }

    public static String initialLetter(String string) {
        if (string != null && string.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            if (string.length() > 1) {
                stringBuilder.append(string.substring(1));
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private NiceDataFormat() {
    }
}

