/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class NumericDocument
extends PlainDocument {
    protected double minValue = Double.MIN_VALUE;
    protected double maxValue = Double.MAX_VALUE;

    NumericDocument() {
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (this.isDigit(string.charAt(i))) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            Toolkit.getDefaultToolkit().beep();
        }
        super.insertString(n, stringBuilder.toString(), attributeSet);
        while ((string2 = this.getText(0, this.getLength())).length() != 0) {
            double d = 0.0;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            if (d >= this.minValue && d <= this.maxValue) break;
            Toolkit.getDefaultToolkit().beep();
            this.remove(this.getLength() - 1, 1);
        }
    }

    public void setValidityRange(double d, double d2) {
        this.minValue = d;
        this.maxValue = d2;
    }

    boolean isDigit(char c) {
        return Character.isDigit(c) || c == '-' || c == '+' || c == '.';
    }
}

