/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.Logg;

public class PerformanceTime {
    private static final String DEFAULT_NAME = "";
    private static HashMap<String, PerformanceTimeInner> performanceTimeInnerHashMap = new HashMap();
    private static int frames = -1;

    public static void setFrames(int n) {
        frames = n;
    }

    public static void globalStart() {
        PerformanceTime.globalStart(DEFAULT_NAME);
    }

    public static void globalStart(String string) {
        PerformanceTimeInner performanceTimeInner = performanceTimeInnerHashMap.get(string);
        if (performanceTimeInner != null) {
            Logg.trace("Performance Time with name '" + string + "' already exists, skipping globalStart", new Object[0]);
        } else {
            performanceTimeInner = new PerformanceTimeInner(string);
            performanceTimeInnerHashMap.put(string, performanceTimeInner);
            performanceTimeInner.globalStart();
        }
    }

    public static boolean hasStarted(String string) {
        return performanceTimeInnerHashMap.get(string) != null;
    }

    public static void globalEnd() {
        PerformanceTime.globalEnd(DEFAULT_NAME);
    }

    public static void globalEnd(String string) {
        PerformanceTimeInner performanceTimeInner = PerformanceTime.getPerformanceTime(string);
        if (performanceTimeInner == null) {
            Logg.warn("No performance time found with  name '{}', cant do globalEnd", string);
        } else {
            performanceTimeInner.globalEnd();
            performanceTimeInnerHashMap.remove(string);
        }
    }

    public static void start(String string) {
        PerformanceTime.start(DEFAULT_NAME, string);
    }

    public static void start(String string, String string2) {
        PerformanceTimeInner performanceTimeInner = PerformanceTime.getPerformanceTime(string);
        if (performanceTimeInner == null) {
            Logg.warn("No performance time found with  name '{}', cant start '{}'", string, string2);
        } else {
            performanceTimeInner.start(string2);
        }
    }

    public static void stop(String string) {
        PerformanceTime.stop(DEFAULT_NAME, string);
    }

    public static void stop(String string, String string2) {
        PerformanceTimeInner performanceTimeInner = PerformanceTime.getPerformanceTime(string);
        if (performanceTimeInner == null) {
            Logg.warn("No performance time found with  name '{}', cant stop '{}'", string);
        } else {
            performanceTimeInner.stop(string2);
        }
    }

    private static PerformanceTimeInner getPerformanceTime(String string) {
        return performanceTimeInnerHashMap.get(string);
    }

    private static class PerformanceTimeInner {
        private final HashMap<String, PerformanceType> ptHashMap = new HashMap();
        private long globaltime;
        private final PerformanceType root = new PerformanceType();
        private final LinkedList<PerformanceType> stack = new LinkedList();
        private final String name;

        public PerformanceTimeInner(String string) {
            this.name = string;
        }

        public void globalStart() {
            this.globaltime = System.currentTimeMillis();
            this.stack.add(this.root);
        }

        public void globalEnd() {
            this.globaltime = System.currentTimeMillis() - this.globaltime;
            this.print();
            this.ptHashMap.clear();
            this.stack.clear();
            this.root.children.clear();
        }

        public void start(String string) {
            PerformanceType performanceType = this.ptHashMap.get(string);
            if (performanceType == null) {
                performanceType = new PerformanceType();
                performanceType.description = string;
                this.ptHashMap.put(string, performanceType);
                PerformanceType performanceType2 = this.stack.getLast();
                performanceType2.children.add(performanceType);
            }
            performanceType.time = System.currentTimeMillis();
            ++performanceType.times;
            this.stack.add(performanceType);
        }

        public void stop(String string) {
            PerformanceType performanceType = this.ptHashMap.get(string);
            if (performanceType != null) {
                performanceType.totaltime += System.currentTimeMillis() - performanceType.time;
            }
            PerformanceType performanceType2 = null;
            try {
                performanceType2 = this.stack.removeLast();
            }
            catch (NoSuchElementException noSuchElementException) {
                System.err.println("stack empty - could not remove last timer: " + String.valueOf(performanceType));
            }
            if (performanceType2 != performanceType) {
                System.err.printf("stopped timer with description %s - but top timer on stack was %s. will probably fail\n", performanceType, performanceType2);
            }
        }

        private void print() {
            System.out.println("Performance Result" + (String)(this.name != null && this.name.length() > 0 ? " - " + this.name : PerformanceTime.DEFAULT_NAME));
            System.out.print("Total time = " + this.globaltime + " msek");
            if (frames >= 0 && this.globaltime > 0L) {
                System.out.print("\tFps = " + NiceDataFormat.toString((float)frames / (float)this.globaltime * 1000.0f, 4));
            }
            Runtime runtime = Runtime.getRuntime();
            System.out.println("\tMemory usage: " + this.toMB(runtime.totalMemory() - runtime.freeMemory()) + " (" + this.toMB(runtime.totalMemory()) + ") MB");
            System.out.println("--------------------------------------------");
            this.print(this.root, 0);
            System.out.println(PerformanceTime.DEFAULT_NAME);
        }

        private long toMB(long l) {
            return l / 1024L / 1024L;
        }

        private void print(PerformanceType performanceType3, int n) {
            Collections.sort(performanceType3.children, (performanceType, performanceType2) -> Double.compare(performanceType2.totaltime, performanceType.totaltime));
            for (PerformanceType performanceType4 : performanceType3.children) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" ".repeat(Math.max(0, n)));
                stringBuffer.append(" - ");
                stringBuffer.append(performanceType4.description);
                stringBuffer.append(" ".repeat(Math.max(0, 50 - (performanceType4.description.length() + n))));
                stringBuffer.append("time =\t");
                stringBuffer.append(performanceType4.totaltime);
                stringBuffer.append("\t\tnumber =\t");
                stringBuffer.append(performanceType4.times);
                stringBuffer.append("\tpercent =\t");
                stringBuffer.append(NiceDataFormat.toString((double)performanceType4.totaltime / (double)this.globaltime * 100.0, 4));
                stringBuffer.append("%");
                if (performanceType3.totaltime > 0L) {
                    stringBuffer.append(" (");
                    stringBuffer.append(NiceDataFormat.toString((double)performanceType4.totaltime / (double)performanceType3.totaltime * 100.0, 4));
                    stringBuffer.append("%)");
                }
                if (frames >= 0) {
                    stringBuffer.append("\tfps =\t");
                    if (performanceType4.totaltime > 0L) {
                        stringBuffer.append(NiceDataFormat.toString((float)frames / (float)performanceType4.totaltime * 1000.0f, 4));
                    }
                }
                System.out.println(stringBuffer);
                this.print(performanceType4, n + 1);
            }
        }

        private static class PerformanceType {
            private final List<PerformanceType> children = new LinkedList<PerformanceType>();
            private String description;
            private long totaltime;
            private long time;
            private int times;

            private PerformanceType() {
            }

            public String toString() {
                return this.description;
            }
        }
    }
}

