/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.AbstractRandomStream;
import se.prediktera.map.common.ErrorDialog;
import se.prediktera.map.common.MapException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.TreeHeader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.MemoryInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.ExtLibException;

public final class RandomInputStream
extends AbstractRandomStream {
    private byte[] bytebuffert;
    private byte[] buffert;
    private ByteArrayInputStream byteStream;
    private DataInputStream dataStream;
    private GZIPInputStream gzip;
    private long blockpos;
    private long blocksize;
    private HashMap<Integer, TreeHeader> datatreeList;
    private HashMap<String, SettingsHeader> settingsMap;
    private TreeHeader curTreeHeader;
    private DataTreeManager dataTreeManager;
    private Vector<String> ErrorLogg = new Vector();
    private boolean showloggwhenclose = false;
    private LinkedList<MapProperty> mapPropList = new LinkedList();
    private DataInputStream overidestream;
    private long offset = 0L;

    public RandomInputStream(DataInputStream dataInputStream, ProgressManager progressManager) throws IOException {
        super(progressManager);
        this.overidestream = dataInputStream;
    }

    public RandomInputStream(File file, ProgressManager progressManager) throws IOException {
        this(file, progressManager, 0L);
    }

    public RandomInputStream(File file, ProgressManager progressManager, long l) throws IOException {
        super(file, "r", progressManager);
        this.offset = l;
        if (l != 0L) {
            this.seek(0L);
        }
        this.initRandom();
    }

    public RandomInputStream(Project_GUI project_GUI, File file, ProgressManager progressManager) throws IOException {
        super(file, "r", progressManager);
        this.setProject_GUI(project_GUI);
        this.initRandom();
    }

    public RandomInputStream(Project_GUI project_GUI, String string, ProgressManager progressManager) throws IOException {
        super(string, "r", progressManager);
        this.setProject_GUI(project_GUI);
        this.initRandom();
    }

    public boolean beginDataBlock(long l, String string) throws IOException {
        this.seek(l);
        return this.beginDataBlock(string, true);
    }

    public boolean beginDataBlock(String string, boolean bl) throws IOException {
        this.blockpos = 0L;
        switch (this.accesstype) {
            case 0: {
                this.blocksize = this.readLong();
                byte by = this.readByte();
                this.useCompression(by == 1);
                int n = this.readInt();
                if (n != 0xAAAAAA) {
                    this.seek(this.getFilePointer() - 5L);
                    this.useCompression(false);
                    n = this.readInt();
                    if (n != 0xAAAAAA) {
                        Logg.error("CRC Failed, Info: " + string, new Object[0]);
                        return false;
                    }
                }
                if (this.pmanager != null && this.blocksize > 1000L) {
                    if (bl) {
                        this.pmanager.setMaximumAndReset((int)this.blocksize);
                    }
                    this.pmanager.setInfoText(string);
                }
                this.byteStream.skip(this.byteStream.available());
                this.readBlockIfNecessary();
                if (this.useCompression()) {
                    this.gzip = new GZIPInputStream((InputStream)this.byteStream, 2048);
                    this.dataStream = new DataInputStream(this.gzip);
                    break;
                }
                this.dataStream = new DataInputStream(this.byteStream);
                break;
            }
            case 1: {
                this.dataStream = this.overidestream;
            }
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.close();
                break;
            }
            case 1: {
                this.overidestream.close();
            }
        }
        if (this.showloggwhenclose && this.ErrorLogg.size() != 0) {
            this.showErrorDialog();
        }
        this.cleanUp();
    }

    public void copyDataBlock(MemoryInterface memoryInterface, RandomOutputStream randomOutputStream) throws IOException {
        if (this.beginDataBlock(memoryInterface.getBlockBegin(), "Copying datablock")) {
            randomOutputStream.beginDataBlock();
            try {
                for (long i = 0L; i < this.blocksize; ++i) {
                    randomOutputStream.WriteBlockByte(this.ReadBlockByte());
                }
            }
            catch (EOFException eOFException) {
                Object object = eOFException.getMessage();
                object = object == null ? this.toString() : (String)object + " " + String.valueOf(this);
                EOFException eOFException2 = new EOFException((String)object);
                eOFException2.setStackTrace(eOFException.getStackTrace());
                throw eOFException2;
            }
            randomOutputStream.endDataBlock();
            this.endDataBlock();
        } else {
            ErrorHandler.logAndShowEvinceErrorDialogForException(new Throwable("Failed to copy datablock at " + memoryInterface.getBlockBegin() + ", (" + String.valueOf(memoryInterface) + ")"));
        }
    }

    public void endDataBlock() throws IOException {
        if (this.accesstype == 0) {
            this.dataStream.close();
            if (this.useCompression()) {
                this.gzip.close();
            }
        }
        this.dataStream = null;
    }

    public TreeHeader getCT() {
        return this.curTreeHeader;
    }

    public DataInputStream getDataStream() {
        return this.dataStream;
    }

    public DataTreeManager getDataTreeManager() {
        return this.dataTreeManager;
    }

    public BufferedImage getProjectImage() {
        long l = this.getStartIndex((byte)5);
        long l2 = this.getEndIndex((byte)5);
        if (l > 0L && l2 > l) {
            try {
                this.seek(l);
                byte[] byArray = new byte[(int)(l2 - l)];
                this.read(byArray);
                return ImageIO.read(new ByteArrayInputStream(byArray));
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
        }
        return null;
    }

    public int read(byte[] byArray) throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.read(byArray);
            case 1 -> this.overidestream.read(byArray);
            default -> 0;
        };
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.read(byArray, n, n2);
            case 1 -> this.overidestream.read(byArray, n, n2);
            default -> 0;
        };
    }

    public boolean ReadBlockBoolean() throws IOException {
        this.readBlockIfNecessary();
        return this.dataStream.readBoolean();
    }

    public byte ReadBlockByte() throws IOException {
        this.readBlockIfNecessary();
        return this.dataStream.readByte();
    }

    public byte[] ReadBlockByteArray() throws IOException {
        this.readBlockIfNecessary();
        int n = this.dataStream.readInt();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.readBlockIfNecessary();
            byArray[i] = this.dataStream.readByte();
        }
        return byArray;
    }

    public double ReadBlockDouble() throws IOException {
        this.readBlockIfNecessary();
        return this.dataStream.readDouble();
    }

    public double[] ReadBlockDoubleArray() throws IOException {
        this.readBlockIfNecessary();
        int n = this.dataStream.readInt();
        if (n == 0) {
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            this.readBlockIfNecessary();
            dArray[i] = this.dataStream.readDouble();
        }
        return dArray;
    }

    public float ReadBlockFloat() throws IOException {
        this.readBlockIfNecessary();
        return this.dataStream.readFloat();
    }

    public int ReadBlockInt() throws IOException {
        this.readBlockIfNecessary();
        return this.dataStream.readInt();
    }

    public int[] ReadBlockIntArray() throws IOException {
        this.readBlockIfNecessary();
        int n = this.dataStream.readInt();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            this.readBlockIfNecessary();
            nArray[i] = this.dataStream.readInt();
        }
        return nArray;
    }

    public long ReadBlockLong() throws IOException {
        this.readBlockIfNecessary();
        return this.dataStream.readLong();
    }

    public short ReadBlockShort() throws IOException {
        this.readBlockIfNecessary();
        return this.dataStream.readShort();
    }

    public String ReadBlockUTF() throws IOException {
        this.readBlockIfNecessary();
        return this.dataStream.readUTF();
    }

    public boolean readBoolean() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readBoolean();
            case 1 -> this.overidestream.readBoolean();
            default -> false;
        };
    }

    public byte readByte() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readByte();
            case 1 -> this.overidestream.readByte();
            default -> 0;
        };
    }

    public double readDouble() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readDouble();
            case 1 -> this.overidestream.readDouble();
            default -> 0.0;
        };
    }

    public FileFramework readFileFramework(boolean bl) throws IOException {
        return this.readFileFramework(bl, true);
    }

    public FileFramework readFileFramework(boolean bl, boolean bl2) throws IOException {
        int n;
        this.seek(0L);
        byte[] byArray = new byte[20];
        this.read(byArray);
        if (byArray[0] != this.versionName[0] || byArray[1] != this.versionName[1] || byArray[2] != this.versionName[2]) {
            throw new IOException("Unknown file format");
        }
        this.MAPversion = byArray[3] * 255 + byArray[4];
        FileFramework fileFramework = new FileFramework();
        this.seek(20L);
        for (n = 0; n < 10; ++n) {
            this.indexTable[n][0] = this.readLong();
            this.indexTable[n][1] = this.readLong();
        }
        if (this.indexTable[2][0] > 0L) {
            this.goToIndex((byte)2);
            fileFramework.description = this.readUTF();
        }
        if (bl) {
            Object object;
            n = (long)InitClass.OldestPlotVersion.intValue() <= this.getSaveVersion() ? 1 : 0;
            byte[] byArray2 = new byte[16384];
            long l = -2147483647L;
            int n2 = 0;
            this.goToIndex((byte)1);
            long l2 = this.getFilePointer();
            while (l2 < this.getEndIndex((byte)1)) {
                if (l2 > l + 16384L - 50L) {
                    this.seek(l2);
                    this.read(byArray2, 0, 16384);
                    l = l2;
                }
                n2 = (int)(l2 - l);
                object = new TreeHeader(byArray2, l, n2, fileFramework);
                if (((TreeHeader)object).node != 2 || n != 0) {
                    boolean bl3;
                    boolean bl4 = bl3 = bl2 || !((TreeHeader)object).isGuiNode();
                    if (bl3) {
                        this.datatreeList.put(((TreeHeader)object).id, (TreeHeader)object);
                    }
                    if (((TreeHeader)object).id >= fileFramework.maxnumber) {
                        fileFramework.maxnumber = ((TreeHeader)object).id + 1;
                    }
                }
                l2 = ((TreeHeader)object).dataEnd;
            }
            this.goToIndex((byte)8);
            while (this.getFilePointer() < this.getEndIndex((byte)8)) {
                object = new SettingsHeader();
                ((SettingsHeader)object).length = this.readLong();
                ((SettingsHeader)object).CRC = this.readInt();
                if (((SettingsHeader)object).CRC != 0xAAAAAA) {
                    throw new IOException("CRC check error, this file contains errors");
                }
                ((SettingsHeader)object).nrproperties = this.readInt();
                String string = this.readUTF();
                ((SettingsHeader)object).startp = this.getFilePointer();
                this.settingsMap.put(string, (SettingsHeader)object);
                this.seek(((SettingsHeader)object).length + ((SettingsHeader)object).startp);
            }
        }
        return fileFramework;
    }

    public float readFloat() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readFloat();
            case 1 -> this.overidestream.readFloat();
            default -> 0.0f;
        };
    }

    public int readInt() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readInt();
            case 1 -> this.overidestream.readInt();
            default -> 0;
        };
    }

    public String readLine() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readLine();
            case 1 -> "";
            default -> "";
        };
    }

    public long readLong() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readLong();
            case 1 -> this.overidestream.readLong();
            default -> 0L;
        };
    }

    public MapProperty readNodeProperties() throws IOException {
        String string;
        int n = Integer.MAX_VALUE;
        if (this.accesstype == 0) {
            this.blocksize = this.readLong();
            int n2 = this.readInt();
            if (n2 != 0xAAAAAA) {
                Logg.error("CRC Failed, Info: readNodeProperties()", new Object[0]);
                return null;
            }
            n = this.readInt();
        }
        if ((string = this.readUTF()).equals("node")) {
            return this.readPropertiesIntoMap(n);
        }
        return null;
    }

    public MapProperty readProperties(String string) throws IOException {
        switch (this.accesstype) {
            case 0: {
                if (!this.settingsMap.containsKey(string)) break;
                SettingsHeader settingsHeader = this.settingsMap.get(string);
                if (settingsHeader.length == 0L) {
                    return null;
                }
                this.seek(settingsHeader.startp);
                this.blocksize = settingsHeader.length;
                return this.readPropertiesIntoMap(settingsHeader.nrproperties);
            }
            case 1: {
                return this.readPropertiesIntoMap(Integer.MAX_VALUE);
            }
        }
        return null;
    }

    public short readShort() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readShort();
            case 1 -> this.overidestream.readShort();
            default -> 0;
        };
    }

    public String readUTF() throws IOException {
        return switch (this.accesstype) {
            case 0 -> this.randomAccessFile.readUTF();
            case 1 -> this.overidestream.readUTF();
            default -> "";
        };
    }

    public DataTreeInterface resolveNodeFromID(Object object, int n) {
        if (this.dataTreeManager != null) {
            try {
                DataTreeInterface dataTreeInterface = this.dataTreeManager.getDataTreeInterface(n);
                if (this.accesstype == 0 && dataTreeInterface == null) {
                    this.curTreeHeader = this.datatreeList.get(n);
                    if (this.curTreeHeader == null) {
                        return null;
                    }
                    long l = this.getFilePointer();
                    this.seek(this.curTreeHeader.dataStart);
                    dataTreeInterface = DataTreeManager.Load(object, this);
                    this.seek(l);
                }
                return dataTreeInterface;
            }
            catch (IOException | ExtLibException exception) {
                this.ErrorLogg.addElement(String.valueOf(exception.getStackTrace()[0]) + ": " + exception.getMessage());
            }
        }
        return null;
    }

    public DataTreeInterface resolveRoot() {
        return this.resolveNodeFromID(null, this.getRootID());
    }

    @Override
    public void seek(long l) throws IOException {
        super.seek(this.offset + l);
    }

    public void setDataTreeManager(DataTreeManager dataTreeManager) {
        this.dataTreeManager = dataTreeManager;
    }

    public void setProject_GUI(Project_GUI project_GUI) {
        if (project_GUI != null) {
            this.dataTreeManager = project_GUI.dataTreeManager;
        }
    }

    public void setShowLoggWhenClose() {
        this.showloggwhenclose = true;
    }

    public void setStreamID(int n) {
        if (this.curTreeHeader == null) {
            this.curTreeHeader = new TreeHeader();
        }
        this.curTreeHeader.id = n;
    }

    public void showErrorDialog() {
        ErrorDialog errorDialog = new ErrorDialog((JFrame)Main_GUI.get(), this.ErrorLogg);
        errorDialog.setVisible(true);
    }

    @Override
    public void skip(int n) throws IOException {
        if (this.accesstype == 1) {
            this.overidestream.skipBytes(n);
        } else {
            int n2 = n;
            while (n2 > 0) {
                int n3 = this.byteStream.available();
                n2 = this.dataStream == null ? (int)((long)n2 - this.byteStream.skip(Math.min(n2, n3))) : (n2 -= this.dataStream.skipBytes(Math.min(n2, n3)));
                if (n2 <= 0) continue;
                this.readBlockIfNecessary();
            }
        }
    }

    public String toString() {
        return (this.useCompression() ? "Compressed " : " ") + (this.accesstype == 0 ? "Random " : "Stream ") + "bp==" + this.blockpos + " bs==" + this.blocksize;
    }

    public void tryClose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
    }

    @Override
    protected void cleanUpChild() {
        this.bytebuffert = null;
        this.buffert = null;
        this.byteStream = null;
        this.dataStream = null;
        this.gzip = null;
        if (this.datatreeList != null) {
            this.datatreeList.clear();
        }
        this.datatreeList = null;
        if (this.settingsMap != null) {
            this.settingsMap.clear();
        }
        this.settingsMap = null;
        this.curTreeHeader = null;
        this.dataTreeManager = null;
        this.ErrorLogg.removeAllElements();
        this.ErrorLogg = null;
        if (!this.mapPropList.isEmpty()) {
            MapProperty mapProperty = this.mapPropList.remove(0);
            mapProperty.cleanUp();
        }
        this.mapPropList = null;
    }

    private void initRandom() {
        this.bytebuffert = new byte[4096];
        this.buffert = new byte[4096];
        this.byteStream = new ByteArrayInputStream(this.bytebuffert);
        this.datatreeList = new HashMap();
        this.settingsMap = new HashMap();
    }

    private void readBlockIfNecessary() throws IOException {
        int n;
        if (this.accesstype == 0 && (n = this.byteStream.available()) < 2048 && this.blockpos < this.blocksize) {
            int n2;
            int n3 = 4096 - n;
            long l = this.blocksize - this.blockpos;
            int n4 = n2 = (long)n3 > l ? (int)l : n3;
            if (this.pmanager != null) {
                this.pmanager.incStep(n2);
            }
            int n5 = this.read(this.buffert, 0, n2);
            this.blockpos += (long)n5;
            if (n5 > 0) {
                int n6 = n3;
                int n7 = 0;
                while (n6 < 4096) {
                    this.bytebuffert[n7] = this.bytebuffert[n6];
                    ++n6;
                    ++n7;
                }
                n6 = 0;
                n7 = n;
                while (n6 < n5) {
                    this.bytebuffert[n7] = this.buffert[n6];
                    ++n6;
                    ++n7;
                }
                this.byteStream.reset();
            }
        }
    }

    private MapProperty readPropertiesIntoMap(int n) throws IOException {
        MapProperty mapProperty = new MapProperty(this.ErrorLogg);
        switch (this.accesstype) {
            case 0: {
                this.byteStream.skip(this.byteStream.available());
                this.dataStream = new DataInputStream(this.byteStream);
                this.blockpos = 0L;
                break;
            }
            case 1: {
                this.dataStream = this.overidestream;
            }
        }
        int n2 = 0;
        block24: while (n2++ < n) {
            this.readBlockIfNecessary();
            byte by = this.ReadBlockByte();
            String string = this.ReadBlockUTF();
            switch (by) {
                case 5: {
                    mapProperty.put(string, this.ReadBlockByte());
                    continue block24;
                }
                case 1: {
                    mapProperty.put(string, this.ReadBlockInt());
                    continue block24;
                }
                case 2: {
                    mapProperty.put(string, this.ReadBlockLong());
                    continue block24;
                }
                case 8: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    Object object = new long[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        object[n3] = this.ReadBlockLong();
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 7: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    Object object = new int[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        object[n3] = this.ReadBlockInt();
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 17: {
                    int n5;
                    int n3;
                    int n4 = this.ReadBlockInt();
                    Object object = new int[n4][];
                    for (n3 = 0; n3 < n4; ++n3) {
                        n5 = this.ReadBlockInt();
                        object[n3] = (long)new int[n5];
                        for (int i = 0; i < n5; ++i) {
                            object[n3][i] = this.ReadBlockInt();
                        }
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 12: {
                    mapProperty.put(string, Float.valueOf(this.ReadBlockFloat()));
                    continue block24;
                }
                case 18: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    Object object = new float[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        object[n3] = (long)this.ReadBlockFloat();
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 3: {
                    mapProperty.put(string, this.ReadBlockDouble());
                    continue block24;
                }
                case 9: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    Object object = new double[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        object[n3] = (long)this.ReadBlockDouble();
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 4: {
                    mapProperty.put(string, this.ReadBlockUTF());
                    continue block24;
                }
                case 16: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    Object object = new String[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        object[n3] = (long)this.ReadBlockUTF();
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 0: {
                    mapProperty.put(string, this.ReadBlockBoolean());
                    continue block24;
                }
                case 6: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    Object object = new boolean[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        object[n3] = (long)this.ReadBlockBoolean();
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 13: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    int n5 = this.ReadBlockInt();
                    Object object = new boolean[n4][n5];
                    for (n3 = 0; n3 < n4; ++n3) {
                        for (int i = 0; i < n5; ++i) {
                            object[n3][i] = this.ReadBlockBoolean();
                        }
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 14: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    int n5 = this.ReadBlockInt();
                    Object object = new double[n4][n5];
                    for (n3 = 0; n3 < n4; ++n3) {
                        for (int i = 0; i < n5; ++i) {
                            object[n3][i] = this.ReadBlockDouble();
                        }
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case 15: {
                    int n3;
                    int n4 = this.ReadBlockInt();
                    Object object = new Properties();
                    for (n3 = 0; n3 < n4; ++n3) {
                        String string2 = this.ReadBlockUTF();
                        String string3 = this.ReadBlockUTF();
                        ((Properties)object).put(string2, string3);
                    }
                    mapProperty.put(string, object);
                    continue block24;
                }
                case -1: {
                    n = 0;
                    continue block24;
                }
            }
            throw new MapException("File contains error, cannot read");
        }
        if (this.accesstype == 0) {
            this.dataStream.close();
        }
        this.dataStream = null;
        this.mapPropList.add(mapProperty);
        return mapProperty;
    }

    public static class FileFramework
    implements BasicTreeInterface {
        public File file;
        public String description;
        public HashSet<Integer> libraries = new HashSet();
        public int folder = 0;
        public int files = 0;
        public int maxnumber = 0;
        public long size;
    }

    public static class SettingsHeader {
        public int CRC;
        public long length;
        public int nrproperties;
        public long startp;
    }
}

