/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.Dimension;
import java.awt.Point;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.AbstractRandomStream;
import se.prediktera.map.common.RandomByteArrayOutputStream;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.DataTreeInterface;

public final class RandomOutputStream
extends AbstractRandomStream {
    private RandomByteArrayOutputStream byteStream;
    private DataOutputStream dataStream;
    private GZIPOutputStream gzip;
    private long beginproperty;
    private long begindata;
    private int nrproperties;
    private String prefix = "";
    private boolean writeproperty = false;
    private DataOutputStream overidestream;
    private RandomInputStream swapFile = null;
    private boolean storePosition = true;

    public RandomOutputStream(DataOutputStream dataOutputStream, ProgressManager progressManager) throws IOException {
        super(progressManager);
        this.overidestream = dataOutputStream;
    }

    public RandomOutputStream(File file, boolean bl, ProgressManager progressManager) throws IOException {
        super(file, "rw", progressManager);
        if (bl) {
            this.seek(file.length());
        }
        this.initRandom();
    }

    public RandomOutputStream(String string, boolean bl, ProgressManager progressManager) throws IOException {
        super(string, "rw", progressManager);
        if (bl) {
            this.seek(this.file.length());
        }
        this.initRandom();
    }

    public long beginDataBlock() throws IOException {
        this.begindata = this.getFilePointer();
        switch (this.accesstype) {
            case 0: {
                this.writeLong(0L);
                this.writeByte(this.useCompression() ? 1 : 0);
                this.writeInt(0xAAAAAA);
                this.byteStream.reset();
                if (this.useCompression()) {
                    this.gzip = new GZIPOutputStream((OutputStream)this.byteStream, 2048);
                    this.dataStream = new DataOutputStream(this.gzip);
                    break;
                }
                this.dataStream = new DataOutputStream(this.byteStream);
                break;
            }
            case 1: {
                this.dataStream = this.overidestream;
            }
        }
        return this.begindata;
    }

    public void beginNodeProperty() throws IOException {
        this.beginProperty("node");
    }

    public void beginProperty(String string) throws IOException {
        this.writeproperty = true;
        switch (this.accesstype) {
            case 0: {
                this.beginproperty = this.getFilePointer();
                this.writeLong(0L);
                this.writeInt(0xAAAAAA);
                this.writeInt(0);
                this.writeUTF(string);
                this.begindata = this.getFilePointer();
                this.byteStream.reset();
                this.dataStream = new DataOutputStream(this.byteStream);
                break;
            }
            case 1: {
                this.writeUTF(string);
                this.dataStream = this.overidestream;
            }
        }
        this.nrproperties = 0;
    }

    @Override
    public void close() throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.close();
                break;
            }
            case 1: {
                this.overidestream.close();
            }
        }
        if (this.swapFile != null) {
            this.swapFile.close();
        }
        this.cleanUp();
    }

    public void endDataBlock() throws IOException {
        if (this.accesstype == 0) {
            this.dataStream.flush();
            if (this.useCompression()) {
                this.gzip.finish();
                this.gzip.close();
            }
            this.write(this.byteStream.getArray(), 0, this.byteStream.size());
            this.dataStream.close();
            long l = this.getFilePointer();
            this.seek(this.begindata);
            this.writeLong(l - this.begindata);
            this.seek(l);
        }
        this.dataStream = null;
    }

    public void endProperty() throws IOException {
        if (this.writeproperty) {
            switch (this.accesstype) {
                case 0: {
                    this.dataStream.flush();
                    this.write(this.byteStream.getArray(), 0, this.byteStream.size());
                    this.dataStream.close();
                    long l = this.getFilePointer();
                    this.seek(this.beginproperty);
                    this.writeLong(l - this.begindata);
                    this.writeInt(0xAAAAAA);
                    this.writeInt(this.nrproperties);
                    this.seek(l);
                    break;
                }
                case 1: {
                    this.writeByte(-1);
                    this.writeUTF("END");
                }
            }
            this.dataStream = null;
        }
        this.writeproperty = false;
    }

    public void flush() throws IOException {
        if (this.accesstype == 1) {
            this.overidestream.flush();
        }
    }

    public DataOutputStream getDataStream() {
        return this.dataStream;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public RandomInputStream getSwapFile() {
        return this.swapFile;
    }

    public boolean isStorePosition() {
        return this.storePosition;
    }

    public void newLine() throws IOException {
        this.write("\r\n");
    }

    public void setEndIndex(byte by, long l) {
        this.indexTable[by][1] = l;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setStartIndex(byte by, long l) {
        this.indexTable[by][0] = l;
    }

    public void setStorePosition(boolean bl) {
        this.storePosition = bl;
    }

    public void setSwapFile(RandomInputStream randomInputStream) {
        this.swapFile = randomInputStream;
    }

    public void write(byte[] byArray) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.write(byArray);
                break;
            }
            case 1: {
                this.overidestream.write(byArray);
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.write(byArray, n, n2);
                break;
            }
            case 1: {
                this.overidestream.write(byArray, n, n2);
            }
        }
    }

    public void write(String string) throws IOException {
        this.writeBytes(string);
    }

    public void WriteBlockBoolean(boolean bl) throws IOException {
        this.dataStream.writeBoolean(bl);
        this.flushBlockIfFull();
    }

    public void WriteBlockByte(byte by) throws IOException {
        this.dataStream.writeByte(by);
        this.flushBlockIfFull();
    }

    public void WriteBlockByteArray(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.dataStream.writeInt(0);
            this.flushBlockIfFull();
        } else {
            this.dataStream.writeInt(byArray.length);
            this.flushBlockIfFull();
            for (byte by : byArray) {
                this.dataStream.writeByte(by);
                this.flushBlockIfFull();
            }
        }
    }

    public void WriteBlockDouble(double d) throws IOException {
        this.dataStream.writeDouble(d);
        this.flushBlockIfFull();
    }

    public void WriteBlockDoubleArray(double[] dArray) throws IOException {
        if (dArray == null) {
            this.dataStream.writeInt(0);
            this.flushBlockIfFull();
        } else {
            this.dataStream.writeInt(dArray.length);
            this.flushBlockIfFull();
            for (double d : dArray) {
                this.dataStream.writeDouble(d);
                this.flushBlockIfFull();
            }
        }
    }

    public void WriteBlockFloat(float f) throws IOException {
        this.dataStream.writeFloat(f);
        this.flushBlockIfFull();
    }

    public void WriteBlockInt(int n) throws IOException {
        this.dataStream.writeInt(n);
        this.flushBlockIfFull();
    }

    public void WriteBlockIntArray(int[] nArray) throws IOException {
        if (nArray == null) {
            this.dataStream.writeInt(0);
            this.flushBlockIfFull();
        } else {
            this.dataStream.writeInt(nArray.length);
            this.flushBlockIfFull();
            for (int n : nArray) {
                this.dataStream.writeInt(n);
                this.flushBlockIfFull();
            }
        }
    }

    public void WriteBlockLong(long l) throws IOException {
        this.dataStream.writeLong(l);
        this.flushBlockIfFull();
    }

    public void WriteBlockShort(short s) throws IOException {
        this.dataStream.writeShort(s);
        this.flushBlockIfFull();
    }

    public void WriteBlockUTF(String string) throws IOException {
        if (string == null) {
            this.dataStream.writeUTF("");
        } else {
            this.dataStream.writeUTF(string);
        }
        this.flushBlockIfFull();
    }

    public void writeBoolean(boolean bl) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.writeBoolean(bl);
                break;
            }
            case 1: {
                this.overidestream.writeBoolean(bl);
            }
        }
    }

    public void writeByte(int n) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.writeByte(n);
                break;
            }
            case 1: {
                this.overidestream.writeByte(n);
            }
        }
    }

    public void writeBytes(String string) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.writeBytes(string);
                break;
            }
            case 1: {
                this.overidestream.writeBytes(string);
            }
        }
    }

    public boolean writeHeader(int n) {
        this.MAPversion = n;
        try {
            this.seek(0L);
            byte[] byArray = new byte[20];
            int n2 = 0;
            for (n2 = 0; n2 < 3; ++n2) {
                byArray[n2] = this.versionName[n2];
            }
            byArray[n2++] = (byte)(n >> 8 & 0xFF);
            byArray[n2++] = (byte)(n & 0xFF);
            this.write(byArray);
            return true;
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
            return false;
        }
    }

    public void writeIndexTable() {
        this.indexTable[4][0] = InitClass.Version.intValue();
        try {
            this.seek(20L);
            for (int i = 0; i < 10; ++i) {
                this.writeLong(this.indexTable[i][0]);
                this.writeLong(this.indexTable[i][1]);
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    public void writeInt(int n) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.writeInt(n);
                break;
            }
            case 1: {
                this.overidestream.writeInt(n);
            }
        }
    }

    public void writeLine(String string) throws IOException {
        this.write(string);
        this.newLine();
    }

    public void writeLong(long l) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.writeLong(l);
                break;
            }
            case 1: {
                this.overidestream.writeLong(l);
            }
        }
    }

    public void writeProperty(String string, Properties properties) throws IOException {
        if (properties != null) {
            this.WriteBlockByte((byte)15);
            this.WriteBlockUTF(this.prefix + string);
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            int n = set.size();
            this.WriteBlockInt(n);
            if (n > 0) {
                for (Map.Entry<Object, Object> entry : set) {
                    this.WriteBlockUTF(String.valueOf(entry.getKey()));
                    this.WriteBlockUTF(String.valueOf(entry.getValue()));
                }
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyBoolean(String string, boolean bl) throws IOException {
        this.WriteBlockByte((byte)0);
        this.WriteBlockUTF(this.prefix + string);
        this.WriteBlockBoolean(bl);
        ++this.nrproperties;
    }

    public void writePropertyBooleanArray(String string, boolean[] blArray) throws IOException {
        if (blArray != null) {
            this.WriteBlockByte((byte)6);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(blArray.length);
            for (boolean bl : blArray) {
                this.WriteBlockBoolean(bl);
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyBooleanArray(String string, boolean[][] blArray) throws IOException {
        if (blArray != null) {
            this.WriteBlockByte((byte)13);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(blArray.length);
            this.WriteBlockInt(blArray.length > 0 ? blArray[0].length : 0);
            for (boolean[] blArray2 : blArray) {
                for (int i = 0; i < blArray2.length; ++i) {
                    this.WriteBlockBoolean(blArray2[i]);
                }
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyByte(String string, byte by) throws IOException {
        this.WriteBlockByte((byte)5);
        this.WriteBlockUTF(this.prefix + string);
        this.WriteBlockByte(by);
        ++this.nrproperties;
    }

    public void writePropertyByteArray(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            this.WriteBlockByte((byte)10);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(byArray.length);
            for (byte by : byArray) {
                this.WriteBlockByte(by);
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyDimension(String string, Dimension dimension) throws IOException {
        if (dimension != null) {
            this.WriteBlockByte((byte)7);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(2);
            this.WriteBlockInt(dimension.width);
            this.WriteBlockInt(dimension.height);
            ++this.nrproperties;
        }
    }

    public void writePropertyDouble(String string, double d) throws IOException {
        this.WriteBlockByte((byte)3);
        this.WriteBlockUTF(this.prefix + string);
        this.WriteBlockDouble(d);
        ++this.nrproperties;
    }

    public void writePropertyDoubleArray(String string, double[] dArray) throws IOException {
        if (dArray != null) {
            this.WriteBlockByte((byte)9);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(dArray.length);
            for (double d : dArray) {
                this.WriteBlockDouble(d);
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyDoubleArray(String string, double[][] dArray) throws IOException {
        if (dArray != null) {
            this.WriteBlockByte((byte)14);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(dArray.length);
            this.WriteBlockInt(dArray.length > 0 ? dArray[0].length : 0);
            for (double[] dArray2 : dArray) {
                for (int i = 0; i < dArray2.length; ++i) {
                    this.WriteBlockDouble(dArray2[i]);
                }
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyFloat(String string, float f) throws IOException {
        this.WriteBlockByte((byte)12);
        this.WriteBlockUTF(this.prefix + string);
        this.WriteBlockFloat(f);
        ++this.nrproperties;
    }

    public void writePropertyFloatArray(String string, float[] fArray) throws IOException {
        if (fArray != null) {
            this.WriteBlockByte((byte)18);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(fArray.length);
            for (float f : fArray) {
                this.WriteBlockFloat(f);
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyInt(String string, Integer n) throws IOException {
        if (n != null) {
            this.WriteBlockByte((byte)1);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(n);
            ++this.nrproperties;
        }
    }

    public void writePropertyIntArray(String string, int[] nArray) throws IOException {
        if (nArray != null) {
            this.WriteBlockByte((byte)7);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(nArray.length);
            for (int n : nArray) {
                this.WriteBlockInt(n);
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyIntArray(String string, int[][] nArray) throws IOException {
        if (nArray != null) {
            this.WriteBlockByte((byte)17);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(nArray.length);
            for (int[] nArray2 : nArray) {
                this.WriteBlockInt(nArray2.length);
                for (int i = 0; i < nArray2.length; ++i) {
                    this.WriteBlockInt(nArray2[i]);
                }
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyLong(String string, long l) throws IOException {
        this.WriteBlockByte((byte)2);
        this.WriteBlockUTF(this.prefix + string);
        this.WriteBlockLong(l);
        ++this.nrproperties;
    }

    public void writePropertyLongArray(String string, long[] lArray) throws IOException {
        if (lArray != null) {
            this.WriteBlockByte((byte)8);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(lArray.length);
            for (long l : lArray) {
                this.WriteBlockLong(l);
            }
            ++this.nrproperties;
        }
    }

    public void writePropertyNode(String string, DataTreeInterface dataTreeInterface) throws IOException {
        if (dataTreeInterface != null && dataTreeInterface.getID() != null) {
            this.writePropertyInt(string, dataTreeInterface.getID());
        }
    }

    public void writePropertyPoint(String string, Point point) throws IOException {
        if (point != null) {
            this.WriteBlockByte((byte)7);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(2);
            this.WriteBlockInt(point.x);
            this.WriteBlockInt(point.y);
            ++this.nrproperties;
        }
    }

    public void writePropertyStringUTF(String string, String string2) throws IOException {
        if (string2 != null) {
            this.WriteBlockByte((byte)4);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockUTF(string2);
            ++this.nrproperties;
        }
    }

    public void writePropertyStringUTFArray(String string, String[] stringArray) throws IOException {
        if (stringArray != null) {
            this.WriteBlockByte((byte)16);
            this.WriteBlockUTF(this.prefix + string);
            this.WriteBlockInt(stringArray.length);
            for (String string2 : stringArray) {
                this.WriteBlockUTF(string2);
            }
            ++this.nrproperties;
        }
    }

    public void writeUTF(String string) throws IOException {
        switch (this.accesstype) {
            case 0: {
                this.randomAccessFile.writeUTF(string);
                break;
            }
            case 1: {
                this.overidestream.writeUTF(string);
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        if (this.byteStream != null) {
            this.byteStream.reset();
        }
        this.byteStream = null;
    }

    private void flushBlockIfFull() throws IOException {
        if (this.accesstype == 0 && this.byteStream.size() > 2048) {
            this.write(this.byteStream.getArray(), 0, this.byteStream.size());
            this.byteStream.reset();
        }
    }

    private void initRandom() {
        this.byteStream = new RandomByteArrayOutputStream(4096);
    }
}

