/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.connection.Url;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.extclass.DynamicClass;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class ReportDialog
extends CleanUpDialog {
    private static final String[][] escape = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&amp;", "&"}, {"&quot;", "\""}, {"&agrave;", "\ufffd"}, {"&Agrave;", "\ufffd"}, {"&acirc;", "\ufffd"}, {"&auml;", "\u00e4"}, {"&Auml;", "\u00c4"}, {"&Acirc;", "\ufffd"}, {"&aring;", "\u00e5"}, {"&Aring;", "\u00c5"}, {"&aelig;", "\ufffd"}, {"&AElig;", "\ufffd"}, {"&ccedil;", "\ufffd"}, {"&Ccedil;", "\ufffd"}, {"&eacute;", "\ufffd"}, {"&Eacute;", "\ufffd"}, {"&egrave;", "\ufffd"}, {"&Egrave;", "\ufffd"}, {"&ecirc;", "\ufffd"}, {"&Ecirc;", "\ufffd"}, {"&euml;", "\ufffd"}, {"&Euml;", "\ufffd"}, {"&iuml;", "\ufffd"}, {"&Iuml;", "\ufffd"}, {"&ocirc;", "\ufffd"}, {"&Ocirc;", "\ufffd"}, {"&ouml;", "\u00f6"}, {"&Ouml;", "\u00d6"}, {"&oslash;", "\ufffd"}, {"&Oslash;", "\ufffd"}, {"&szlig;", "\ufffd"}, {"&ugrave;", "\ufffd"}, {"&Ugrave;", "\ufffd"}, {"&ucirc;", "\ufffd"}, {"&Ucirc;", "\ufffd"}, {"&uuml;", "\ufffd"}, {"&Uuml;", "\ufffd"}, {"&nbsp;", " "}, {"&reg;", "\u00a9"}, {"&copy;", "\u00ae"}, {"&euro;", "\u20a0"}};
    protected JPanel mainPanel = new JPanel(new BorderLayout());
    protected JPanel detailPanel = new JPanel(new BorderLayout());
    protected JTextArea messageArea = new JTextArea();
    protected JTextField subjectField = new JTextField();
    protected JTextArea informationArea = new JTextArea();
    protected JComboBox typeComboBox = new JComboBox();

    public ReportDialog(JDialog jDialog, String string) {
        super(jDialog, string, true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public ReportDialog(JFrame jFrame) {
        this(jFrame, "Report Dialog");
    }

    public ReportDialog(JFrame jFrame, String string) {
        super(jFrame, string, true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    protected void cleanUpChild() {
    }

    protected String encode(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            if (c == '\n') {
                stringBuilder.append("<br>");
                continue;
            }
            if (c == '\r') continue;
            for (String[] stringArray : escape) {
                if (stringArray[1].charAt(0) != c) continue;
                stringBuilder.append(stringArray[0]);
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        return URLEncoder.encode(stringBuilder.toString(), StandardCharsets.UTF_8);
    }

    protected String getAnonymousScript() {
        return "";
    }

    protected String getInformationText() {
        return "Subject: " + this.subjectField.getText() + "\n" + this.informationArea.getText();
    }

    protected StringBuilder getMessageString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("subject=");
        stringBuilder.append(this.encode(this.subjectField.getText()));
        stringBuilder.append("&type=").append(this.typeComboBox.getSelectedIndex());
        stringBuilder.append("&comments=").append(this.encode(this.messageArea.getText()));
        stringBuilder.append("&os=").append(this.encode(System.getProperty("os.name")));
        stringBuilder.append(" ").append(System.getProperty("os.version"));
        stringBuilder.append("&version=");
        stringBuilder.append("Version " + InitClass.GetVersionString() + "\n");
        Iterator<DynamicClass> iterator = ExtClassLoader.getInitInterfaceIterator();
        while (iterator.hasNext()) {
            stringBuilder.append(this.encode("\n"));
            object = iterator.next();
            stringBuilder.append(this.encode(((DynamicClass)object).getName())).append(" ").append(((DynamicClass)object).getVersion());
        }
        stringBuilder.append("&build=").append(this.encode(InitClass.getBuild()));
        stringBuilder.append("&jvm=").append(this.encode(System.getProperty("java.version")));
        stringBuilder.append("&stacktrace=").append(this.getStackTrace());
        stringBuilder.append("&script=").append(this.encode(this.getAnonymousScript()));
        object = RegisterKeyManager.getRegInfo();
        stringBuilder.append("&id=").append(((RegInfo)object).ID);
        return stringBuilder;
    }

    protected String getStackTrace() {
        return "";
    }

    protected void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        JButton jButton = new JButton("Don't Send");
        jButton.setForeground(new Color(100, 0, 0));
        jButton.addActionListener(actionEvent -> this.dispose());
        this.detailPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JButton jButton2 = new JButton("Send");
        jButton2.setForeground(new Color(0, 100, 0));
        jButton2.setToolTipText("");
        jButton2.addActionListener(actionEvent -> {
            try {
                Url url = new Url(IniManager.getUserPage("evince/errorreport.jsp"));
                DataOutputStream dataOutputStream = new DataOutputStream(url.getOutputStream());
                dataOutputStream.writeBytes(this.getMessageString().toString());
                dataOutputStream.flush();
                dataOutputStream.close();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.getInputStream()));
                while (bufferedReader.readLine() != null) {
                }
                bufferedReader.close();
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(Main_GUI.get(), "Thank you for submitting this information;\nit will be valuable in the continuing improvement\nof Evince.\n\t-The Evince Development Team", "Thank you", 1));
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
            this.dispose();
        });
        JLabel jLabel = new JLabel("<html><body><p>This is an error report system for Evince.<br>If you press send, only the data shown under Details is sent. This includes no personal information, so <b>if you want a reply from us, please add your e-mail address to the comments.</p></body></html>");
        jLabel.setFont(new Font("Dialog", 0, 11));
        jLabel.setBorder(new EmptyBorder(6, 6, 12, 6));
        this.subjectField.setText("Subject");
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel2 = new JLabel("Subject: ");
        this.typeComboBox.addItem("Error");
        this.typeComboBox.addItem("Feature");
        this.typeComboBox.addItem("Message");
        this.informationArea.setText("Information");
        this.informationArea.setEnabled(false);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Operating system: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version"));
        stringBuilder.append("\nJava version: ").append(System.getProperty("java.version"));
        stringBuilder.append("\nEvince version: ").append(InitClass.getEvinceVersion());
        this.informationArea.setText(stringBuilder.toString());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createLineBorder(new Color(153, 153, 153), 2);
        Border border2 = BorderFactory.createLineBorder(new Color(153, 153, 153), 2);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(new TitledBorder(border, "Information"));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setBorder(new TitledBorder(border2, "Comments"));
        jPanel3.setPreferredSize(new Dimension(380, 300));
        jPanel2.setPreferredSize(new Dimension(380, 120));
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setBorder(new EmptyBorder(0, 2, 2, 2));
        jPanel.setBorder(new EmptyBorder(2, 2, 0, 2));
        this.mainPanel.add((Component)this.detailPanel, "Center");
        this.mainPanel.add((Component)jPanel2, "South");
        jPanel.add((Component)this.subjectField, "Center");
        jPanel.add((Component)jLabel2, "West");
        jPanel.add((Component)this.typeComboBox, "East");
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 0, 6), 0, 0));
        jPanel2.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 6, 6, 6), 0, 0));
        jPanel2.add((Component)jButton2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 6, 6, 6), 0, 0));
        this.detailPanel.add((Component)jPanel3, "Center");
        this.detailPanel.add((Component)jPanel, "North");
        jScrollPane.getViewport().add(this.informationArea);
        jScrollPane2.getViewport().add(this.messageArea);
        jPanel3.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(2, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jScrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 100));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }
}

