/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common;

import java.io.IOException;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;

public class TreeHeader {
    public byte node;
    public byte type;
    public int extlibserial = -1;
    public byte tag = 0;
    public int id;
    public int crc;
    public long dataEnd;
    public long dataStart;
    private long pos;

    public TreeHeader() {
    }

    public TreeHeader(byte[] byArray, long l, int n, RandomInputStream.FileFramework fileFramework) throws IOException {
        int n2 = n;
        this.node = (byte)this.getByte(byArray, n2++);
        this.type = (byte)this.getByte(byArray, n2++);
        if (this.node == 5) {
            this.extlibserial = this.getInt(byArray, n2);
            n2 += 4;
            fileFramework.libraries.add(this.extlibserial);
        }
        this.tag = (byte)this.getByte(byArray, n2++);
        this.id = this.getInt(byArray, n2);
        this.crc = this.getInt(byArray, n2 += 4);
        n2 += 4;
        if (this.crc != 0xAAAAAA) {
            throw new IOException("CRC check error, this file contains errors");
        }
        this.dataEnd = this.getLong(byArray, n2);
        this.dataStart = l + (long)(n2 += 8);
    }

    public TreeHeader(DataTreeInterface dataTreeInterface) {
        this.node = dataTreeInterface.getNodeType();
        this.type = dataTreeInterface.getTreeType();
        if (dataTreeInterface.getNodeType() == 5) {
            DataTreeExtLibInterface dataTreeExtLibInterface = (DataTreeExtLibInterface)dataTreeInterface;
            this.extlibserial = dataTreeExtLibInterface.getLibrary().getSerial();
        }
        this.id = dataTreeInterface.getID();
    }

    public boolean isGuiNode() {
        return switch (this.node) {
            case 2, 6 -> true;
            case 5 -> {
                if (this.extlibserial == 1008 && this.type == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writeByte(this.node);
        randomOutputStream.writeByte(this.type);
        if (this.node == 5) {
            randomOutputStream.writeInt(this.extlibserial);
        }
        randomOutputStream.writeByte(this.tag);
        randomOutputStream.writeInt(this.id);
        this.pos = randomOutputStream.getFilePointer();
        randomOutputStream.writeInt(0);
        randomOutputStream.writeLong(0L);
    }

    public void writeCRC(RandomOutputStream randomOutputStream) throws IOException {
        long l = randomOutputStream.getFilePointer();
        randomOutputStream.seek(this.pos);
        randomOutputStream.writeInt(0xAAAAAA);
        randomOutputStream.writeLong(l);
        randomOutputStream.seek(l);
    }

    private int getByte(byte[] byArray, int n) {
        if (byArray[n] < 0) {
            return 256 + byArray[n];
        }
        return byArray[n];
    }

    private int getInt(byte[] byArray, int n) {
        return (this.getByte(byArray, n) << 24) + (this.getByte(byArray, n + 1) << 16) + (this.getByte(byArray, n + 2) << 8) + this.getByte(byArray, n + 3);
    }

    private long getLong(byte[] byArray, int n) {
        return ((long)this.getInt(byArray, n) << 32) + ((long)this.getInt(byArray, n + 4) & 0xFFFFFFFFL);
    }
}

