/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.awt;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Iterator;
import se.prediktera.map.common.awt.MultiPointGradientContext;

public class MultiPointGradient
implements Paint {
    private final boolean horizontal;
    private final ArrayList<ColoredPoint> points = new ArrayList();

    public MultiPointGradient(boolean bl) {
        this.horizontal = bl;
    }

    public void addPoint(double d, Color color) {
        if (this.points.size() > 1) {
            ColoredPoint coloredPoint = this.points.get(this.points.size() - 1);
            ColoredPoint coloredPoint2 = this.points.get(this.points.size() - 2);
            if (coloredPoint.color == coloredPoint2.color && coloredPoint.color == color) {
                coloredPoint.coord = d;
                return;
            }
        }
        this.points.add(new ColoredPoint(d, color));
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new MultiPointGradientContext(this.horizontal, this.points, affineTransform);
    }

    public double getEndCoord() {
        if (this.points.size() > 0) {
            return this.points.get((int)(this.points.size() - 1)).coord;
        }
        return 0.0;
    }

    public Color getSingleColor() {
        Color color;
        Color color2;
        if (this.points.size() == 1) {
            return this.points.get((int)0).color;
        }
        if (this.points.size() == 2 && (color2 = this.points.get((int)0).color).equals(color = this.points.get((int)1).color)) {
            return color2;
        }
        return null;
    }

    public double getStartCoord() {
        if (this.points.size() > 0) {
            return this.points.get((int)0).coord;
        }
        return 0.0;
    }

    @Override
    public int getTransparency() {
        return 1;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public Iterator pointIterator() {
        return this.points.iterator();
    }

    public static class ColoredPoint {
        public double coord;
        public Color color;

        public ColoredPoint(double d, Color color) {
            this.coord = d;
            this.color = color;
        }
    }
}

