/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import se.prediktera.map.common.awt.MultiPointGradient;

public class MultiPointGradientContext
implements PaintContext {
    private final boolean horizontal;
    private ArrayList<MultiPointGradient.ColoredPoint> points = new ArrayList();
    private ColorModel cm = ColorModel.getRGBdefault();
    private AffineTransform inverse;
    private Point2D xvec = new Point2D.Double(1.0, 0.0);
    private Point2D yvec = new Point2D.Double(0.0, 1.0);
    private WritableRaster raster = null;
    private MultiPointGradient.ColoredPoint p1 = null;
    private MultiPointGradient.ColoredPoint p2 = null;

    public MultiPointGradientContext(boolean bl, ArrayList<MultiPointGradient.ColoredPoint> arrayList, AffineTransform affineTransform) {
        this.horizontal = bl;
        this.points = arrayList;
        try {
            this.inverse = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.inverse = new AffineTransform();
        }
        this.inverse.deltaTransform(this.xvec, this.xvec);
        this.inverse.deltaTransform(this.yvec, this.yvec);
    }

    @Override
    public void dispose() {
        this.points = null;
        this.cm = null;
        this.inverse = null;
        this.xvec = null;
        this.yvec = null;
    }

    @Override
    public ColorModel getColorModel() {
        return this.cm;
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.raster == null || this.raster.getWidth() < n3 || this.raster.getHeight() < n4) {
            this.raster = this.cm.createCompatibleWritableRaster(n3, n4);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)this.raster.getDataBuffer();
        int n5 = dataBufferInt.getOffset();
        int[] nArray = dataBufferInt.getData();
        Point2D.Double double_ = new Point2D.Double(n, n2);
        this.inverse.transform(double_, double_);
        double d = ((Point2D)double_).getY();
        double d2 = ((Point2D)double_).getX();
        if (this.horizontal) {
            for (int i = 0; i < n3; ++i) {
                int n6 = this.getColor(d2 + (double)i * this.xvec.getX(), 0.0);
                for (int j = 0; j < n4; ++j) {
                    nArray[n5 + j * n3] = n6;
                }
                ++n5;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                int n7 = this.getColor(0.0, d + (double)i * this.yvec.getY());
                for (int j = 0; j < n3; ++j) {
                    nArray[n5++] = n7;
                }
            }
        }
        return this.raster;
    }

    private int getColor(double d, double d2) {
        double d3;
        double d4 = d3 = this.horizontal ? d : d2;
        if (this.p1 == null || this.p2 == null || d3 < this.p1.coord || d3 > this.p2.coord) {
            this.p2 = null;
            this.p1 = null;
            for (MultiPointGradient.ColoredPoint coloredPoint : this.points) {
                if (this.p1 == null || d3 >= coloredPoint.coord) {
                    this.p1 = coloredPoint;
                }
                if (!(d3 <= coloredPoint.coord)) continue;
                this.p2 = coloredPoint;
                break;
            }
        }
        if (this.p1 == null && this.p2 == null) {
            return Color.black.getRGB();
        }
        if (this.p1 == null || this.p1 == this.p2) {
            return this.p2.color.getRGB();
        }
        if (this.p2 == null || this.p1.color == this.p2.color) {
            return this.p1.color.getRGB();
        }
        double d5 = (d3 - this.p1.coord) / (this.p2.coord - this.p1.coord);
        int n = (int)(d5 * (double)this.p2.color.getRed() + (1.0 - d5) * (double)this.p1.color.getRed());
        int n2 = (int)(d5 * (double)this.p2.color.getGreen() + (1.0 - d5) * (double)this.p1.color.getGreen());
        int n3 = (int)(d5 * (double)this.p2.color.getBlue() + (1.0 - d5) * (double)this.p1.color.getBlue());
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }
}

