/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.awt;

import java.awt.Paint;
import java.util.Iterator;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.prediktera.map.common.awt.MultiPointGradient;

public class SVGExtensionHandler
extends DefaultExtensionHandler {
    public SVGPaintDescriptor handlePaint(Paint paint, SVGGeneratorContext sVGGeneratorContext) {
        if (paint instanceof MultiPointGradient) {
            MultiPointGradient multiPointGradient = (MultiPointGradient)paint;
            String string = sVGGeneratorContext.getIDGenerator().generateID("gradient");
            Document document = sVGGeneratorContext.getDOMFactory();
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
            element.setAttributeNS(null, "gradientUnits", "objectBoundingBox");
            element.setAttributeNS(null, "id", string);
            element.setAttributeNS(null, "x1", "0%");
            element.setAttributeNS(null, "y1", "0%");
            if (multiPointGradient.isHorizontal()) {
                element.setAttributeNS(null, "x2", "100%");
                element.setAttributeNS(null, "y2", "0%");
            } else {
                element.setAttributeNS(null, "x2", "0%");
                element.setAttributeNS(null, "y2", "100%");
            }
            double d = multiPointGradient.getStartCoord();
            double d2 = multiPointGradient.getEndCoord();
            double d3 = d2 - d;
            Iterator iterator = multiPointGradient.pointIterator();
            while (iterator.hasNext()) {
                MultiPointGradient.ColoredPoint coloredPoint = (MultiPointGradient.ColoredPoint)iterator.next();
                Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "stop");
                if (d3 > 0.0) {
                    element2.setAttributeNS(null, "offset", 100.0 * (coloredPoint.coord - d) / d3 + "%");
                } else {
                    element2.setAttributeNS(null, "offset", "0%");
                }
                element2.setAttributeNS(null, "stop-color", "rgb(" + coloredPoint.color.getRed() + "," + coloredPoint.color.getGreen() + "," + coloredPoint.color.getBlue() + ")");
                element.appendChild(element2);
            }
            return new SVGPaintDescriptor("url(#" + string + ")", "1", element);
        }
        return null;
    }
}

