/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.cleanup;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.IniManager;

public abstract class CleanUpDialog
extends JDialog
implements CleanUpInterface {
    protected static int dialogIndx = 1;
    private boolean hascleanup = false;

    public CleanUpDialog() {
        this((Frame)null, "No title", false);
    }

    public CleanUpDialog(Frame frame, boolean bl) {
        this(frame, "No title", bl);
    }

    public CleanUpDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public CleanUpDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public CleanUpDialog(JDialog jDialog, String string) {
        this(jDialog, string, false);
    }

    public CleanUpDialog(JDialog jDialog, String string, boolean bl) {
        super(jDialog, string, bl);
    }

    public CleanUpDialog(Window window, String string) {
        super(window, string);
    }

    @Override
    public final synchronized boolean cleanUp() {
        if (this.hascleanup) {
            return true;
        }
        this.hascleanup = true;
        this.removeAll();
        this.cleanUpChild();
        SwingUtilities.invokeLater(() -> {
            try {
                this.dispose();
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        });
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        IniManager.setHelpWindow(null);
    }

    @Override
    public boolean isCleaned() {
        return this.hascleanup;
    }

    @Override
    public void pack() {
        super.pack();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setMinimumSize((Dimension)jPanel.getSize().clone());
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IniManager.setHelpWindow(this);
        }
        super.setVisible(bl);
    }

    protected abstract void cleanUpChild();

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = actionEvent -> this.dispose();
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }
}

