/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import se.prediktera.map.common.connection.Base64;
import se.prediktera.map.main.IniManager;

public class Url {
    private final URLConnection connection;

    private static void setSystemProxy() {
        Properties properties = System.getProperties();
        if (IniManager.hasProxy()) {
            properties.remove("java.net.useSystemProxies");
            properties.setProperty("http.proxyHost", IniManager.getProxyHost());
            properties.setProperty("http.proxyPort", IniManager.getProxyPort());
            if (IniManager.hasAuthentication()) {
                properties.setProperty("http.proxyUser", IniManager.getProxyUser());
                properties.setProperty("http.proxyPassword", IniManager.getProxyPassword());
            }
        } else {
            properties.setProperty("java.net.useSystemProxies", "true");
            properties.remove("http.proxyHost");
            properties.remove("http.proxyPort");
            properties.remove("http.proxyUser");
            properties.remove("http.proxyPassword");
        }
    }

    public Url(String string) throws MalformedURLException, IOException {
        this(string, true, true);
    }

    public Url(String string, boolean bl, boolean bl2) throws MalformedURLException, IOException {
        URL uRL;
        Url.setSystemProxy();
        try {
            uRL = new URI(string).toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        this.connection = uRL.openConnection();
        this.connection.setDoInput(bl);
        this.connection.setDoOutput(bl2);
        this.connection.setUseCaches(false);
        if (IniManager.hasProxy() && IniManager.hasAuthentication()) {
            String string2 = IniManager.getProxyUser() + ":" + IniManager.getProxyPassword();
            String string3 = Base64.encodeBytes(string2.getBytes());
            this.connection.setRequestProperty("Proxy-Authorization", "Basic " + string3);
        }
        this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        this.connection.connect();
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }
}

