/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.error;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import se.prediktera.map.common.ErrorDialog;
import se.prediktera.map.common.error.ErrorUploader;
import se.prediktera.map.common.error.LogExtraExceptionInterface;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.IniManager;

public class ErrorHandler {
    private static Optional<ErrorUploader> errorUploader = Optional.empty();
    private static ProductType productType;
    private static Optional<ScreenshotCallback> screenshotCallback;
    private static Optional<OnExceptionCallback> onUncaughtExceptionCallback;
    private static boolean reportEventQueueExceptions;

    public static void setProductType(ProductType productType) {
        ErrorHandler.productType = productType;
    }

    public static void setScreenshotCallback(ScreenshotCallback screenshotCallback) {
        ErrorHandler.screenshotCallback = Optional.of(screenshotCallback);
    }

    public static void setErrorUploader(ErrorUploader errorUploader) {
        ErrorHandler.errorUploader = errorUploader != null ? Optional.of(errorUploader) : Optional.empty();
    }

    public static void setOnUncaughtExceptionCallback(OnExceptionCallback onExceptionCallback) {
        onUncaughtExceptionCallback = Optional.of(onExceptionCallback);
    }

    public static void clearUncaughtExceptionCallback() {
        onUncaughtExceptionCallback = Optional.empty();
    }

    public static void registerUncaughtExceptionHandlingForAllThreadsAndEventQueue() {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> ErrorHandler.handleUncaughtException(throwable));
        reportEventQueueExceptions = true;
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){

            @Override
            public void dispatchEvent(AWTEvent aWTEvent) {
                block4: {
                    try {
                        super.dispatchEvent(aWTEvent);
                    }
                    catch (Throwable throwable) {
                        if (!reportEventQueueExceptions) break block4;
                        if (productType == ProductType.EVINCE) {
                            ErrorHandler.handleUncaughtAndShowEvinceErrorDialogForException(throwable);
                        }
                        if (productType == ProductType.BREEZE) {
                            ErrorHandler.handleUncaughtException(throwable);
                        }
                        ErrorHandler.handleUncaughtException(throwable);
                    }
                }
            }
        });
    }

    public static void removeUncaughtExceptionHandlingForAllThreadsAndEventQueue() {
        Thread.setDefaultUncaughtExceptionHandler(null);
        reportEventQueueExceptions = false;
    }

    public static void handleUncaughtException(Throwable throwable) {
        if (onUncaughtExceptionCallback.isPresent() && !ErrorHandler.invokeOnExceptionCallback(onUncaughtExceptionCallback, throwable)) {
            return;
        }
        if (!(throwable instanceof InformationMessageException)) {
            if (throwable instanceof MessageException) {
                ErrorHandler.logException("Message exception occurred", throwable, ErrorHandler.generateExceptionId());
            } else {
                ErrorHandler.logAndReportException("Uncaught exception occurred", throwable);
            }
        }
    }

    public static void handleUncaughtAndShowEvinceErrorDialogForException(Throwable throwable) {
        if (onUncaughtExceptionCallback.isPresent()) {
            ErrorHandler.invokeOnExceptionCallback(onUncaughtExceptionCallback, throwable);
        }
        ErrorHandler.logAndReportException("Uncaught exception occurred", throwable);
        ErrorDialog.showErrorDialog(throwable);
    }

    public static String logAndReportException(Throwable throwable) {
        return ErrorHandler.logAndReportException("Exception occurred", throwable);
    }

    public static String logAndReportException(String string, Throwable throwable) {
        String string2 = ErrorHandler.generateExceptionId();
        try {
            string = ErrorHandler.logException(string, throwable, string2);
            File file = null;
            if (screenshotCallback.isPresent()) {
                file = ErrorHandler.tryGrabAndSaveScreeenshot(screenshotCallback.get(), throwable, string2);
            }
            if (file != null && errorUploader.isPresent()) {
                errorUploader.get().uploadThrowable(productType, string, file, throwable);
            }
        }
        catch (Throwable throwable2) {
            Logg.error("Exception occurred while logging error", throwable2);
            Logg.error("Exception that was reported when error happened was", throwable);
        }
        return string2;
    }

    private static String logException(String object, Throwable throwable, String string) {
        object = (String)object + " - exception ID: " + string;
        if (throwable instanceof LogExtraExceptionInterface) {
            object = (String)object + " - Extra information: " + ((LogExtraExceptionInterface)((Object)throwable)).getExtraInformation();
        }
        Logg.error((String)object, throwable);
        return object;
    }

    public static void logAndShowEvinceErrorDialogForException(Throwable throwable) {
        if (productType != ProductType.EVINCE) {
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw new RuntimeException(throwable);
        }
        ErrorHandler.logAndReportException("Exception occurred", throwable);
        ErrorDialog.showErrorDialog(throwable);
    }

    private static boolean invokeOnExceptionCallback(Optional<OnExceptionCallback> optional, Throwable throwable) {
        try {
            return optional.get().onException(throwable);
        }
        catch (Throwable throwable2) {
            Logg.error("Exception occurred while invoking uncaught exception callback (normally used for error dialog), proceeding to log exception", throwable2);
            return false;
        }
    }

    public static String generateExceptionId() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    public static File tryGrabAndSaveScreeenshot(ScreenshotCallback screenshotCallback, Throwable throwable, String string) {
        try {
            return ErrorHandler.grabAndSaveScreenshot(screenshotCallback, throwable, string);
        }
        catch (Throwable throwable2) {
            Logg.warn("Exception occurred while grabbing screenshot for error report", throwable2);
            return null;
        }
    }

    public static File grabAndSaveScreenshot(ScreenshotCallback screenshotCallback, Throwable throwable, String string) {
        String string2 = new Object(){}.getClass().getEnclosingMethod().getName();
        if (ErrorHandler.grabAndSaveScreenshotAlreadyExistsInStack(string2, throwable)) {
            throw new RuntimeException("Cant take screenshot for exception because screenshot grab is causing an infinite reporting loop", throwable);
        }
        String string3 = "error-screenshot-" + string + ".png";
        BufferedImage bufferedImage = screenshotCallback.takeScreenshot();
        if (bufferedImage != null) {
            try {
                File file = new File(IniManager.getOrCreatePredikteraDir(productType == ProductType.BREEZE ? UpdateHelper.Product.Breeze : UpdateHelper.Product.Evince), "error-screenshots");
                if (!file.exists() && !file.mkdirs()) {
                    throw new RuntimeException(new IOException("Could not create screenshot directory at " + file.getAbsolutePath()));
                }
                File file2 = new File(file, string3);
                ImageIO.write((RenderedImage)bufferedImage, "png", file2);
                return file2;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    private static boolean grabAndSaveScreenshotAlreadyExistsInStack(String string, Throwable throwable) {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(ErrorHandler.class.getName()) || !stackTraceElement.getMethodName().equals(string)) continue;
            return true;
        }
        return false;
    }

    static {
        screenshotCallback = Optional.empty();
        onUncaughtExceptionCallback = Optional.empty();
    }

    public static enum ProductType {
        BREEZE,
        EVINCE;

    }

    public static class InformationMessageException
    extends MessageException {
        public InformationMessageException(String string) {
            this(string, "Information");
        }

        public InformationMessageException(String string, String string2) {
            super(string, string2);
        }

        @Override
        public int getOptionType() {
            return 1;
        }
    }

    public static class MessageException
    extends RuntimeException {
        private String title = "Error";

        public MessageException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public MessageException(String string, String string2) {
            super(string);
            this.title = string2;
        }

        public MessageException(Throwable throwable) {
            super(throwable);
        }

        public String getTitle() {
            return this.title;
        }

        public static String getTitle(Exception exception, String string) {
            if (exception instanceof MessageException) {
                return ((MessageException)exception).getTitle();
            }
            return string;
        }

        public int getOptionType() {
            return 0;
        }
    }

    public static interface ScreenshotCallback {
        public BufferedImage takeScreenshot();
    }

    public static interface OnExceptionCallback {
        public boolean onException(Throwable var1);
    }

    public static class ErrorMessageException
    extends MessageException {
        public ErrorMessageException(String string) {
            this(string, "Error");
        }

        public ErrorMessageException(String string, String string2) {
            super(string, string2);
        }
    }

    public static class WarningMessageException
    extends MessageException {
        public WarningMessageException(String string) {
            this(string, "Warning");
        }

        public WarningMessageException(String string, String string2) {
            super(string, string2);
        }

        @Override
        public int getOptionType() {
            return 2;
        }
    }
}

