/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.interaction;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;

public class InteractionGroup
extends DataTreeClass {
    public static final int BASEGROUP = 0;
    private InteractionArray observationInteractionArray = null;
    private InteractionArray variableInteractionArray = null;
    private InteractionArray componentInteractionArray = null;
    private InteractionArray statisticInteractionArray = null;
    private InteractionArray referenceInteractionArray = null;
    private final int groupID;

    public InteractionGroup(int n) {
        super("Interaction Group");
        this.groupID = n;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public void setInteractionRoot(DataTreeInterface dataTreeInterface) {
        for (InteractionArray interactionArray : this.getArrays()) {
            if (interactionArray == null) continue;
            interactionArray.reset(dataTreeInterface);
        }
    }

    public DataTreeInterface getFirstInteractionRoot() {
        for (InteractionArray interactionArray : this.getArrays()) {
            if (interactionArray == null || interactionArray.getRoot() == null) continue;
            return interactionArray.getRoot();
        }
        return null;
    }

    public void clearInteractionArrays() {
        this.observationInteractionArray = null;
        this.variableInteractionArray = null;
        this.componentInteractionArray = null;
        this.statisticInteractionArray = null;
        this.referenceInteractionArray = null;
    }

    public InteractionArray getInteractionArray(DataTreeInterface dataTreeInterface, int n, int n2) {
        if (n == 1) {
            if (this.observationInteractionArray == null || this.observationInteractionArray.size() != n2) {
                this.observationInteractionArray = new InteractionArray(dataTreeInterface, n, n2);
            } else {
                this.observationInteractionArray.reset(dataTreeInterface);
            }
            return this.observationInteractionArray;
        }
        if (n == 2) {
            if (this.variableInteractionArray == null || this.variableInteractionArray.size() != n2) {
                this.variableInteractionArray = new InteractionArray(dataTreeInterface, n, n2);
            } else {
                this.variableInteractionArray.reset(dataTreeInterface);
            }
            return this.variableInteractionArray;
        }
        if (n == 8) {
            if (this.componentInteractionArray == null || this.componentInteractionArray.size() != n2) {
                this.componentInteractionArray = new InteractionArray(dataTreeInterface, n, n2);
            } else {
                this.componentInteractionArray.reset(dataTreeInterface);
            }
            return this.componentInteractionArray;
        }
        if (n == 4) {
            if (this.statisticInteractionArray == null || this.statisticInteractionArray.size() != n2) {
                this.statisticInteractionArray = new InteractionArray(dataTreeInterface, n, n2);
            } else {
                this.statisticInteractionArray.reset(dataTreeInterface);
            }
            return this.statisticInteractionArray;
        }
        if (n == 64) {
            if (this.referenceInteractionArray == null || this.referenceInteractionArray.size() != n2) {
                this.referenceInteractionArray = new InteractionArray(dataTreeInterface, n, n2);
            } else {
                this.referenceInteractionArray.reset(dataTreeInterface);
            }
            return this.referenceInteractionArray;
        }
        return null;
    }

    public InteractionArray getInteractionArray(int n) {
        if (n == 1) {
            return this.observationInteractionArray;
        }
        if (n == 2) {
            return this.variableInteractionArray;
        }
        if (n == 8) {
            return this.componentInteractionArray;
        }
        if (n == 4) {
            return this.statisticInteractionArray;
        }
        if (n == 64) {
            return this.referenceInteractionArray;
        }
        return null;
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    private List<InteractionArray> getArrays() {
        return Arrays.asList(this.observationInteractionArray, this.variableInteractionArray, this.componentInteractionArray, this.statisticInteractionArray, this.referenceInteractionArray);
    }
}

