/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.interaction;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.main.window.AbstractWindow;

public class InteractionProperties
extends CleanUpPanel {
    private final JCheckBox checkInteractive = new JCheckBox("Activate interaction");
    private final JCheckBox checkInteractiveVisible = new JCheckBox("Show only selected data");
    private final JCheckBox checkInteractionByAncestor = new JCheckBox("Interaction is only between related data");
    private AbstractInit abstractInit;

    public InteractionProperties() {
        this((AbstractWindow)null);
    }

    public InteractionProperties(AbstractWindow abstractWindow) {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Options"));
        this.checkInteractive.setFont(new Font("Dialog", 0, 10));
        this.checkInteractionByAncestor.setFont(new Font("Dialog", 0, 10));
        this.checkInteractionByAncestor.setMargin(new Insets(2, 2, 2, 2));
        this.checkInteractionByAncestor.setSelected(true);
        this.checkInteractiveVisible.setFont(new Font("Dialog", 0, 10));
        this.add((Component)jPanel, "Center");
        InteractivityChangedListener interactivityChangedListener = new InteractivityChangedListener();
        this.checkInteractive.addItemListener(itemEvent -> {
            this.checkInteractiveVisible.setEnabled(this.checkInteractive.isSelected());
            this.checkInteractionByAncestor.setEnabled(this.checkInteractive.isSelected());
        });
        this.checkInteractive.addItemListener(interactivityChangedListener);
        this.checkInteractiveVisible.setToolTipText(null);
        this.checkInteractiveVisible.addItemListener(interactivityChangedListener);
        if (abstractWindow == null) {
            this.checkInteractive.setSelected(true);
        } else {
            this.checkInteractive.setSelected(abstractWindow.hasInteractivity());
            this.checkInteractiveVisible.setSelected(abstractWindow.showOnlySelected());
        }
        jPanel.add((Component)this.checkInteractive, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.checkInteractiveVisible, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 20, 0, 5), 0, 0));
    }

    public void applyChanges(AbstractWindow abstractWindow) {
        if (abstractWindow != null && abstractWindow.getInteractionFlag() != this.getInteractionFlag()) {
            abstractWindow.setInteractionFlag(this.getInteractionFlag());
        }
    }

    public void beginWizard(AbstractInit abstractInit) {
        this.abstractInit = abstractInit;
        this.setInteractionFlag(abstractInit.interactionFlag);
    }

    public byte getInteractionFlag() {
        if (!this.checkInteractive.isSelected()) {
            return 0;
        }
        if (this.checkInteractiveVisible.isSelected()) {
            return 2;
        }
        return 1;
    }

    public boolean hasInteractionByAncestor() {
        return this.checkInteractionByAncestor.isSelected();
    }

    public boolean hasInteractivity() {
        return this.checkInteractive.isSelected();
    }

    public void setInteractionFlag(byte by) {
        switch (by) {
            case 1: {
                this.checkInteractive.setSelected(true);
                this.checkInteractiveVisible.setSelected(false);
                break;
            }
            case 2: {
                this.checkInteractive.setSelected(true);
                this.checkInteractiveVisible.setSelected(true);
                break;
            }
            default: {
                this.checkInteractive.setSelected(false);
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        this.abstractInit = null;
    }

    class InteractivityChangedListener
    implements ItemListener {
        InteractivityChangedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (InteractionProperties.this.abstractInit != null) {
                InteractionProperties.this.abstractInit.interactionFlag = InteractionProperties.this.getInteractionFlag();
            }
        }
    }
}

