/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.jama;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.mtj.DenseMatrixFloat;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;

public class MatrixExtensions {
    public static final DenseMatrix arrayRightDivide(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = new DenseMatrix((Matrix)denseMatrix);
        MatrixExtensions.arrayRightDivide(denseMatrix3.getData(), denseMatrix2.getData());
        return denseMatrix3;
    }

    public static final DenseVector arrayRightDivide(DenseVector denseVector, DenseVector denseVector2) {
        DenseVector denseVector3 = new DenseVector((Vector)denseVector);
        MatrixExtensions.arrayRightDivide(denseVector3.getData(), denseVector2.getData());
        return denseVector3;
    }

    public static final void minusEqualsTimesTransposeOf(AbstractMVmatrix abstractMVmatrix, DenseVector denseVector, DenseVector denseVector2) {
        MatrixExtensions.plusEqualsTimesTransposeOf(abstractMVmatrix, denseVector, denseVector2, -1.0);
    }

    public static final DenseVector mult(DenseVector denseVector, final Matrix matrix, DenseVector denseVector2) {
        final double[] dArray = denseVector.getData();
        final double[] dArray2 = denseVector2.getData();
        final int n = dArray.length;
        final int n2 = dArray2.length;
        if (matrix instanceof DenseMatrixFloat) {
            DenseMatrixFloat denseMatrixFloat = (DenseMatrixFloat)matrix;
            final float[] fArray = denseMatrixFloat.data;
            Threader threader = new Threader(){

                @Override
                protected void doOp(boolean bl, int n5, int n22) {
                    for (int i = n5; i < n22; ++i) {
                        double d = 0.0;
                        int n3 = 0;
                        int n4 = 0;
                        while (n3 < n2) {
                            d += (double)fArray[i + n4] * dArray2[n3];
                            ++n3;
                            n4 += n;
                        }
                        dArray[i] = d;
                    }
                }
            };
            threader.execute(n);
        } else {
            Threader threader = new Threader(){

                @Override
                protected void doOp(boolean bl, int n, int n22) {
                    for (int i = n; i < n22; ++i) {
                        double d = 0.0;
                        for (int j = 0; j < n2; ++j) {
                            d += matrix.get(i, j) * dArray2[j];
                        }
                        dArray[i] = d;
                    }
                }
            };
            threader.execute(n);
        }
        return denseVector;
    }

    public static final void plusEqualsTimesTransposeOf(AbstractMVmatrix abstractMVmatrix, DenseVector denseVector, DenseVector denseVector2) {
        MatrixExtensions.plusEqualsTimesTransposeOf(abstractMVmatrix, denseVector, denseVector2, 1.0);
    }

    public static final void plusEqualsTimesTransposeOf(AbstractMVmatrix abstractMVmatrix, DenseVector denseVector, DenseVector denseVector2, final double d) {
        final int n = abstractMVmatrix.getN();
        int n2 = abstractMVmatrix.getK();
        final Matrix matrix = abstractMVmatrix.getInternalMatrixPublic();
        final boolean[][] blArray = abstractMVmatrix.getMissingMatrix();
        final double[] dArray = denseVector.getData();
        final double[] dArray2 = denseVector2.getData();
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n3, int n2) {
                if (blArray != null) {
                    for (int i = n3; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            if (blArray[j][i]) continue;
                            matrix.add(j, i, d * dArray[j] * dArray2[i]);
                        }
                    }
                } else {
                    for (int i = n3; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            matrix.add(j, i, d * dArray[j] * dArray2[i]);
                        }
                    }
                }
            }
        };
        threader.execute(n2);
        abstractMVmatrix.setUpdated();
    }

    public static final DenseMatrix timesTransposeOf(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = new DenseMatrix(denseMatrix.numRows(), denseMatrix2.numRows());
        return (DenseMatrix)denseMatrix.transBmult((Matrix)denseMatrix2, (Matrix)denseMatrix3);
    }

    public static final DenseMatrix timesTransposeOf(DenseVector denseVector, DenseVector denseVector2) {
        DenseMatrix denseMatrix = new DenseMatrix(denseVector.size(), denseVector2.size());
        return (DenseMatrix)new DenseMatrix((Vector)denseVector, false).transBmult((Matrix)new DenseMatrix((Vector)denseVector2, false), (Matrix)denseMatrix);
    }

    public static final DenseMatrix timesTransposeOf(MatrixContainer matrixContainer, int n, DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        MVmatrix mVmatrix = matrixContainer.getMatrixCount() <= n ? matrixContainer.addMatrix(new DenseMatrix(denseMatrix.numRows(), denseMatrix2.numRows())) : (MVmatrix)matrixContainer.getMatrixAt(n);
        mVmatrix.resize(denseMatrix.numRows(), denseMatrix2.numRows());
        DenseMatrix denseMatrix3 = mVmatrix.getDoubleMatrix();
        denseMatrix.transBmult((Matrix)denseMatrix2, (Matrix)denseMatrix3);
        return denseMatrix3;
    }

    public static final DenseMatrix timesTransposeOf(MatrixContainer matrixContainer, int n, DenseVector denseVector, DenseVector denseVector2) {
        MVmatrix mVmatrix = matrixContainer.getMatrixCount() <= n ? matrixContainer.addMatrix(new DenseMatrix(denseVector.size(), denseVector2.size())) : (MVmatrix)matrixContainer.getMatrixAt(n);
        mVmatrix.resize(denseVector.size(), denseVector2.size());
        DenseMatrix denseMatrix = mVmatrix.getDoubleMatrix();
        new DenseMatrix((Vector)denseVector, false).transBmult((Matrix)new DenseMatrix((Vector)denseVector2, false), (Matrix)denseMatrix);
        return denseMatrix;
    }

    public static final DenseVector transMult(DenseVector denseVector, final Matrix matrix, DenseVector denseVector2) {
        final double[] dArray = denseVector.getData();
        final double[] dArray2 = denseVector2.getData();
        final int n = dArray2.length;
        int n2 = dArray.length;
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n3, int n2) {
                for (int i = n3; i < n2; ++i) {
                    double d = 0.0;
                    for (int j = 0; j < n; ++j) {
                        d += matrix.get(j, i) * dArray2[j];
                    }
                    dArray[i] = d;
                }
            }
        };
        threader.execute(n2);
        return denseVector;
    }

    public static final DenseMatrix transposedTimes(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        DenseMatrix denseMatrix3 = new DenseMatrix(denseMatrix.numColumns(), denseMatrix2.numColumns());
        return (DenseMatrix)denseMatrix.transAmult((Matrix)denseMatrix2, (Matrix)denseMatrix3);
    }

    private static final void arrayRightDivide(final double[] dArray, final double[] dArray2) {
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n, int n2) {
                for (int i = n; i < n2; ++i) {
                    int n3 = i;
                    dArray[n3] = dArray[n3] / dArray2[i];
                }
            }
        };
        threader.execute(dArray.length);
    }

    private MatrixExtensions() {
    }
}

